/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative;

import com.fureniku.metropolis.blocks.IToggleable;
import com.fureniku.metropolis.blocks.MetroBlockBase;
import com.fureniku.metropolis.blocks.decorative.helpers.ConnectHorizontalHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBase;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBlockstate;
import com.fureniku.metropolis.blocks.decorative.helpers.OffsetHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.RotationHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.ToggleHelper;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.utils.Debug;
import com.fureniku.metropolis.utils.SimpleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public abstract class MetroBlockDecorativeBase
extends MetroBlockBase
implements IToggleable {
    private final VoxelShape BLOCK_SHAPE;
    protected TextureSet[] _resources;
    protected String _modelName;
    protected String _modelDir;
    protected RotationHelper _rotationHelper;
    protected ToggleHelper _toggleHelper;
    protected ConnectHorizontalHelper _connectHorizontalHelper;
    protected OffsetHelper _offsetHelper;

    public MetroBlockDecorativeBase(BlockBehaviour.Properties props, VoxelShape shape, String modelDir, String modelName, String tag, boolean dynamicShape, TextureSet ... textures) {
        super(dynamicShape ? props.m_60988_() : props);
        this.BLOCK_SHAPE = shape != null ? shape : Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this._resources = textures;
        this._modelDir = modelDir;
        this._modelName = modelName;
        this.setTag(tag);
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        for (int i = 0; i < this._helpers.size(); ++i) {
            defaultState = ((HelperBase)this._helpers.get(i)).setDefaultState(defaultState);
        }
        this.m_49959_(defaultState);
    }

    public static MetroBlockStateFactory getBlockFactory(final HelperBase ... helpersIn) {
        return (props, shape, modelDir, modelName, tag, dynamicShape, textures) -> new MetroBlockDecorativeBase(props, shape, modelDir, modelName, tag, SimpleUtils.containsType(OffsetHelper.class, helpersIn), textures){

            @Override
            public ArrayList<HelperBase> getHelpers() {
                return new ArrayList<HelperBase>(Arrays.asList(helpersIn));
            }
        };
    }

    public abstract ArrayList<HelperBase> getHelpers();

    public void setupHelpers(ArrayList<HelperBase> helpers) {
        for (int i = 0; i < helpers.size(); ++i) {
            this.assignHelper(helpers.get(i));
        }
        this._helpers = helpers;
    }

    public void assignHelper(HelperBase helper) {
        switch (helper.getType()) {
            case OFFSET: {
                this._offsetHelper = (OffsetHelper)helper;
                break;
            }
            case ROTATION: {
                this._rotationHelper = (RotationHelper)helper;
                break;
            }
            case TOGGLE: {
                this._toggleHelper = (ToggleHelper)helper;
                break;
            }
            case CONNECTION_HORIZONTAL: {
                this._connectHorizontalHelper = (ConnectHorizontalHelper)helper;
            }
        }
        if (this._rotationHelper != null && this._toggleHelper != null) {
            this._toggleHelper.setRotatable();
        }
    }

    @Override
    protected void createBlockState(StateDefinition.Builder<Block, BlockState> builder) {
        this.setupHelpers(this.getHelpers());
        if (this._helpers != null) {
            for (int i = 0; i < this._helpers.size(); ++i) {
                HelperBase helper = (HelperBase)this._helpers.get(i);
                if (!(helper instanceof HelperBlockstate)) continue;
                builder = ((HelperBlockstate)helper).addDefaultState(builder);
            }
        } else {
            Debug.LogError("Helpers array still null after setup. Blockstates will not work.", new Object[0]);
        }
    }

    @Override
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Block block = state.m_60734_();
        if (this._rotationHelper != null) {
            state = this._rotationHelper.getPlacementState(context, state, block);
        }
        if (this._connectHorizontalHelper != null) {
            state = this._connectHorizontalHelper.getPlacementState(context, state, block);
        }
        return state;
    }

    @Override
    protected VoxelShape getShapeFromBlockState(BlockState state) {
        if (this._rotationHelper == null || this._connectHorizontalHelper != null) {
            // empty if block
        }
        if (this._toggleHelper != null) {
            Direction dir = this._rotationHelper != null ? (Direction)state.m_61143_((Property)RotationHelper.DIRECTION) : Direction.UP;
            return this._toggleHelper.getShapeFromBlockState(state, dir);
        }
        if (this._rotationHelper != null) {
            return this._rotationHelper.getShapeFromBlockState(state);
        }
        if (this._connectHorizontalHelper != null) {
            return this._connectHorizontalHelper.getShapeFromBlockState(state);
        }
        return this.BLOCK_SHAPE;
    }

    @Override
    public void generateBlockState(RegistryObject<Block> blockRegistryObject, MetroBlockStateProvider blockStateProvider) {
        Block block = (Block)blockRegistryObject.get();
        BlockModelBuilder bmb = blockStateProvider.prepareModels(block, this._modelDir, this._modelName, this._resources);
        if (this._helpers.size() == 1) {
            if (this._helpers.get(0) instanceof HelperBlockstate) {
                ((HelperBlockstate)this._helpers.get(0)).generateBlockState(this._resources, this._modelDir, this._modelName, block, blockStateProvider);
                return;
            }
        } else {
            if (this._rotationHelper == null || this._connectHorizontalHelper != null) {
                // empty if block
            }
            if (this._toggleHelper != null) {
                if (this._rotationHelper != null) {
                    this._toggleHelper.generateBlockStateRotatable(this._resources, this._modelDir, this._modelName, block, blockStateProvider);
                } else {
                    this._toggleHelper.generateBlockState(this._resources, this._modelDir, this._modelName, block, blockStateProvider);
                }
                return;
            }
            if (this._rotationHelper != null) {
                this._rotationHelper.generateBlockState(this._resources, this._modelDir, this._modelName, block, blockStateProvider);
                return;
            }
            if (this._connectHorizontalHelper != null) {
                this._connectHorizontalHelper.generateBlockState(this._resources, this._modelDir, this._modelName, block, blockStateProvider);
                return;
            }
        }
        blockStateProvider.simpleBlock(block, (ModelFile)bmb);
        blockStateProvider.simpleBlockItem(block, (ModelFile)bmb);
    }

    @Override
    protected Vec3 getOffset(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (this._offsetHelper != null) {
            Vec3 offset = this._offsetHelper.getOffset(level, pos);
            blockState.f_271099_ = Optional.of((state, lvl, blockPos) -> offset);
            return offset;
        }
        return Vec3.f_82478_;
    }

    @Override
    public void onNeighbourChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos) {
        if (this._toggleHelper != null) {
            this._toggleHelper.neighbourChanged(state, level, pos, this);
        }
        if (this._connectHorizontalHelper != null) {
            this._connectHorizontalHelper.neighbourChanged(state, level, pos, this);
        }
    }

    @Override
    protected InteractionResult onRightClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (this._toggleHelper != null) {
            this._toggleHelper.rightClick(state, pos, player, this);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void toggleBlock(Level level, BlockPos pos, BlockState state) {
        if (this._toggleHelper != null) {
            this._toggleHelper.toggleBlock(state);
        }
    }

    @Override
    public void setToggledState(Level level, BlockPos pos, BlockState state, boolean toggled) {
        if (this._toggleHelper != null) {
            this.setBlock(level, pos, this._toggleHelper.setToggledState(state, toggled));
        }
    }

    @FunctionalInterface
    public static interface MetroBlockStateFactory<T> {
        public T makeBlock(BlockBehaviour.Properties var1, VoxelShape var2, String var3, String var4, String var5, boolean var6, TextureSet ... var7);
    }
}

