/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative.builders;

import com.fureniku.metropolis.blocks.decorative.MetroBlockDecorativeBase;
import com.fureniku.metropolis.blocks.decorative.helpers.ConnectHorizontalHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBase;
import com.fureniku.metropolis.blocks.decorative.helpers.OffsetHelper;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.enums.BlockConnectionType;
import com.fureniku.metropolis.utils.SimpleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetroBlockDecorativeBuilder<T extends MetroBlockDecorativeBase> {
    protected BlockBehaviour.Properties _props;
    protected VoxelShape _blockShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected String _modelDir = "blocks/";
    protected String _modelName = null;
    protected String _tag = "untagged";
    protected TextureSet[] _textures = null;
    protected ArrayList<HelperBase> _helpers = new ArrayList();

    public MetroBlockDecorativeBuilder(BlockBehaviour.Properties props) {
        this._props = props;
    }

    public MetroBlockDecorativeBuilder setHeight(float height) {
        return this.setShape(16.0f, height, 16.0f);
    }

    public MetroBlockDecorativeBuilder setWidth(float width) {
        return this.setShape(width, 16.0f, width);
    }

    public MetroBlockDecorativeBuilder setShape(float width, float height) {
        return this.setShape(width, height, width);
    }

    public MetroBlockDecorativeBuilder setShape(Vec3 size) {
        return this.setShape((float)size.f_82479_, (float)size.f_82480_, (float)size.f_82481_);
    }

    public MetroBlockDecorativeBuilder setShape(float width, float height, float depth) {
        float insetX = (16.0f - width) / 2.0f;
        float insetZ = (16.0f - depth) / 2.0f;
        return this.setShape(Block.m_49796_((double)insetX, (double)0.0, (double)insetZ, (double)(16.0f - insetX), (double)height, (double)(16.0f - insetZ)));
    }

    public MetroBlockDecorativeBuilder setShape(VoxelShape shape) {
        this._blockShape = shape;
        return this;
    }

    public MetroBlockDecorativeBuilder setModelDirectory(String modelDir) {
        this._modelDir = modelDir;
        return this;
    }

    public MetroBlockDecorativeBuilder setModelName(String modelName) {
        this._modelName = modelName;
        return this;
    }

    public MetroBlockDecorativeBuilder setTag(String tag) {
        this._tag = tag;
        return this;
    }

    public MetroBlockDecorativeBuilder setTextures(TextureSet ... textures) {
        this._textures = textures;
        return this;
    }

    public MetroBlockDecorativeBuilder setTextures(ResourceLocation resource) {
        return this.setTextures(new TextureSet("texture", resource));
    }

    public MetroBlockDecorativeBuilder setHelpers(HelperBase ... helpers) {
        this._helpers.addAll(Arrays.asList(helpers));
        return this;
    }

    public MetroBlockDecorativeBuilder addHelper(HelperBase helper) {
        this._helpers.add(helper);
        return this;
    }

    public MetroBlockDecorativeBuilder setConnectHorizontalHelper(BlockConnectionType connectionType, VoxelShape[] shapes) {
        this._helpers.add(new ConnectHorizontalHelper.Builder(connectionType, shapes).build());
        return this;
    }

    public MetroBlockDecorativeBuilder setConnectFullHelper() {
        return this;
    }

    public MetroBlockDecorativeBuilder get() {
        return this;
    }

    public BlockBehaviour.Properties getProps() {
        return this._props;
    }

    public VoxelShape getShape() {
        return this._blockShape;
    }

    public String getModelDirectory() {
        return this._modelDir;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getTag() {
        return this._tag;
    }

    public TextureSet[] getTextures() {
        return this._textures;
    }

    public ArrayList<HelperBase> getHelpers() {
        return this._helpers;
    }

    public T build() {
        HelperBase[] helpersArray = this._helpers.toArray(new HelperBase[0]);
        MetroBlockDecorativeBase.MetroBlockStateFactory factory = MetroBlockDecorativeBase.getBlockFactory(helpersArray);
        return (T)((MetroBlockDecorativeBase)factory.makeBlock(this._props, this._blockShape, this._modelDir, this._modelName, this._tag, SimpleUtils.containsType(OffsetHelper.class, helpersArray), this._textures));
    }

    public <T extends MetroBlockDecorativeBase> T buildAs(MetroBlockDecorativeBase.MetroBlockStateFactory factory) {
        return (T)((MetroBlockDecorativeBase)factory.makeBlock(this._props, this._blockShape, this._modelDir, this._modelName, this._tag, SimpleUtils.containsType(OffsetHelper.class, this._helpers), this._textures));
    }
}

