/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative.helpers;

import com.fureniku.metropolis.blocks.MetroBlockBase;
import com.fureniku.metropolis.blocks.decorative.MetroBlockDecorativeBase;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBlockstate;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.enums.BlockConnectionType;
import com.fureniku.metropolis.enums.HelperType;
import com.fureniku.metropolis.utils.ShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class ConnectHorizontalHelper
extends HelperBlockstate {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private boolean _checkUp = false;
    private boolean _checkDown = false;
    protected boolean _centerFourSided = false;
    protected boolean _independentModelsPerSide = false;
    protected boolean _connectSolid = true;
    protected final String _connectedModelName;
    protected final String _itemModelName;
    protected final VoxelShape[] _shapeByIndex;
    protected final BlockConnectionType _connectionType;

    public ConnectHorizontalHelper(boolean checkUp, boolean checkDown, boolean centerFourSided, boolean independentModelsPerSide, boolean connectSolid, String connectedModelName, String itemModelName, BlockConnectionType connectionType, VoxelShape[] shapes) {
        this._checkUp = checkUp;
        this._checkDown = checkDown;
        this._centerFourSided = centerFourSided;
        this._independentModelsPerSide = independentModelsPerSide;
        this._connectSolid = connectSolid;
        this._connectedModelName = connectedModelName;
        this._itemModelName = itemModelName;
        this._shapeByIndex = shapes;
        this._connectionType = connectionType;
    }

    @Override
    public BlockState setDefaultState(BlockState state) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public HelperType getType() {
        return HelperType.CONNECTION_HORIZONTAL;
    }

    @Override
    public StateDefinition.Builder<Block, BlockState> addDefaultState(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
        return builder;
    }

    @Override
    public void generateBlockState(TextureSet[] resources, String modelDir, String modelName, Block block, MetroBlockStateProvider blockStateProvider) {
        Object connectedName = this._connectedModelName != null ? this._connectedModelName : modelName + "_connection";
        String itemName = this._itemModelName != null ? this._itemModelName : modelName;
        BlockModelBuilder modelItem = blockStateProvider.getModelFilesWithTexture(block, "_standard", modelDir + itemName, resources[0].getTexture());
        BlockModelBuilder modelNormal = blockStateProvider.getModelFilesWithTexture(block, "_standard", modelDir + modelName, resources[0].getTexture());
        BlockModelBuilder modelConnection = blockStateProvider.getModelFilesWithTexture(block, "_connection", modelDir + (String)connectedName, resources[0].getTexture());
        if (resources.length > 1) {
            for (int i = 1; i < resources.length; ++i) {
                modelItem = (BlockModelBuilder)modelItem.texture(resources[i].getKey(), resources[i].getTexture());
                modelNormal = (BlockModelBuilder)modelNormal.texture(resources[i].getKey(), resources[i].getTexture());
                modelConnection = (BlockModelBuilder)modelConnection.texture(resources[i].getKey(), resources[i].getTexture());
            }
        }
        if (this._centerFourSided) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)blockStateProvider.getMultipartBuilder(block).part().modelFile((ModelFile)modelNormal).rotationY(0).uvLock(true).addModel()).condition((Property)NORTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelNormal).rotationY(90).uvLock(true).addModel()).condition((Property)EAST, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelNormal).rotationY(180).uvLock(true).addModel()).condition((Property)SOUTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelNormal).rotationY(270).uvLock(true).addModel()).condition((Property)WEST, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelConnection).rotationY(0).uvLock(true).addModel()).condition((Property)NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnection).rotationY(90).uvLock(true).addModel()).condition((Property)EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnection).rotationY(180).uvLock(true).addModel()).condition((Property)SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnection).rotationY(270).uvLock(true).addModel()).condition((Property)WEST, (Comparable[])new Boolean[]{true}).end();
        } else {
            blockStateProvider.horizontalConnectingBlock(block, (ModelFile)modelNormal, (ModelFile)modelConnection);
        }
        blockStateProvider.simpleBlockItem(block, (ModelFile)modelItem);
    }

    @Override
    public BlockState getPlacementState(BlockPlaceContext context, BlockState currentState, Block block) {
        return this.checkNewState(context.m_43725_(), currentState, context.m_8083_(), block);
    }

    public VoxelShape getShapeFromBlockState(BlockState state) {
        return ShapeUtils.getShapeAtIndex(state, this._shapeByIndex);
    }

    public void neighbourChanged(BlockState state, Level level, BlockPos pos, MetroBlockDecorativeBase block) {
        BlockState newState = this.checkNewState(level, state, pos, block);
        if (newState != state) {
            block.setBlock(level, pos, newState);
        }
    }

    private BlockState checkNewState(Level level, BlockState currentState, BlockPos pos, Block block) {
        boolean north = this.checkMatchOnSide(level, pos.m_122012_(), block, Direction.NORTH);
        boolean east = this.checkMatchOnSide(level, pos.m_122029_(), block, Direction.EAST);
        boolean south = this.checkMatchOnSide(level, pos.m_122019_(), block, Direction.SOUTH);
        boolean west = this.checkMatchOnSide(level, pos.m_122024_(), block, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean checkMatchOnSide(Level level, BlockPos posToCheck, Block block, Direction dir) {
        if (this._checkUp && this.checkMatch(level, posToCheck.m_7494_(), block, dir, false)) {
            return true;
        }
        if (this._checkDown && this.checkMatch(level, posToCheck.m_7495_(), block, dir, false)) {
            return true;
        }
        return this.checkMatch(level, posToCheck, block, dir, this._connectSolid);
    }

    private boolean checkMatch(Level level, BlockPos posToCheck, Block block, Direction dir, boolean checkSolid) {
        BlockState stateCheck = level.m_8055_(posToCheck);
        Block blockCheck = stateCheck.m_60734_();
        BlockConnectionType type = this._connectionType;
        if (checkSolid && stateCheck.m_60783_((BlockGetter)level, posToCheck, dir.m_122424_())) {
            return true;
        }
        switch (type) {
            case SAME: {
                return blockCheck == block;
            }
            case SAMECLASS: {
                return blockCheck.getClass() == block.getClass();
            }
            case TAG: {
                if (block instanceof MetroBlockBase && blockCheck instanceof MetroBlockBase) {
                    MetroBlockBase blockMetro = (MetroBlockBase)block;
                    MetroBlockBase blockCheckMetro = (MetroBlockBase)blockCheck;
                    return blockMetro.getTag().equals(blockCheckMetro.getTag());
                }
                return false;
            }
            case CONNECTING: {
                if (block instanceof MetroBlockBase && blockCheck instanceof MetroBlockBase) {
                    return ((MetroBlockBase)block).hasHelper(ConnectHorizontalHelper.class) && ((MetroBlockBase)blockCheck).hasHelper(ConnectHorizontalHelper.class);
                }
                return false;
            }
            case METRO: {
                return blockCheck instanceof MetroBlockDecorativeBase && block instanceof MetroBlockDecorativeBase;
            }
            case ALL: {
                return !(blockCheck instanceof AirBlock);
            }
        }
        return false;
    }

    public static class Builder {
        private boolean _checkUp = false;
        private boolean _checkDown = false;
        private boolean _centerFourSided = false;
        private boolean _independentModelsPerSide = false;
        private boolean _connectSolid = true;
        private String _connectedModelName;
        private String _itemModelName;
        private BlockConnectionType _connectionType;
        private VoxelShape[] _shapes;

        public Builder() {
        }

        public Builder(Builder partial) {
            this._checkUp = partial._checkUp;
            this._checkDown = partial._checkDown;
            this._centerFourSided = partial._centerFourSided;
            this._independentModelsPerSide = partial._independentModelsPerSide;
            this._connectSolid = partial._connectSolid;
            this._connectedModelName = partial._connectedModelName;
            this._itemModelName = partial._itemModelName;
            this._connectionType = partial._connectionType;
            this._shapes = partial._shapes;
        }

        public Builder(BlockConnectionType connectionType, VoxelShape[] shapes) {
            this._connectionType = connectionType;
            this._shapes = shapes;
        }

        public Builder setCheckUp() {
            this._checkUp = true;
            return this;
        }

        public Builder setCheckDown() {
            this._checkDown = true;
            return this;
        }

        public Builder setCheckBoth() {
            this._checkUp = true;
            this._checkDown = true;
            return this;
        }

        public Builder setCenterFourSided() {
            this._centerFourSided = true;
            return this;
        }

        public Builder setIndependentModelsPerSide() {
            this._independentModelsPerSide = true;
            return this;
        }

        public Builder setDontConnectSolid() {
            this._connectSolid = false;
            return this;
        }

        public Builder setConnectedModelName(String modelName) {
            this._connectedModelName = modelName;
            return this;
        }

        public Builder setItemModelName(String modelName) {
            this._itemModelName = modelName;
            return this;
        }

        public Builder setConnectionType(BlockConnectionType connectionType) {
            this._connectionType = connectionType;
            return this;
        }

        public Builder setShapes(VoxelShape[] shapes) {
            this._shapes = shapes;
            return this;
        }

        public ConnectHorizontalHelper build() {
            return new ConnectHorizontalHelper(this._checkUp, this._checkDown, this._centerFourSided, this._independentModelsPerSide, this._connectSolid, this._connectedModelName, this._itemModelName, this._connectionType, this._shapes);
        }
    }
}

