/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative.helpers;

import com.fureniku.metropolis.blocks.decorative.helpers.HelperBase;
import com.fureniku.metropolis.enums.BlockOffsetDirection;
import com.fureniku.metropolis.enums.HelperType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OffsetHelper
extends HelperBase {
    BlockOffsetDirection _offsetDirection;

    public OffsetHelper(BlockOffsetDirection offsetDirection) {
        this._offsetDirection = offsetDirection;
    }

    @Override
    public BlockState setDefaultState(BlockState state) {
        return state;
    }

    @Override
    public HelperType getType() {
        return HelperType.OFFSET;
    }

    public Vec3 getOffset(BlockGetter level, BlockPos pos) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        switch (this._offsetDirection) {
            case NONE: {
                return Vec3.f_82478_;
            }
            case DOWN: {
                y = this.getOffsetBlockPosValue(level, pos.m_7495_(), Direction.Axis.Y, true);
                break;
            }
            case BACK: {
                break;
            }
            case LEFT: {
                break;
            }
            case FORWARD: {
                break;
            }
            case RIGHT: {
                break;
            }
            case UP: {
                y = this.getOffsetBlockPosValue(level, pos.m_7494_(), Direction.Axis.Y, false);
            }
        }
        double finalX = x;
        double finalY = y;
        double finalZ = z;
        return new Vec3(x, y, z);
    }

    private double getOffsetBlockPosValue(BlockGetter level, BlockPos pos, Direction.Axis axis, boolean positive) {
        if (level.m_8055_(pos).m_60734_() == Blocks.f_50016_) {
            return 0.0;
        }
        VoxelShape shape = level.m_8055_(pos).m_60808_(level, pos);
        return positive ? (1.0 - shape.m_83297_(axis)) * -1.0 : shape.m_83288_(axis);
    }
}

