/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative.helpers;

import com.fureniku.metropolis.blocks.decorative.helpers.HelperBlockstate;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.enums.HelperType;
import com.fureniku.metropolis.utils.ShapeUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class RotationHelper
extends HelperBlockstate {
    public static final DirectionProperty DIRECTION = HorizontalDirectionalBlock.f_54117_;
    private final VoxelShape BLOCK_SHAPE_NORTH;
    private final VoxelShape BLOCK_SHAPE_EAST;
    private final VoxelShape BLOCK_SHAPE_SOUTH;
    private final VoxelShape BLOCK_SHAPE_WEST;

    public RotationHelper(VoxelShape shape) {
        this.BLOCK_SHAPE_NORTH = shape;
        this.BLOCK_SHAPE_EAST = ShapeUtils.rotateVoxelShape(shape, Direction.EAST);
        this.BLOCK_SHAPE_SOUTH = ShapeUtils.rotateVoxelShape(shape, Direction.SOUTH);
        this.BLOCK_SHAPE_WEST = ShapeUtils.rotateVoxelShape(shape, Direction.WEST);
    }

    public RotationHelper() {
        this.BLOCK_SHAPE_EAST = this.BLOCK_SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.BLOCK_SHAPE_SOUTH = this.BLOCK_SHAPE_NORTH;
        this.BLOCK_SHAPE_WEST = this.BLOCK_SHAPE_NORTH;
    }

    @Override
    public BlockState setDefaultState(BlockState state) {
        return (BlockState)state.m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH);
    }

    @Override
    public HelperType getType() {
        return HelperType.ROTATION;
    }

    @Override
    public StateDefinition.Builder<Block, BlockState> addDefaultState(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION});
        return builder;
    }

    @Override
    public void generateBlockState(TextureSet[] resources, String modelDir, String modelName, Block block, MetroBlockStateProvider blockStateProvider) {
        BlockModelBuilder bmb = blockStateProvider.prepareModels(block, modelDir, modelName, resources);
        blockStateProvider.horizontalBlock(block, (ModelFile)bmb);
    }

    @Override
    public BlockState getPlacementState(BlockPlaceContext context, BlockState currentState, Block block) {
        return (BlockState)currentState.m_61124_((Property)DIRECTION, (Comparable)context.m_8125_());
    }

    public VoxelShape getShapeFromBlockState(BlockState pState) {
        switch ((Direction)pState.m_61143_((Property)DIRECTION)) {
            case EAST: {
                return this.BLOCK_SHAPE_EAST;
            }
            case SOUTH: {
                return this.BLOCK_SHAPE_SOUTH;
            }
            case WEST: {
                return this.BLOCK_SHAPE_WEST;
            }
        }
        return this.BLOCK_SHAPE_NORTH;
    }
}

