/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks.decorative.helpers;

import com.fureniku.metropolis.blocks.decorative.MetroBlockDecorativeBase;
import com.fureniku.metropolis.blocks.decorative.helpers.ConnectHorizontalHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBlockstate;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.enums.HelperType;
import com.fureniku.metropolis.enums.ToggleType;
import com.fureniku.metropolis.utils.ShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class ToggleHelper
extends HelperBlockstate {
    public static final BooleanProperty TOGGLED = BooleanProperty.m_61465_((String)"toggled");
    private VoxelShape BLOCK_SHAPE;
    private VoxelShape BLOCK_SHAPE_EAST;
    private VoxelShape BLOCK_SHAPE_SOUTH;
    private VoxelShape BLOCK_SHAPE_WEST;
    private VoxelShape BLOCK_SHAPE_TOGGLED;
    private VoxelShape BLOCK_SHAPE_TOGGLED_EAST;
    private VoxelShape BLOCK_SHAPE_TOGGLED_SOUTH;
    private VoxelShape BLOCK_SHAPE_TOGGLED_WEST;
    protected String _toggledModelName;
    private Item _item;
    private ToggleType _type;
    private boolean _rotatable = false;
    private boolean _hideBaseOnToggle = false;

    public ToggleHelper(boolean hideBaseOnToggle, VoxelShape shape, VoxelShape toggledShape, String modelName, ToggleType type) {
        this.BLOCK_SHAPE = shape;
        this.BLOCK_SHAPE_TOGGLED = toggledShape;
        this._toggledModelName = modelName;
        this._type = type;
        this._hideBaseOnToggle = hideBaseOnToggle;
    }

    public ToggleHelper(boolean hideBaseOnTogggle, VoxelShape shape, VoxelShape toggledShape, String modelName, Item item) {
        this(hideBaseOnTogggle, shape, toggledShape, modelName, ToggleType.ITEM);
        this._item = item;
    }

    @Override
    public BlockState setDefaultState(BlockState state) {
        state.m_61124_((Property)TOGGLED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    @Override
    public StateDefinition.Builder<Block, BlockState> addDefaultState(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOGGLED});
        return builder;
    }

    @Override
    public HelperType getType() {
        return HelperType.TOGGLE;
    }

    public void setRotatable() {
        this._rotatable = true;
        this.BLOCK_SHAPE_EAST = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE, Direction.EAST);
        this.BLOCK_SHAPE_SOUTH = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE, Direction.SOUTH);
        this.BLOCK_SHAPE_WEST = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE, Direction.WEST);
        this.BLOCK_SHAPE_TOGGLED_EAST = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE_TOGGLED, Direction.EAST);
        this.BLOCK_SHAPE_TOGGLED_SOUTH = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE_TOGGLED, Direction.SOUTH);
        this.BLOCK_SHAPE_TOGGLED_WEST = ShapeUtils.rotateVoxelShape(this.BLOCK_SHAPE_TOGGLED, Direction.WEST);
    }

    public void neighbourChanged(BlockState state, Level level, BlockPos pos, MetroBlockDecorativeBase block) {
        if (!(level.f_46443_ || this._type != ToggleType.REDSTONE && this._type != ToggleType.REDSTONE_INTERACT)) {
            block.setToggledState(level, pos, state, level.m_276867_(pos));
        }
    }

    public void rightClick(BlockState state, BlockPos pos, Player player, MetroBlockDecorativeBase block) {
        switch (this._type) {
            case REDSTONE_INTERACT: 
            case INTERACT: {
                block.toggleBlock(player.m_9236_(), pos, state);
                return;
            }
            case ITEM: {
                ItemStack heldItem;
                if (this._item == null || (heldItem = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_() != this._item) break;
                block.toggleBlock(player.m_9236_(), pos, state);
            }
        }
    }

    public BlockState toggleBlock(BlockState state) {
        return this.setToggledState(state, (Boolean)state.m_61143_((Property)TOGGLED) == false);
    }

    public BlockState setToggledState(BlockState state, boolean toggled) {
        return (BlockState)state.m_61124_((Property)TOGGLED, (Comparable)Boolean.valueOf(toggled));
    }

    @Override
    public void generateBlockState(TextureSet[] resources, String modelDir, String modelName, Block block, MetroBlockStateProvider blockStateProvider) {
        BlockModelBuilder modelNormal = blockStateProvider.prepareModels(block, "_standard", modelDir, modelName, resources);
        BlockModelBuilder modelToggled = blockStateProvider.prepareModels(block, "_toggled", modelDir, this._toggledModelName, resources);
        blockStateProvider.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)TOGGLED) != false ? modelToggled : modelNormal)).build());
        blockStateProvider.simpleBlockItem(block, (ModelFile)modelNormal);
    }

    public void generateBlockStateRotatable(TextureSet[] resources, String modelDir, String modelName, Block block, MetroBlockStateProvider blockStateProvider) {
        BlockModelBuilder modelNormal = blockStateProvider.prepareModels(block, "_standard", modelDir, modelName, resources);
        BlockModelBuilder modelToggled = blockStateProvider.prepareModels(block, "_toggled", modelDir, this._toggledModelName, resources);
        blockStateProvider.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)TOGGLED) != false ? modelToggled : modelNormal)).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() % 360).build());
        blockStateProvider.simpleBlockItem(block, (ModelFile)modelNormal);
    }

    public void generateBlockStateConnectingToggle(TextureSet[] resources, String modelDir, String modelName, Block block, MetroBlockStateProvider blockStateProvider, ConnectHorizontalHelper connectHorizontalHelper) {
        BlockModelBuilder modelItem;
        String connectedModelName = connectHorizontalHelper._connectedModelName;
        if (connectHorizontalHelper._independentModelsPerSide) {
            modelItem = blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled", modelDir + connectHorizontalHelper._itemModelName + "_n", resources[0].getTexture());
            BlockModelBuilder[] builders = blockStateProvider.applyTexturesToModels(resources, blockStateProvider.getModelFilesWithTexture(block, "_standard_north", modelDir + modelName + "_n", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_east", modelDir + modelName + "_e", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_south", modelDir + modelName + "_s", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_west", modelDir + modelName + "_w", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_north", modelDir + connectedModelName + "_n", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_east", modelDir + connectedModelName + "_e", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_south", modelDir + connectedModelName + "_s", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_west", modelDir + connectedModelName + "_w", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled_north", modelDir + this._toggledModelName + "_n", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled_east", modelDir + this._toggledModelName + "_e", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled_south", modelDir + this._toggledModelName + "_s", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled_west", modelDir + this._toggledModelName + "_w", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled_north", modelDir + connectedModelName + "_n", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled_east", modelDir + connectedModelName + "_e", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled_south", modelDir + connectedModelName + "_s", resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled_west", modelDir + connectedModelName + "_w", resources[0].getTexture()));
            this.getGeneratedBlockState(block, blockStateProvider, 0, 0, 0, 0, connectHorizontalHelper, builders[0], builders[1], builders[2], builders[3], builders[4], builders[5], builders[6], builders[7], builders[8], builders[9], builders[10], builders[11], builders[12], builders[13], builders[14], builders[15]);
        } else {
            modelItem = blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled", modelDir + connectHorizontalHelper._itemModelName + "_n", resources[0].getTexture());
            BlockModelBuilder[] builders = blockStateProvider.applyTexturesToModels(resources, blockStateProvider.getModelFilesWithTexture(block, "_standard_toggled", modelDir + modelName, resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled", modelDir + connectedModelName, resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_standard", modelDir + this._toggledModelName, resources[0].getTexture()), blockStateProvider.getModelFilesWithTexture(block, "_connection_toggled", modelDir + this._toggledModelName + "_connection", resources[0].getTexture()));
            this.getGeneratedBlockState(block, blockStateProvider, 0, 90, 180, 270, connectHorizontalHelper, builders[0], builders[0], builders[0], builders[0], builders[1], builders[1], builders[1], builders[1], builders[2], builders[2], builders[2], builders[2], builders[3], builders[3], builders[3], builders[3]);
        }
        modelItem = blockStateProvider.applyTexturesToModel(resources, modelItem);
        blockStateProvider.simpleBlockItem(block, (ModelFile)modelItem);
    }

    private void getGeneratedBlockState(Block block, MetroBlockStateProvider blockStateProvider, int rotN, int rotE, int rotS, int rotW, ConnectHorizontalHelper connectHorizontalHelper, BlockModelBuilder modelNormalNorth, BlockModelBuilder modelNormalEast, BlockModelBuilder modelNormalSouth, BlockModelBuilder modelNormalWest, BlockModelBuilder toggledModelNormalNorth, BlockModelBuilder toggledModelNormalEast, BlockModelBuilder toggledModelNormalSouth, BlockModelBuilder toggledModelNormalWest, BlockModelBuilder modelConnectionNorth, BlockModelBuilder modelConnectionEast, BlockModelBuilder modelConnectionSouth, BlockModelBuilder modelConnectionWest, BlockModelBuilder toggledModelConnectionNorth, BlockModelBuilder toggledModelConnectionEast, BlockModelBuilder toggledModelConnectionSouth, BlockModelBuilder toggledModelConnectionWest) {
        MultiPartBlockStateBuilder builder = blockStateProvider.getMultipartBuilder(block);
        if (connectHorizontalHelper._centerFourSided) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalNorth).rotationY(rotN).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalEast).rotationY(rotE).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalSouth).rotationY(rotS).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalWest).rotationY(rotW).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true});
            if (!this._hideBaseOnToggle) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalNorth).uvLock(true).rotationY(rotN).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalEast).uvLock(true).rotationY(rotE).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalSouth).uvLock(true).rotationY(rotS).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalWest).uvLock(true).rotationY(rotW).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{false});
            } else {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalNorth).uvLock(true).rotationY(rotN).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalEast).uvLock(true).rotationY(rotE).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalSouth).uvLock(true).rotationY(rotS).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalWest).uvLock(true).rotationY(rotW).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{false}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false});
            }
        } else {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelNormalNorth).addModel()).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalEast).rotationY(rotE).addModel()).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalNorth).addModel()).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{true, false}).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{true, false}).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{true, false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalNorth).addModel()).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{true, false}).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{true, false}).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{true, false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)toggledModelNormalNorth).addModel()).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{false}).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{false});
        }
        if (!this._hideBaseOnToggle) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelConnectionNorth).rotationY(rotN).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnectionEast).rotationY(rotE).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnectionSouth).rotationY(rotS).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelConnectionWest).rotationY(rotW).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{true}).end();
        } else {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)modelConnectionNorth).rotationY(rotN).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelConnectionEast).rotationY(rotE).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelConnectionSouth).rotationY(rotS).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelConnectionWest).rotationY(rotW).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)toggledModelConnectionNorth).rotationY(rotN).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)toggledModelConnectionEast).rotationY(rotE).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.EAST, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)toggledModelConnectionSouth).rotationY(rotS).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)toggledModelConnectionWest).rotationY(rotW).uvLock(true).addModel()).condition((Property)ConnectHorizontalHelper.WEST, (Comparable[])new Boolean[]{true}).condition((Property)TOGGLED, (Comparable[])new Boolean[]{true}).end();
        }
    }

    public VoxelShape getShapeFromBlockState(BlockState state, Direction direction) {
        if (this._rotatable) {
            if (((Boolean)state.m_61143_((Property)TOGGLED)).booleanValue()) {
                switch (direction) {
                    case EAST: {
                        return this.BLOCK_SHAPE_TOGGLED_EAST;
                    }
                    case SOUTH: {
                        return this.BLOCK_SHAPE_TOGGLED_SOUTH;
                    }
                    case WEST: {
                        return this.BLOCK_SHAPE_TOGGLED_WEST;
                    }
                }
                return this.BLOCK_SHAPE_TOGGLED;
            }
            switch (direction) {
                case EAST: {
                    return this.BLOCK_SHAPE_EAST;
                }
                case SOUTH: {
                    return this.BLOCK_SHAPE_SOUTH;
                }
                case WEST: {
                    return this.BLOCK_SHAPE_WEST;
                }
            }
            return this.BLOCK_SHAPE;
        }
        return (Boolean)state.m_61143_((Property)TOGGLED) != false ? this.BLOCK_SHAPE_TOGGLED : this.BLOCK_SHAPE;
    }

    @Override
    public BlockState getPlacementState(BlockPlaceContext context, BlockState currentState, Block block) {
        return currentState;
    }
}

