/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.datagen;

import com.fureniku.metropolis.RegistrationBase;
import com.fureniku.metropolis.blocks.MetroBlockBase;
import com.fureniku.metropolis.client.rendering.MetroLoaderBuilder;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.utils.Debug;
import java.util.Collection;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class MetroBlockStateProvider
extends BlockStateProvider {
    private RegistrationBase _registrationBase;

    public MetroBlockStateProvider(PackOutput output, String modid, ExistingFileHelper fileHelper, RegistrationBase registrationBase) {
        super(output, modid, fileHelper);
        this._registrationBase = registrationBase;
    }

    public void simpleBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    public void horizontalBlock(Block block, ModelFile model) {
        this.horizontalBlock(block, model, 180);
        this.simpleBlockItem(block, model);
    }

    public void blockWithItem(Block block, ResourceLocation loc) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().withExistingParent(this.name(block), loc));
    }

    public void horizontalConnectingBlock(Block block, ModelFile post, ModelFile side) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile(post).addModel()).end();
        this.fourWayMultipart(builder, side);
    }

    public void customRenderBlockTest(Block block) {
        BlockModelBuilder model = (BlockModelBuilder)((MetroLoaderBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(block))).parent((ModelFile)this.models().getExistingFile(this.mcLoc("cube")))).customLoader((builder, helper) -> new MetroLoaderBuilder(this.modLoc(this.name(block)), (BlockModelBuilder)builder, (ExistingFileHelper)helper))).end();
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    public BlockModelBuilder getModelFiles(Block block, String nameSuffix, String parentModel) {
        return (BlockModelBuilder)this.models().singleTexture(this.name(block) + nameSuffix, this.modLoc(parentModel), this.modLoc("block/" + this.name(block)));
    }

    public BlockModelBuilder getTexturedModelFiles(Block block, String nameSuffix, String parentModel, String textureName) {
        return (BlockModelBuilder)this.models().singleTexture(this.name(block) + nameSuffix, this.modLoc(parentModel), this.modLoc("block/" + textureName));
    }

    public BlockModelBuilder getModelFilesWithTexture(Block block, String nameSuffix, String parentModel, ResourceLocation texture) {
        return (BlockModelBuilder)this.models().singleTexture(this.name(block) + nameSuffix, this.modLoc(parentModel), texture);
    }

    public ItemModelBuilder getItemBlockModelFiles(Block block, String nameSuffix, String parentModel) {
        return (ItemModelBuilder)this.itemModels().singleTexture(this.name(block) + nameSuffix, this.modLoc(parentModel), this.modLoc("block/" + this.name(block)));
    }

    protected Collection<RegistryObject<Block>> getBlocks() {
        return this._registrationBase.getBlockArray().values();
    }

    public BlockModelBuilder prepareModels(Block block, String modelDir, String modelName, TextureSet[] resources) {
        return this.prepareModels(block, "", modelDir, modelName, resources);
    }

    public BlockModelBuilder prepareModels(Block block, String nameSuffix, String modelDir, String modelName, TextureSet[] resources) {
        BlockModelBuilder bmb;
        if (modelName == null || resources == null) {
            bmb = this.getModelFilesWithTexture(block, nameSuffix, modelDir + this.name(block), this.modLoc(modelDir + this.name(block)));
        } else {
            bmb = this.applyTexturesToModel(resources, this.getModelFilesWithTexture(block, nameSuffix, modelDir + modelName, resources[0].getTexture()));
            if (resources.length > 1) {
                for (int i = 1; i < resources.length; ++i) {
                    bmb = (BlockModelBuilder)bmb.texture(resources[i].getKey(), resources[i].getTexture());
                }
            }
        }
        return bmb;
    }

    public BlockModelBuilder applyTexturesToModel(TextureSet[] resources, BlockModelBuilder bmb) {
        if (resources.length > 1) {
            for (int i = 1; i < resources.length; ++i) {
                bmb = (BlockModelBuilder)bmb.texture(resources[i].getKey(), resources[i].getTexture());
            }
        }
        return bmb;
    }

    public BlockModelBuilder[] applyTexturesToModels(TextureSet[] resources, BlockModelBuilder ... bmb) {
        if (resources.length > 1) {
            for (int i = 0; i < bmb.length; ++i) {
                for (int j = 1; j < resources.length; ++j) {
                    bmb[i] = (BlockModelBuilder)bmb[i].texture(resources[j].getKey(), resources[j].getTexture());
                }
            }
        }
        return bmb;
    }

    protected void registerStatesAndModels() {
        Collection<RegistryObject<Block>> blockValues = this.getBlocks();
        for (RegistryObject<Block> block : blockValues) {
            if (block.get() instanceof MetroBlockBase) {
                MetroBlockBase metroBlock = (MetroBlockBase)((Object)block.get());
                metroBlock.generateBlockState(block, this);
                continue;
            }
            Debug.LogError(((Block)block.get()).m_49954_() + " was not a MetroBlockBase. This is an error!", new Object[0]);
        }
    }

    protected ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    protected String name(Block block) {
        return this.key(block).m_135815_();
    }
}

