/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.utils;

import com.fureniku.metropolis.Metropolis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.Level;

public class Debug {
    private static HashMap<String, String> _registeredMods = new HashMap();

    public static void registerMod(String name) {
        String pkg = Debug.getPackageName();
        Metropolis.LOGGER.atInfo().log("[Metropolis] registering mod " + name + " with logger under package name " + pkg);
        _registeredMods.put(pkg, name);
    }

    public static void Log(String msg, Object ... params) {
        Metropolis.LOGGER.atInfo().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
    }

    public static void LogClient(Level level, String msg, Object ... params) {
        if (level.f_46443_) {
            Debug.LogDebug(msg, params);
        }
    }

    public static void LogServer(Level level, String msg, Object ... params) {
        if (!level.f_46443_) {
            Debug.LogDebug(msg, params);
        }
    }

    public static void LogSided(Level level, String msg, Object ... params) {
        Debug.LogDebug((level.f_46443_ ? "[CLIENT] " : "[SERVER] ") + msg, params);
    }

    public static void LogDebug(String msg, Object ... params) {
        Metropolis.LOGGER.atDebug().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
    }

    public static void LogDebugVerbose(String msg, Object ... params) {
        Metropolis.LOGGER.atDebug().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
        Metropolis.LOGGER.atDebug().log(Debug.printClassLine());
    }

    public static void LogWarning(String msg, Object ... params) {
        Metropolis.LOGGER.atWarn().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
        Metropolis.LOGGER.atDebug().log(Debug.printClassLine());
    }

    public static void LogWarningVerbose(String msg, Object ... params) {
        Metropolis.LOGGER.atWarn().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
        Metropolis.LOGGER.atDebug().log(Debug.printClassLine());
    }

    public static void LogError(String msg, Object ... params) {
        Metropolis.LOGGER.atError().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
        Metropolis.LOGGER.atDebug().log(Debug.printClassLine());
    }

    public static void LogCritical(String msg, Object ... params) {
        Metropolis.LOGGER.atError().log(String.format(Debug.getModFomCall(Debug.getCallPackage()) + msg, params));
        new Exception().printStackTrace(System.out);
    }

    private static String getModFomCall(String callPkg) {
        if (!_registeredMods.isEmpty()) {
            for (Map.Entry<String, String> entry : _registeredMods.entrySet()) {
                if (!callPkg.contains(entry.getKey())) continue;
                return "[" + entry.getValue() + "] ";
            }
        }
        Metropolis.LOGGER.atError().log("[METROPOLIS] Trying to debug with no registered mods!");
        return "[UNKNOWN MOD: " + callPkg + "] ";
    }

    private static String printClassLine() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[3].toString();
    }

    private static String getCallPackage() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length >= 4) {
            return stackTrace[3].getClassName();
        }
        return "default";
    }

    private static String getPackageName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length >= 4) {
            String callingClass = stackTrace[3].getClassName();
            int lastDotIndex = -1;
            for (int i = 0; i < 3; ++i) {
                if ((lastDotIndex = callingClass.indexOf(46, lastDotIndex + 1)) != -1) continue;
                return callingClass;
            }
            return callingClass.substring(0, lastDotIndex);
        }
        return "default";
    }
}

