/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.utils;

import com.fureniku.metropolis.utils.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtils {
    private final Path JAR_PATH;
    private final String MODEL_PATH_BLOCK;
    private final String MODEL_PATH_ITEM;
    private final String TEXTURE_PATH_BLOCK;
    private final String TEXTURE_PATH_ITEM;
    private final String BLOCKSTATE_PATH;
    private String _blockStatePath = "/blockstates/";
    private String _modelPathBlock = "/models/block/";
    private String _modelPathItem = "/models/item/";
    private String _texturePathBlock = "/textures/block/";
    private String _texturePathItem = "/textures/item/";
    private static boolean compiledSystem = false;

    public JarUtils(Class modClass, String modid) throws URISyntaxException {
        this.JAR_PATH = this.getFilePath(modClass);
        this.BLOCKSTATE_PATH = "assets/" + modid + this._blockStatePath;
        this.MODEL_PATH_BLOCK = "assets/" + modid + this._modelPathBlock;
        this.MODEL_PATH_ITEM = "assets/" + modid + this._modelPathItem;
        this.TEXTURE_PATH_BLOCK = "assets/" + modid + this._texturePathBlock;
        this.TEXTURE_PATH_ITEM = "assets/" + modid + this._texturePathItem;
    }

    public void printPaths() {
        Debug.Log("Jar path: " + this.JAR_PATH.toAbsolutePath(), new Object[0]);
        Debug.Log("Block Model path: " + this.JAR_PATH + this.MODEL_PATH_BLOCK, new Object[0]);
        Debug.Log("Item Model path: " + this.JAR_PATH + this.MODEL_PATH_ITEM, new Object[0]);
        Debug.Log("Block Texture path: " + this.JAR_PATH + this.TEXTURE_PATH_BLOCK, new Object[0]);
        Debug.Log("Item Texture path: " + this.JAR_PATH + this.TEXTURE_PATH_ITEM, new Object[0]);
    }

    private Path getFilePath(Class modClass) {
        URL resourceUrl = modClass.getResource("");
        Debug.Log("Resource URL searchable: " + resourceUrl, new Object[0]);
        Debug.Log("Paths get searchable: " + Paths.get("", new String[0]), new Object[0]);
        return Paths.get("", new String[0]);
    }

    private String readFileInJar(String fileName, Class modClass) throws IOException {
        StringBuilder sb = new StringBuilder();
        fileName = this.BLOCKSTATE_PATH + (String)fileName;
        URL jarUrl = modClass.getProtectionDomain().getCodeSource().getLocation();
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        JarFile jar = jarConnection.getJarFile();
        JarEntry entry = jar.getJarEntry((String)fileName);
        if (entry != null) {
            String line;
            InputStream inputStream = jar.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            inputStream.close();
        }
        jar.close();
        return sb.toString();
    }

    private static ArrayList<File> getJsonFiles(String dir, ArrayList<File> jsonList) {
        File directory = new File(dir);
        File[] files = directory.listFiles();
        if (files == null) {
            Debug.Log("Running in production environment; switching to jarfile extraction for internal paint JSONs", new Object[0]);
        }
        if (files.length > 0) {
            for (File file : files) {
                if (file == null) continue;
                if (file.isFile()) {
                    jsonList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                JarUtils.getJsonFiles(file.getAbsolutePath(), jsonList);
            }
        }
        return jsonList;
    }
}

