/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.utils;

import com.fureniku.metropolis.utils.Debug;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtils {
    public static final VoxelShape FULL_BOX = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public static VoxelShape makeShape(float size, float height) {
        double x = size / 2.0f;
        return Block.m_49796_((double)(8.0 - x), (double)0.0, (double)(8.0 - x), (double)(8.0 + x), (double)height, (double)(8.0 + x));
    }

    public static VoxelShape makeShape(Vec3 shape) {
        double x = shape.f_82479_ / 2.0;
        double z = shape.f_82481_ / 2.0;
        return Block.m_49796_((double)(8.0 - x), (double)0.0, (double)(8.0 - z), (double)(8.0 + x), (double)shape.f_82480_, (double)(8.0 + z));
    }

    public static VoxelShape[] makeShapes(float size, float height) {
        return ShapeUtils.makeShapes(size, size, height, 0.0f, height);
    }

    public static VoxelShape[] makeShapes(float size, float base, float height) {
        return ShapeUtils.makeShapes(size, size, height, base, height);
    }

    public static VoxelShape[] makeShapes(float centerSize, float connectionSize, float cHeight, float base, float height) {
        double cWidthMin = 8.0f - centerSize;
        double cWidthMax = 8.0f + centerSize;
        VoxelShape shapeCenter = Block.m_49796_((double)cWidthMin, (double)0.0, (double)cWidthMin, (double)cWidthMax, (double)cHeight, (double)cWidthMax);
        return ShapeUtils.makeShapes(shapeCenter, connectionSize, base, height);
    }

    public static VoxelShape[] makeShapes(VoxelShape center, VoxelShape side) {
        VoxelShape south = ShapeUtils.rotateVoxelShape(side, Direction.SOUTH);
        VoxelShape east = ShapeUtils.rotateVoxelShape(side, Direction.EAST);
        VoxelShape west = ShapeUtils.rotateVoxelShape(side, Direction.WEST);
        return ShapeUtils.makeShapes(center, side, east, south, west);
    }

    public static VoxelShape[] makeShapes(VoxelShape center, float size, float height) {
        return ShapeUtils.makeShapes(center, size, 0.0f, height);
    }

    public static VoxelShape[] makeShapes(VoxelShape shapeCenter, float size, float base, float height) {
        double min = 0.0;
        double max = 16.0;
        double widthMin = 8.0f - size;
        double widthEnd = 8.0f + size;
        VoxelShape shapeNorth = Block.m_49796_((double)widthMin, (double)base, (double)min, (double)widthEnd, (double)height, (double)widthEnd);
        VoxelShape shapeSouth = Block.m_49796_((double)widthMin, (double)base, (double)widthMin, (double)widthEnd, (double)height, (double)max);
        VoxelShape shapeWest = Block.m_49796_((double)min, (double)base, (double)widthMin, (double)widthEnd, (double)height, (double)widthEnd);
        VoxelShape shapeEast = Block.m_49796_((double)widthMin, (double)base, (double)widthMin, (double)max, (double)height, (double)widthEnd);
        return ShapeUtils.makeShapes(shapeCenter, shapeNorth, shapeEast, shapeSouth, shapeWest);
    }

    public static VoxelShape[] makeShapes(VoxelShape center, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        VoxelShape northEast = Shapes.m_83110_((VoxelShape)north, (VoxelShape)east);
        VoxelShape southWest = Shapes.m_83110_((VoxelShape)south, (VoxelShape)west);
        VoxelShape[] shapeArray = new VoxelShape[]{Shapes.m_83040_(), south, west, southWest, north, Shapes.m_83110_((VoxelShape)south, (VoxelShape)north), Shapes.m_83110_((VoxelShape)west, (VoxelShape)north), Shapes.m_83110_((VoxelShape)southWest, (VoxelShape)north), east, Shapes.m_83110_((VoxelShape)south, (VoxelShape)east), Shapes.m_83110_((VoxelShape)west, (VoxelShape)east), Shapes.m_83110_((VoxelShape)southWest, (VoxelShape)east), northEast, Shapes.m_83110_((VoxelShape)south, (VoxelShape)northEast), Shapes.m_83110_((VoxelShape)west, (VoxelShape)northEast), Shapes.m_83110_((VoxelShape)southWest, (VoxelShape)northEast)};
        for (int i = 0; i < shapeArray.length; ++i) {
            shapeArray[i] = Shapes.m_83110_((VoxelShape)center, (VoxelShape)shapeArray[i]);
        }
        return shapeArray;
    }

    public static VoxelShape[] combineMultiShapes(VoxelShape[] shapesA, VoxelShape[] shapesB) {
        if (shapesA.length != shapesB.length) {
            Debug.LogError("Attempting to combine multi shapes, but arrays were not equal length. A: %s, B: %s", shapesA.length, shapesB.length);
            return shapesA;
        }
        VoxelShape[] newShape = new VoxelShape[shapesA.length];
        for (int i = 0; i < shapesA.length; ++i) {
            newShape[i] = Shapes.m_83110_((VoxelShape)shapesA[i], (VoxelShape)shapesB[i]);
        }
        return newShape;
    }

    public static VoxelShape getShapeAtIndex(BlockState state, VoxelShape[] shapes) {
        return shapes[ShapeUtils.getAABBIndex(state)];
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction newDirection) {
        if (newDirection != Direction.NORTH) {
            double xMin = shape.m_83288_(Direction.Axis.X);
            double xMax = 1.0 - shape.m_83297_(Direction.Axis.X);
            double yMin = shape.m_83288_(Direction.Axis.Y);
            double yMax = 1.0 - shape.m_83297_(Direction.Axis.Y);
            double zMin = shape.m_83288_(Direction.Axis.Z);
            double zMax = 1.0 - shape.m_83297_(Direction.Axis.Z);
            switch (newDirection) {
                case EAST: {
                    return ShapeUtils.createNewShape(zMax, yMin, xMin, zMin, yMax, xMax);
                }
                case SOUTH: {
                    return ShapeUtils.createNewShape(xMax, yMin, zMax, xMin, yMax, zMin);
                }
                case WEST: {
                    return ShapeUtils.createNewShape(zMin, yMin, xMax, zMax, yMax, xMin);
                }
            }
        }
        return shape;
    }

    private static VoxelShape createNewShape(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return Block.m_49796_((double)(xMin * 16.0), (double)(yMin * 16.0), (double)(zMin * 16.0), (double)(16.0 - xMax * 16.0), (double)(16.0 - yMax * 16.0), (double)(16.0 - zMax * 16.0));
    }

    public static String getPrintableShape(VoxelShape shape) {
        return "X: " + shape.m_83288_(Direction.Axis.X) + " - " + shape.m_83297_(Direction.Axis.X) + " Y: " + shape.m_83288_(Direction.Axis.Y) + " - " + shape.m_83297_(Direction.Axis.Y) + " Z: " + shape.m_83288_(Direction.Axis.Z) + " - " + shape.m_83297_(Direction.Axis.Z);
    }

    private static int getAABBIndex(BlockState state) {
        return stateToIndex.computeIntIfAbsent((Object)state, mappedState -> {
            int i = 0;
            if (((Boolean)mappedState.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
                i |= ShapeUtils.indexFor(Direction.NORTH);
            }
            if (((Boolean)mappedState.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
                i |= ShapeUtils.indexFor(Direction.EAST);
            }
            if (((Boolean)mappedState.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
                i |= ShapeUtils.indexFor(Direction.SOUTH);
            }
            if (((Boolean)mappedState.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
                i |= ShapeUtils.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    private static int indexFor(Direction p_52344_) {
        return 1 << p_52344_.m_122416_();
    }
}

