/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.common;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.implementations.blockentities.IViewCellStorage;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.ToolboxMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.IMEInteractionHandler;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.crafting.CraftAmountMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerListener;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MEStorageMenu
extends AEBaseMenu
implements IConfigManagerListener,
IConfigurableObject,
IMEInteractionHandler {
    public static final MenuType<MEStorageMenu> TYPE = MenuTypeBuilder.create(MEStorageMenu::new, ITerminalHost.class).build("item_terminal");
    public static final MenuType<MEStorageMenu> PORTABLE_ITEM_CELL_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("portable_item_cell");
    public static final MenuType<MEStorageMenu> PORTABLE_FLUID_CELL_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("portable_fluid_cell");
    public static final MenuType<MEStorageMenu> WIRELESS_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("wirelessterm");
    private final List<RestrictedInputSlot> viewCellSlots;
    private final IConfigManager clientCM;
    private final ToolboxMenu toolboxMenu;
    private final ITerminalHost host;
    @GuiSync(value=98)
    public boolean hasPower = false;
    @GuiSync(value=100)
    public int activeCraftingJobs = -1;
    private IConfigManagerListener gui;
    private IConfigManager serverCM;
    @Nullable
    protected final MEStorage storage;
    @Nullable
    protected final IEnergySource powerSource;
    private final IncrementalUpdateHelper updateHelper = new IncrementalUpdateHelper();
    @Nullable
    private IGridNode networkNode;
    @Nullable
    private IClientRepo clientRepo;
    private Set<AEKey> previousCraftables = Collections.emptySet();
    private KeyCounter previousAvailableStacks = new KeyCounter();

    public MEStorageMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host) {
        this(menuType, id, ip, host, true);
    }

    protected MEStorageMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host);
        this.host = host;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        IEnergySource powerSource = null;
        if (this.isServerSide()) {
            this.serverCM = host.getConfigManager();
            this.storage = host.getInventory();
            if (this.storage != null) {
                IActionHost actionHost;
                IGridNode node;
                if (host instanceof IPortableTerminal || host instanceof IMEChest) {
                    powerSource = (IEnergySource)((Object)host);
                } else if (host instanceof IActionHost && (node = (actionHost = (IActionHost)((Object)host)).getActionableNode()) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    powerSource = new ChannelPowerSrc(this.networkNode, g.getEnergyService());
                }
            } else {
                this.setValidMenu(false);
            }
        } else {
            this.storage = null;
        }
        this.powerSource = powerSource;
        if (!this.hideViewCells() && host instanceof IViewCellStorage) {
            InternalInventory viewCellStorage = ((IViewCellStorage)((Object)host)).getViewCellStorage();
            this.viewCellSlots = new ArrayList<RestrictedInputSlot>(viewCellStorage.size());
            for (int i = 0; i < viewCellStorage.size(); ++i) {
                RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.VIEW_CELL, viewCellStorage, i);
                this.addSlot(slot, SlotSemantics.VIEW_CELL);
                this.viewCellSlots.add(slot);
            }
        } else {
            this.viewCellSlots = Collections.emptyList();
        }
        this.toolboxMenu = new ToolboxMenu(this);
        this.setupUpgrades(host.getUpgrades());
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    public ToolboxMenu getToolbox() {
        return this.toolboxMenu;
    }

    protected boolean hideViewCells() {
        return false;
    }

    @Nullable
    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean isKeyVisible(AEKey key) {
        ItemMenuHost itemMenuHost;
        Item item;
        ITerminalHost iTerminalHost = this.host;
        if (iTerminalHost instanceof ItemMenuHost && (item = (itemMenuHost = (ItemMenuHost)((Object)iTerminalHost)).getItemStack().m_41720_()) instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)item;
            return basicCellItem.getKeyType().contains(key);
        }
        return true;
    }

    @Override
    public void m_38946_() {
        this.toolboxMenu.tick();
        if (this.isServerSide()) {
            if (this.storage != this.host.getInventory()) {
                this.setValidMenu(false);
                return;
            }
            this.updateActiveCraftingJobs();
            for (Setting<?> set : this.serverCM.getSettings()) {
                Object sideRemote;
                Object sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                set.copy(this.serverCM, this.clientCM);
                this.sendPacketToClient(new ConfigValuePacket(set, this.serverCM));
            }
            Set<AEKey> craftables = this.getCraftablesFromGrid();
            KeyCounter availableStacks = this.storage == null ? new KeyCounter() : this.storage.getAvailableStacks();
            KeyCounter requestables = new KeyCounter();
            try {
                Sets.difference(this.previousCraftables, craftables).forEach(this.updateHelper::addChange);
                Sets.difference(craftables, this.previousCraftables).forEach(this.updateHelper::addChange);
                this.previousAvailableStacks.removeAll(availableStacks);
                this.previousAvailableStacks.removeZeros();
                this.previousAvailableStacks.keySet().forEach(this.updateHelper::addChange);
                if (this.updateHelper.hasChanges()) {
                    MEInventoryUpdatePacket.Builder builder = MEInventoryUpdatePacket.builder(this.f_38840_, this.updateHelper.isFullUpdate());
                    builder.setFilter(this::isKeyVisible);
                    builder.addChanges(this.updateHelper, availableStacks, craftables, requestables);
                    builder.buildAndSend(x$0 -> this.sendPacketToClient((BasePacket)x$0));
                    this.updateHelper.commitChanges();
                }
            }
            catch (Exception e) {
                AELog.warn(e, "Failed to send incremental inventory update to client");
            }
            this.previousCraftables = ImmutableSet.copyOf(craftables);
            this.previousAvailableStacks = availableStacks;
            this.updatePowerStatus();
            super.m_38946_();
        }
    }

    protected boolean showsCraftables() {
        return true;
    }

    private Set<AEKey> getCraftablesFromGrid() {
        ITerminalHost iTerminalHost;
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && (iTerminalHost = this.host) instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)((Object)iTerminalHost);
            hostNode = actionHost.getActionableNode();
        }
        if (!this.showsCraftables()) {
            return Collections.emptySet();
        }
        if (hostNode != null && hostNode.isActive()) {
            return hostNode.getGrid().getCraftingService().getCraftables(this::isKeyVisible);
        }
        return Collections.emptySet();
    }

    protected void updatePowerStatus() {
        if (this.networkNode != null) {
            this.hasPower = this.networkNode.isActive();
        } else {
            IEnergySource iEnergySource = this.powerSource;
            if (iEnergySource instanceof IEnergyService) {
                IEnergyService energyService = (IEnergyService)iEnergySource;
                this.hasPower = energyService.isNetworkPowered();
            } else {
                this.hasPower = this.powerSource != null ? this.powerSource.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8 : false;
            }
        }
    }

    private void updateActiveCraftingJobs() {
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && this.host instanceof IActionHost) {
            hostNode = ((IActionHost)((Object)this.host)).getActionableNode();
        }
        IGrid grid = null;
        if (hostNode != null) {
            grid = hostNode.getGrid();
        }
        if (grid == null) {
            this.activeCraftingJobs = -1;
            return;
        }
        int activeJobs = 0;
        for (ICraftingCPU cpus : grid.getCraftingService().getCpus()) {
            if (!cpus.isBusy()) continue;
            ++activeJobs;
        }
        this.activeCraftingJobs = activeJobs;
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.getGui() != null) {
            this.getGui().onSettingChanged(manager, setting);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (this.isServerSide()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public List<ItemStack> getViewCells() {
        return this.viewCellSlots.stream().map(AppEngSlot::m_7993_).collect(Collectors.toList());
    }

    protected final boolean canInteractWithGrid() {
        return this.storage != null && this.powerSource != null && this.isPowered();
    }

    @Override
    public final void handleInteraction(long serial, InventoryAction action) {
        if (this.isClientSide()) {
            NetworkHandler.instance().sendToServer(new MEInteractionPacket(this.f_38840_, serial, action));
            return;
        }
        if (!this.canInteractWithGrid()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.getPlayerInventory().f_35978_;
        if (serial == -1L) {
            this.handleNetworkInteraction(player, null, action);
            return;
        }
        AEKey stack = this.getStackBySerial(serial);
        if (stack == null) {
            return;
        }
        this.handleNetworkInteraction(player, stack, action);
    }

    protected void handleNetworkInteraction(ServerPlayer player, @Nullable AEKey clickedKey, InventoryAction action) {
        if (this.storage == null) {
            return;
        }
        if (action == InventoryAction.PICKUP_OR_SET_DOWN && ContainerItemStrategies.isKeySupported(clickedKey)) {
            action = InventoryAction.FILL_ITEM;
        }
        if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE && ContainerItemStrategies.getContainedStack(this.m_142621_()) != null) {
            action = InventoryAction.EMPTY_ITEM;
        }
        if (action == InventoryAction.FILL_ITEM) {
            this.tryFillContainerItem(clickedKey, false);
        } else if (action == InventoryAction.SHIFT_CLICK) {
            this.tryFillContainerItem(clickedKey, true);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            this.handleEmptyHeldItem((what, amount, mode) -> StorageHelper.poweredInsert(this.powerSource, this.storage, what, amount, this.getActionSource(), mode));
        } else if (action == InventoryAction.AUTO_CRAFT) {
            MenuLocator locator = this.getLocator();
            if (locator != null && clickedKey != null) {
                CraftAmountMenu.open(player, locator, clickedKey, clickedKey.getAmountPerUnit());
            }
            return;
        }
        if (clickedKey == null) {
            if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE || action == InventoryAction.ROLL_DOWN) {
                this.putCarriedItemIntoNetwork(true);
            } else if (action == InventoryAction.PICKUP_OR_SET_DOWN) {
                this.putCarriedItemIntoNetwork(false);
            }
            return;
        }
        if (!(clickedKey instanceof AEItemKey)) {
            return;
        }
        AEItemKey clickedItem = (AEItemKey)clickedKey;
        switch (action) {
            case SHIFT_CLICK: {
                this.moveOneStackToPlayer(clickedItem);
                break;
            }
            case ROLL_DOWN: {
                AEItemKey what2;
                long inserted;
                ItemStack carried = this.m_142621_();
                if (carried.m_41619_() || (inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, what2 = AEItemKey.of(carried), 1L, this.getActionSource())) <= 0L) break;
                this.m_142621_().m_41774_(1);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                long extracted;
                ItemStack item = this.m_142621_();
                if (!item.m_41619_()) {
                    if (item.m_41613_() >= item.m_41741_()) {
                        return;
                    }
                    if (!clickedItem.matches(item)) {
                        return;
                    }
                }
                if ((extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, 1L, this.getActionSource())) <= 0L) break;
                if (item.m_41619_()) {
                    this.m_142503_(clickedItem.toStack());
                    break;
                }
                item.m_41769_(1);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (!this.m_142621_().m_41619_()) {
                    this.putCarriedItemIntoNetwork(false);
                    break;
                }
                long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, clickedItem.getMaxStackSize(), this.getActionSource());
                if (extracted > 0L) {
                    this.m_142503_(clickedItem.toStack((int)extracted));
                    break;
                }
                this.m_142503_(ItemStack.f_41583_);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!this.m_142621_().m_41619_()) {
                    this.putCarriedItemIntoNetwork(true);
                    break;
                }
                long extracted = this.storage.extract(clickedItem, clickedItem.getMaxStackSize(), Actionable.SIMULATE, this.getActionSource());
                if (extracted > 0L) {
                    extracted = extracted + 1L >> 1;
                    extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, extracted, this.getActionSource());
                }
                if (extracted > 0L) {
                    this.m_142503_(clickedItem.toStack((int)extracted));
                    break;
                }
                this.m_142503_(ItemStack.f_41583_);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.m_150110_().f_35937_) break;
                ItemStack is = clickedItem.toStack();
                is.m_41764_(is.m_41741_());
                this.m_142503_(is);
                break;
            }
            case MOVE_REGION: {
                int playerInv = player.m_150109_().f_35974_.size();
                for (int slotNum = 0; slotNum < playerInv && this.moveOneStackToPlayer(clickedItem); ++slotNum) {
                }
                break;
            }
            default: {
                AELog.warn("Received unhandled inventory action %s from client in %s", new Object[]{action, this.getClass()});
            }
        }
    }

    private void tryFillContainerItem(@Nullable AEKey clickedKey, boolean moveToPlayer) {
        AEFluidKey fluidKey;
        boolean grabbedEmptyBucket = false;
        if (this.m_142621_().m_41619_() && clickedKey instanceof AEFluidKey && (fluidKey = (AEFluidKey)clickedKey).getFluid().m_6859_() != Items.f_41852_ && this.storage != null && this.storage.extract(AEItemKey.of((ItemLike)Items.f_42446_), 1L, Actionable.MODULATE, this.getActionSource()) >= 1L) {
            ItemStack bucket = Items.f_42446_.m_7968_();
            this.m_142503_(bucket);
            grabbedEmptyBucket = true;
        }
        Item carriedBefore = this.m_142621_().m_41720_();
        this.handleFillingHeldItem((amount, mode) -> StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedKey, amount, this.getActionSource(), mode), clickedKey);
        if (grabbedEmptyBucket && this.m_142621_().m_150930_(Items.f_42446_)) {
            long inserted = this.storage.insert(AEItemKey.of(this.m_142621_()), this.m_142621_().m_41613_(), Actionable.MODULATE, this.getActionSource());
            ItemStack newCarried = this.m_142621_().m_41777_();
            newCarried.m_41774_(Ints.saturatedCast((long)inserted));
            this.m_142503_(newCarried);
        }
        if (moveToPlayer && !this.m_142621_().m_150930_(carriedBefore) && this.getPlayer().m_36356_(this.m_142621_())) {
            this.m_142503_(ItemStack.f_41583_);
        }
    }

    protected void putCarriedItemIntoNetwork(boolean singleItem) {
        ItemStack heldStack = this.m_142621_();
        AEItemKey what = AEItemKey.of(heldStack);
        if (what == null) {
            return;
        }
        int amount = heldStack.m_41613_();
        if (singleItem) {
            amount = 1;
        }
        long inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, what, amount, this.getActionSource());
        this.m_142503_(Platform.getInsertionRemainder(heldStack, inserted));
    }

    private boolean moveOneStackToPlayer(AEItemKey stack) {
        int toExtract;
        ItemStack myItem = stack.toStack();
        Inventory playerInv = this.getPlayerInventory();
        int slot = playerInv.m_36050_(myItem);
        if (slot != -1) {
            toExtract = myItem.m_41741_() - playerInv.m_8020_(slot).m_41613_();
        } else {
            slot = playerInv.m_36062_();
            if (slot == -1) {
                return false;
            }
            toExtract = myItem.m_41741_();
        }
        if (toExtract <= 0) {
            return false;
        }
        long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, stack, toExtract, this.getActionSource());
        if (extracted == 0L) {
            return false;
        }
        ItemStack itemInSlot = playerInv.m_8020_(slot);
        if (itemInSlot.m_41619_()) {
            playerInv.m_6836_(slot, stack.toStack((int)extracted));
        } else {
            itemInSlot.m_41769_((int)extracted);
        }
        return true;
    }

    @Nullable
    protected final AEKey getStackBySerial(long serial) {
        return this.updateHelper.getBySerial(serial);
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private IConfigManagerListener getGui() {
        return this.gui;
    }

    public void setGui(IConfigManagerListener gui) {
        this.gui = gui;
    }

    @Nullable
    public IClientRepo getClientRepo() {
        return this.clientRepo;
    }

    public void setClientRepo(@Nullable IClientRepo clientRepo) {
        this.clientRepo = clientRepo;
    }

    @Override
    protected ItemStack transferStackToMenu(ItemStack input) {
        if (!this.canInteractWithGrid()) {
            return super.transferStackToMenu(input);
        }
        AEItemKey key = AEItemKey.of(input);
        if (key == null || !this.isKeyVisible(key)) {
            return input;
        }
        long inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, key, input.m_41613_(), this.getActionSource());
        return Platform.getInsertionRemainder(input, inserted);
    }

    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getByIngredient(ingredient)) {
                int reservedAmount = reservedAmounts.getOrDefault((Object)stack, 0);
                if (stack.getStoredAmount() - (long)reservedAmount < 1L) continue;
                reservedAmounts.merge((Object)stack, 1, Integer::sum);
                return true;
            }
        }
        return false;
    }

    protected final KeyCounter getPreviousAvailableStacks() {
        Preconditions.checkState((boolean)this.isServerSide());
        return this.previousAvailableStacks;
    }

    public boolean canConfigureTypeFilter() {
        return this.host.getConfigManager().hasSetting(Settings.TYPE_FILTER);
    }

    public ITerminalHost getHost() {
        return this.host;
    }
}

