/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.example.common.entities;

import com.nukateam.example.common.registery.EntityTypes;
import java.util.Collections;
import java.util.List;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Brahmin
extends Cow
implements GeoEntity,
Shearable,
IForgeShearable {
    private static final EntityDataAccessor<Boolean> HAS_BALLS = SynchedEntityData.m_135353_(Brahmin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean partyBrahmin;

    public Brahmin(EntityType<? extends Cow> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BALLS, (Object)true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasBalls", this.hasBalls());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hasBalls(compound.m_128471_("hasBalls"));
    }

    @Nullable
    public Brahmin getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (Brahmin)((EntityType)EntityTypes.BRAHMIN.get()).m_20615_((Level)level);
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.m_6220_();
    }

    public boolean m_6220_() {
        return this.hasBalls();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        SoundSource soundSource = player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS;
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, soundSource, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        return Collections.emptyList();
    }

    public void m_5851_(SoundSource pSource) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, pSource, 1.0f, 1.0f);
        this.hasBalls(false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation animation = RawAnimation.begin();
            if (this.isPartyBrahmin() && !this.hasBalls()) {
                animation.thenLoop("dance");
            } else if (event.isMoving()) {
                animation.thenLoop("walk");
            } else {
                return PlayState.STOP;
            }
            return event.setAndContinue(animation);
        })});
    }

    public void m_6818_(BlockPos pPos, boolean pIsPartying) {
        this.partyBrahmin = pIsPartying;
    }

    public boolean m_35506_() {
        return this.hasBalls();
    }

    public boolean m_5957_() {
        return super.m_5957_() && this.hasBalls();
    }

    public boolean isPartyBrahmin() {
        return this.partyBrahmin;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean hasBalls() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BALLS);
    }

    public void hasBalls(boolean value) {
        this.f_19804_.m_135381_(HAS_BALLS, (Object)value);
    }

    private void spawnItemEntity(ItemStack stack) {
        ItemEntity itemEntity = this.m_19983_(stack);
        if (itemEntity != null) {
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }
}

