/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.animators;

import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.client.audio.GunShotSound;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.client.handlers.ClientTickHandler;
import com.nukateam.ntgl.client.model.gun.ThrowableItemModel;
import com.nukateam.ntgl.client.render.renderers.weapon.ThrowableItemRenderer;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.data.config.ThrowableConfig;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.util.helpers.PlayerHelper;
import com.nukateam.ntgl.common.util.interfaces.IConfigProvider;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.AnimationHelper;
import com.nukateam.ntgl.common.util.util.ThrowableStateHelper;
import java.util.HashMap;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.keyframe.event.SoundKeyframeEvent;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ThrowableAnimator
extends ItemAnimator
implements IConfigProvider<ThrowableConfig> {
    public static final String PREPARE = "prepare";
    public static final String PREPARE_SAFE = "prepare_safe";
    public static final String THROW = "throw";
    public static final String THROW_SAFE = "throw_safe";
    protected final ThrowableItemRenderer<ThrowableAnimator> renderer;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final AnimationHelper<ThrowableAnimator> animationHelper;
    protected final AnimationController<ThrowableAnimator> TRIGGER_CONTROLLER;
    protected final AnimationController<ThrowableAnimator> MAIN_CONTROLLER;
    protected final AnimationController<ThrowableAnimator> TICKING_CONTROLLER;
    protected final InteractionHand arm;
    protected int equipTime;
    protected int prepareTime;
    protected int throwingTime;
    protected ThrowMode mode;
    protected boolean isEquiping;

    public ThrowableAnimator(ItemDisplayContext transformType, ThrowableItemRenderer<ThrowableAnimator> renderer) {
        super(transformType);
        this.renderer = renderer;
        this.arm = this.getArm();
        ClientTickHandler.addTicker((Object)this, this::tick);
        this.MAIN_CONTROLLER = this.createController("mainController", this.animate()).setSoundKeyframeHandler(this::handleSoundEvent);
        this.TRIGGER_CONTROLLER = this.createController("triggerController", (AnimationController.AnimationStateHandler<ThrowableAnimator>)((AnimationController.AnimationStateHandler)event -> PlayState.CONTINUE));
        this.TICKING_CONTROLLER = this.createController("tickingController", this.animateTick());
        this.animationHelper = new AnimationHelper<ThrowableAnimator>(this, ThrowableItemModel.INSTANCE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.MAIN_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.TRIGGER_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.TICKING_CONTROLLER});
    }

    @Override
    public ThrowableConfig getConfig() {
        Item item = this.getStack().m_41720_();
        if (item instanceof IThrowable) {
            IThrowable item2 = (IThrowable)item;
            return item2.getConfig();
        }
        return new ThrowableConfig();
    }

    public void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    protected void tickStart() {
        Item item = this.getStack().m_41720_();
        if (item instanceof IThrowable) {
            IThrowable throwable = (IThrowable)item;
            this.prepareTime = throwable.getConfig().getGeneral().getPrepareTime();
            this.throwingTime = throwable.getConfig().getGeneral().getThrowTime();
            this.equipTime = throwable.getConfig().getGeneral().getEquipTime();
            this.isEquiping = EquipTracker.isEquiping(this.getEntity(), this.getArm());
            this.mode = ThrowableStateHelper.getThrowMode(this.getStack());
        }
    }

    protected void tickEnd() {
    }

    protected LivingEntity getEntity() {
        return this.renderer.getRenderEntity();
    }

    protected IThrowable getItem() {
        return (IThrowable)this.getStack().m_41720_();
    }

    @NotNull
    protected AnimationController<ThrowableAnimator> createController(String name, AnimationController.AnimationStateHandler<ThrowableAnimator> animate) {
        return new AnimationController((GeoAnimatable)this, name, 0, animate);
    }

    protected InteractionHand getArm() {
        return TransformUtils.isRightHand(this.transformType) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    protected AnimationController.AnimationStateHandler<ThrowableAnimator> animate() {
        return event -> {
            try {
                AnimationController controller = event.getController();
                controller.setAnimationSpeed(1.0);
                RawAnimation holdAnimation = this.getHoldAnimation((AnimationState<ThrowableAnimator>)event);
                if (!TransformUtils.isHandTransform(this.transformType)) {
                    return PlayState.STOP;
                }
                RawAnimation animation = RawAnimation.begin();
                animation = this.equipTime > 0 && this.isEquiping ? this.getEquipAnimation((AnimationState<ThrowableAnimator>)event) : (this.isPreparing() ? this.getPrepareAnimation((AnimationState<ThrowableAnimator>)event) : (this.isThrowing() ? this.getThrowingAnimation((AnimationState<ThrowableAnimator>)event) : (ClientHandler.getInspectionTicks(this.getArm()) > 0 ? this.getInspectionAnimation((AnimationState<ThrowableAnimator>)event) : holdAnimation)));
                return event.setAndContinue(animation);
            }
            catch (Exception e) {
                return PlayState.STOP;
            }
        };
    }

    protected boolean isPreparing() {
        return (Boolean)ModSyncedDataKeys.getPreparingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected boolean isHolding() {
        return (Boolean)ModSyncedDataKeys.getHoldingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected boolean isThrowing() {
        return (Boolean)ModSyncedDataKeys.getThrowingDataKey(this.getArm()).getValue((Entity)this.getEntity());
    }

    protected AnimationController.AnimationStateHandler<ThrowableAnimator> animateTick() {
        return event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation holdAnimation = this.getHoldAnimation((AnimationState<ThrowableAnimator>)event);
            if (!TransformUtils.isHandTransform(this.transformType)) {
                return PlayState.STOP;
            }
            RawAnimation animation = RawAnimation.begin();
            if (this.mode != ThrowMode.UNSAFE || !this.isHolding() && !this.isThrowing()) {
                return PlayState.STOP;
            }
            animation = this.getTickingAnimation((AnimationState<ThrowableAnimator>)event);
            return event.setAndContinue(animation);
        };
    }

    @NotNull
    protected static RawAnimation getHideAnimation() {
        return RawAnimation.begin().then("hide", Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    protected RawAnimation getInspectionAnimation(AnimationState<ThrowableAnimator> event) {
        RawAnimation animation = this.playGunAnim("inspect", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "inspect", ClientHandler.getMaxInspectionTicks());
        return animation;
    }

    protected RawAnimation getHoldAnimation(AnimationState<ThrowableAnimator> event) {
        return this.playGunAnim("hold", Animation.LoopType.LOOP);
    }

    protected RawAnimation getTickingAnimation(AnimationState<ThrowableAnimator> event) {
        RawAnimation animation = this.playGunAnim("ticking", Animation.LoopType.LOOP);
        return animation;
    }

    protected RawAnimation getEquipAnimation(AnimationState<ThrowableAnimator> event) {
        RawAnimation animation = this.playGunAnim("equip", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, this.equipTime, "equip");
        return animation;
    }

    protected RawAnimation getPrepareAnimation(AnimationState<ThrowableAnimator> event) {
        String name = PREPARE;
        if (this.mode == ThrowMode.SAFE && this.animationHelper.hasAnimation(PREPARE_SAFE)) {
            name = PREPARE_SAFE;
        }
        RawAnimation animation = this.playGunAnim(name, Animation.LoopType.HOLD_ON_LAST_FRAME);
        this.animationHelper.syncAnimation(event, this.prepareTime, name);
        return animation;
    }

    protected RawAnimation getThrowingAnimation(AnimationState<ThrowableAnimator> event) {
        String name = THROW;
        if (this.mode == ThrowMode.SAFE && this.animationHelper.hasAnimation(THROW_SAFE)) {
            name = THROW_SAFE;
        }
        RawAnimation animation = this.playGunAnim(name, Animation.LoopType.HOLD_ON_LAST_FRAME);
        this.animationHelper.syncAnimation(event, this.throwingTime, name);
        return animation;
    }

    protected void handleSoundEvent(SoundKeyframeEvent<ThrowableAnimator> event) {
        LocalPlayer player = this.minecraft.f_91074_;
        String name = event.getKeyframeData().getSound();
        HashMap<String, ResourceLocation> sounds = this.getItem().getConfig().getSoundsMap();
        ResourceLocation sound = sounds.get(name);
        if (sound != null && player != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)new GunShotSound(sound, SoundSource.PLAYERS, player.m_20182_(), 1.0f, 1.0f, true));
        }
    }

    protected RawAnimation playGunAnim(String name, Animation.LoopType loopType) {
        return RawAnimation.begin().then(this.getGunAnim(name), loopType);
    }

    protected String getGunAnim(String name) {
        boolean hasShield;
        LivingEntity entity = this.getEntity();
        ItemStack currentItem = entity.m_21120_(this.arm);
        ItemStack oppositeItem = entity.m_21120_(PlayerHelper.getOpposite(this.arm));
        boolean isOneHanded = this.isOneHanded(currentItem) && this.isOneHanded(oppositeItem) || this.arm == InteractionHand.OFF_HAND;
        boolean bl = hasShield = this.isOneHanded(currentItem) && oppositeItem.m_41720_() instanceof ShieldItem;
        if ((hasShield || isOneHanded) && this.animationHelper.hasAnimation(name + "_one_hand")) {
            return name + "_one_hand";
        }
        return name;
    }

    public boolean isOneHanded(ItemStack item) {
        return false;
    }
}

