/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.handlers;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.input.GunButtonBindings;
import com.nukateam.ntgl.client.render.screen.AttachmentScreen;
import com.nukateam.ntgl.client.render.screen.WorkbenchScreen;
import com.nukateam.ntgl.client.settings.OptionInstances;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.BulletTrailRenderingHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ControllerHandler;
import com.nukateam.ntgl.client.util.handler.CrosshairHandler;
import com.nukateam.ntgl.client.util.handler.EntityModelHandler;
import com.nukateam.ntgl.client.util.handler.GunRenderingHandler;
import com.nukateam.ntgl.client.util.handler.RecoilHandler;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.client.util.handler.SoundHandler;
import com.nukateam.ntgl.client.util.util.PropertyHelper;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.EditorScreen;
import com.nukateam.ntgl.common.foundation.init.ModContainers;
import com.nukateam.ntgl.common.foundation.item.interfaces.IColored;
import com.nukateam.ntgl.modules.gunpack.regestry.ModBlocks;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.MouseSettingsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ClientHandler {
    public static final int INSPECTION_DURATION = 60;
    public static final int INSPECTION_OFFSET = 5;
    private static Field mouseOptionsField;
    private static int inspectionTimerRight;
    private static int inspectionTimerLeft;

    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)AimingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)CrosshairHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)GunRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)RecoilHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ClientReloadHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ShootingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)SoundHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)new EntityModelHandler());
        if (Ntgl.controllableLoaded) {
            ControllerHandler.init();
            GunButtonBindings.register();
        }
        ClientHandler.setupRenderLayers();
        ClientHandler.registerColors();
        ClientHandler.registerScreenFactories();
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WORKBENCH.get()), (RenderType)RenderType.m_110463_());
    }

    private static void registerColors() {
        ItemColor color = (stack, index) -> {
            ItemStack renderingWeapon;
            if (!IColored.isDyeable(stack)) {
                return -1;
            }
            if (index == 0 && stack.m_41782_() && stack.m_41783_().m_128425_("Color", 3)) {
                return stack.m_41783_().m_128451_("Color");
            }
            if (index == 0 && stack.m_41720_() instanceof IAttachment && (renderingWeapon = GunRenderingHandler.get().getRenderingWeapon()) != null) {
                return Minecraft.m_91087_().getItemColors().m_92676_(renderingWeapon, index);
            }
            if (index == 2) {
                return PropertyHelper.getReticleColor(stack);
            }
            return -1;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof IColored) {
                Minecraft.m_91087_().getItemColors().m_92689_(color, new ItemLike[]{item});
            }
        });
    }

    private static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.WORKBENCH.get()), WorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ATTACHMENTS.get()), AttachmentScreen::new);
    }

    public static void resetInspectionTimer() {
        inspectionTimerRight = 60;
    }

    public static int getInspectionTicks(InteractionHand arm) {
        return arm == InteractionHand.MAIN_HAND ? inspectionTimerRight : inspectionTimerLeft;
    }

    public static boolean isInspecting() {
        return inspectionTimerRight > 0 || inspectionTimerLeft > 0;
    }

    public static int getMaxInspectionTicks() {
        return 60;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (inspectionTimerRight == 58) {
                inspectionTimerLeft = 60;
            }
            if (inspectionTimerRight > 0) {
                --inspectionTimerRight;
            }
            if (inspectionTimerLeft > 0) {
                --inspectionTimerLeft;
            }
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof MouseSettingsScreen) {
            MouseSettingsScreen screen2 = (MouseSettingsScreen)screen;
            if (mouseOptionsField == null) {
                mouseOptionsField = ObfuscationReflectionHelper.findField(MouseSettingsScreen.class, (String)"f_96218_");
                mouseOptionsField.setAccessible(true);
            }
            try {
                OptionsList list = (OptionsList)mouseOptionsField.get(screen2);
                list.m_232530_(OptionInstances.createSensitivitySlider(), null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> PropertyHelper.resetCache()));
    }

    public static Screen createEditorScreen(IEditorMenu menu) {
        return new EditorScreen(Minecraft.m_91087_().f_91080_, menu);
    }

    public static int getInspectionTimerRight() {
        return inspectionTimerRight;
    }

    public static void setInspectionTimerRight(int inspectionTimerRight) {
        ClientHandler.inspectionTimerRight = inspectionTimerRight;
    }
}

