/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.ntgl.client.event.GunHudEvent;
import com.nukateam.ntgl.client.render.hud.cache.GunHudCache;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.util.RgbUtils;
import com.nukateam.ntgl.client.util.util.render.Figures;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoType;
import com.nukateam.ntgl.common.data.holders.CounterType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GunHud
implements IGuiOverlay {
    public static final float COUNTER_SCALE = 0.9f;
    public static final int INVENTORY_AMMO_COUNT_COLOR = 0xAAAAAA;
    public static final int DEFAULT_AMMO_COLOR = 0xFFFFFF;
    public static final int LOW_AMMO_COLOR = 0xFF5555;
    public static final Colors DEFAULT_COLORS = new Colors(0xFFFFFF, 0xAAAAAA, 0xFFFFFF, 0xFF5555);
    protected static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    protected static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    protected static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static final int ICON_X = 115;
    private static final int OFFHAND_X_OFFSET = 110;
    private static final int BAR_WIDTH = 35;
    private static final int BAR_HEIGHT = 6;
    public static final int COUNTER_POS_X = 70;
    public static final int ICON_SIZE = 16;
    public static final int COUNTER_POS_Y = 36;
    private static final int BAR_START_X = 70;
    private static final int BAR_START_Y = 57;
    protected static final Map<InteractionHand, GunHudCache> cache = Map.of(InteractionHand.MAIN_HAND, new GunHudCache(InteractionHand.MAIN_HAND), InteractionHand.OFF_HAND, new GunHudCache(InteractionHand.OFF_HAND));
    public static final int INVENTORY_AMMO_POS_Y = 25;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    private Colors colors = DEFAULT_COLORS;
    public static final IGuiOverlay AMMO_HUD = new GunHud();

    public void setHudColor(Colors hudColor) {
        this.colors = hudColor;
    }

    public void resetHudColor() {
        this.colors = DEFAULT_COLORS;
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        LocalPlayer player = this.minecraft.f_91074_;
        GunHud.cache.forEach((hand, cache) -> {
            int x;
            ItemStack heldItem = player.m_21120_(hand);
            int n = x = hand == InteractionHand.OFF_HAND ? 110 : width;
            if (heldItem.m_41720_() instanceof WeaponItem && GunHud.shouldRender(hand, player)) {
                this.updateCache((GunHudCache)cache, player, heldItem);
                if (!MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.START))) {
                    this.renderAmmoCounter(graphics, (GunHudCache)cache, heldItem, x, height);
                    MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.END));
                }
            }
        });
    }

    private static boolean shouldRender(InteractionHand hand, LocalPlayer player) {
        return hand == InteractionHand.MAIN_HAND || GunModifierHelper.canRenderInOffhand((LivingEntity)player);
    }

    protected void renderAmmoCounter(GuiGraphics graphics, GunHudCache handCache, ItemStack stack, int x, int y) {
        if (!GunModifierHelper.shouldRenderHud(new GunData(stack, (LivingEntity)this.minecraft.f_91074_))) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Objects.requireNonNull(this.minecraft.f_91062_);
        int fontHeight = 9;
        this.renderAmmoTypeIcon(graphics, handCache, x - 70 - 16 - 2, y - 36 - 11);
        this.renderCurrentAmmo(graphics, handCache, x - 70, y - 36 - fontHeight, poseStack);
        Figures.drawLine(graphics, x - 70, y - 31, 27, 2, RgbUtils.toRgba(this.colors.hud));
        this.renderFireModeIcon(graphics, handCache, x - 70 - 16 - 2, y - 25 - 6);
        this.renderInventoryAmmo(graphics, handCache, x - 70 + 3, y - 25, poseStack, this.minecraft.f_91062_);
        this.renderFuelCounters(graphics, handCache, stack, x - 70 + 8 + ClientDebug.X, y - 57 - 3 + ClientDebug.Y);
        poseStack.m_85849_();
    }

    protected void renderCurrentAmmo(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack) {
        String currentAmmoCountText = "";
        if (handCache.ammoConfig.getCounter() == CounterType.NUMBER) {
            currentAmmoCountText = CURRENT_AMMO_FORMAT.format(handCache.ammoCount);
            this.renderCounter(graphics, handCache, x, y, poseStack, currentAmmoCountText);
        } else if (handCache.ammoConfig.getCounter() == CounterType.PERCENT) {
            float percent = (float)handCache.ammoCount / (float)handCache.maxAmmoCount;
            currentAmmoCountText = CURRENT_AMMO_FORMAT_PERCENT.format(percent);
            this.renderCounter(graphics, handCache, x, y, poseStack, currentAmmoCountText);
        } else if (handCache.ammoConfig.getCounter() == CounterType.BAR) {
            float percent = (float)handCache.ammoCount / (float)handCache.maxAmmoCount;
            this.renderBarCounter(graphics, percent, x, y);
        }
    }

    protected void renderFuelCounters(GuiGraphics graphics, GunHudCache handCache, ItemStack stack, int x, int y) {
        int barOffsetY = 0;
        for (Map.Entry<AmmoHolder, Fuel> entry : handCache.fuels.entrySet()) {
            GunData gunData = new GunData(stack, (LivingEntity)this.minecraft.f_91074_);
            float fuelPercent = FuelUtils.getFuelPercent(stack, entry.getKey(), gunData);
            this.renderIcon(graphics, entry.getValue().getAmmo().getAmmoType().getIcon(), x - 16 - 2, y - 5 - barOffsetY);
            this.renderBarCounter(graphics, fuelPercent, x, y - barOffsetY);
            barOffsetY += 16;
        }
    }

    private void renderCounter(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack, String currentAmmoCountText) {
        int ammoCountColor = (double)handCache.ammoCount < (double)handCache.maxAmmoCount * 0.25 ? this.colors.lowAmmo : this.colors.currentAmmo;
        poseStack.m_85836_();
        float scale = 1.5f;
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.drawString(this.minecraft.f_91062_, currentAmmoCountText, (float)x / scale, (float)y / scale, ammoCountColor, true);
        poseStack.m_85849_();
    }

    protected void renderBarCounter(GuiGraphics graphics, float percent, int x, int y) {
        int color = (double)percent < 0.25 ? this.colors.lowAmmo : this.colors.currentAmmo;
        Figures.drawBar(graphics, x, y, 35, 6, percent, RgbUtils.toRgba(color));
    }

    protected void renderInventoryAmmo(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack, Font font) {
        String inventoryAmmoCountText = INVENTORY_AMMO_FORMAT.format(handCache.inventoryAmmoCount);
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 1.0f);
        graphics.drawString(font, inventoryAmmoCountText, (float)x / 0.9f, (float)y / 0.9f, this.colors.inventoryAmmo, true);
        poseStack.m_85849_();
    }

    protected void renderAmmoTypeIcon(GuiGraphics graphics, GunHudCache handCache, int x, int y) {
        AmmoType ammoType = handCache.ammoConfig.getAmmoType();
        ResourceLocation icon = ammoType.getIcon();
        this.renderIcon(graphics, icon, x, y);
    }

    protected void renderFireModeIcon(GuiGraphics graphics, GunHudCache handCache, int x, int y) {
        FireMode fireMode = handCache.fireMode;
        ResourceLocation icon = fireMode.getIcon();
        this.renderIcon(graphics, icon, x, y);
    }

    protected void renderIcon(GuiGraphics graphics, ResourceLocation icon, int x, int y) {
        float[] iconColor = RgbUtils.rgbToFloatRgba(this.colors.hud);
        RenderSystem.setShaderColor((float)iconColor[0], (float)iconColor[1], (float)iconColor[2], (float)iconColor[3]);
        graphics.m_280163_(icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getIconX(GunHudCache handCache, double textWidth) {
        if (handCache.hand == InteractionHand.OFF_HAND) {
            return 115 - (int)textWidth - 20;
        }
        return 115;
    }

    protected void updateCache(GunHudCache handCache, LocalPlayer player, ItemStack weapon) {
        if (System.currentTimeMillis() - handCache.checkAmmoTimestamp > 200L) {
            GunData data = new GunData(weapon, (LivingEntity)player);
            handCache.checkAmmoTimestamp = System.currentTimeMillis();
            handCache.maxAmmoCount = GunModifierHelper.getMaxAmmo(data);
            handCache.fireMode = GunStateHelper.getFireMode(data);
            handCache.ammoCount = GunStateHelper.getAmmoCount(data);
            handCache.ammoConfig = GunModifierHelper.getGun(weapon).getAmmoConfig(GunStateHelper.getCurrentAmmo(data).getId());
            Set<AmmoHolder> fuels = GunModifierHelper.getAllFuel(data);
            handCache.fuels.clear();
            for (AmmoHolder id : fuels) {
                Fuel value = GunModifierHelper.getFuel(id.getId(), data);
                handCache.fuels.put(id, value);
            }
            handCache.inventoryAmmoCount = !player.m_7500_() ? this.getInventoryAmmoCount(weapon, player.m_150109_()) : 9999;
        }
    }

    protected int getInventoryAmmoCount(ItemStack weapon, Inventory inventory) {
        int inventoryAmmoCount = 0;
        GunData gunData = new GunData(weapon, (LivingEntity)this.minecraft.f_91074_);
        AmmoHolder ammoHolder = GunStateHelper.getCurrentAmmo(gunData);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (!ammoHolder.isAcceptable(inventoryStack)) continue;
            inventoryAmmoCount += inventoryStack.m_41613_() * ammoHolder.getValue(inventoryStack);
        }
        return inventoryAmmoCount;
    }

    public record Colors(int hud, int inventoryAmmo, int currentAmmo, int lowAmmo) {
    }
}

