/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.render.screen.ButtonAlignment;
import com.nukateam.ntgl.client.render.screen.widget.MiniButton;
import com.nukateam.ntgl.client.render.screen.widget.SlotButton;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.util.render.ModelRenderUtil;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.container.AttachmentContainer;
import com.nukateam.ntgl.common.foundation.container.slot.AttachmentSlot;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.data.Pos2I;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;

public class AttachmentScreen
extends AbstractContainerScreen<AttachmentContainer> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("ntgl", "textures/gui/attachments.png");
    private static final ResourceLocation SLOT = new ResourceLocation("ntgl", "textures/gui/slot.png");
    private static final Component CONFIG_TOOLTIP = Component.m_237115_((String)"ntgl.button.config.tooltip");
    public static final String ATTACHMENT_NOT_APPLICABLE = "slot.ntgl.attachment.not_applicable";
    public static final String ATTACHMENT_INCOMPATIBLE = "slot.ntgl.attachment.incompatible";
    public static final String WINDOW_HELP = "container.ntgl.attachments.window_help";
    public static final int SLOT_SIZE = 18;
    public static final int IMAGE_HEIGHT = 214;
    public static final int ATTACHMENT_Y = 107;
    public static final int ATTACHMENT_X = 7;
    public static final int ICON_SIZE = 16;
    private final Inventory playerInventory;
    private final Container weaponInventory;
    private boolean showHelp = true;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;
    private int clickedSlot = -1;
    private final ArrayList<SlotButton> attachmentButtons = new ArrayList();

    public AttachmentScreen(AttachmentContainer screenContainer, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, playerInventory, titleIn);
        this.playerInventory = playerInventory;
        this.weaponInventory = screenContainer.getWeaponInventory();
        this.f_97727_ = 214;
    }

    protected void m_7856_() {
        super.m_7856_();
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_);
                    button.m_252865_(this.f_97735_ + titleWidth + 8 + 3 + i * 13);
                    break;
                }
                case RIGHT: {
                    button.m_252865_(this.f_97735_ + this.f_97726_ - 5 - 10 - (buttons.size() - 1 - i) * 13);
                }
            }
            button.m_253211_(this.f_97736_ + 102 - 5);
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && !(this.f_96541_.f_91074_.m_21205_().m_41720_() instanceof WeaponItem)) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int size = this.weaponInventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            Slot slot = ((AttachmentContainer)this.f_97732_).m_38853_(i);
            if (this.isMouseWithinSlot(mouseX, mouseY, left, top, i) && slot instanceof AttachmentSlot) {
                AttachmentSlot attachmentSlot = (AttachmentSlot)slot;
                this.renderAttachmentTooltip(graphics, mouseX, mouseY, attachmentSlot);
            }
            ++i;
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        this.renderGun(graphics, left, top, mouseX, mouseY, this.getGun());
        graphics.m_280218_(GUI_TEXTURES, left, top, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < this.weaponInventory.m_6643_(); ++i) {
            Pos2I slotPos = this.getAttachmentBgPos(i);
            Slot slot = ((AttachmentContainer)this.f_97732_).m_38853_(i);
            if (!(slot instanceof AttachmentSlot)) continue;
            AttachmentSlot attachmentSlot = (AttachmentSlot)slot;
            AttachmentScreen.renderAttachmentSlot(graphics, attachmentSlot, slotPos);
        }
    }

    private static void renderAttachmentSlot(GuiGraphics graphics, AttachmentSlot attachmentSlot, Pos2I slotPos) {
        graphics.m_280163_(SLOT, slotPos.x, slotPos.y, 0.0f, 0.0f, 18, 18, 18, 18);
        if (!attachmentSlot.m_6657_()) {
            graphics.m_280163_(attachmentSlot.getType().getIcon(), slotPos.x + 1, slotPos.y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public Pos2I getAttachmentBgPos(int clickedSlot, int id) {
        Pos2I slotPos = this.getAttachmentBgPos(clickedSlot);
        int top = (this.f_96544_ - this.f_97727_) / 2;
        return new Pos2I(slotPos.x - 4, top + 80 - 23 * id);
    }

    public Pos2I getAttachmentSlotPos(int clickedSlot, int id) {
        Pos2I pos = this.getAttachmentBgPos(clickedSlot, id);
        int startX = pos.x + 5;
        int startY = pos.y + 6;
        return new Pos2I(startX, startY);
    }

    public static ArrayList<ItemStack> findAttachments(Container inventory, AttachmentType type) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            IAttachment attachment;
            ItemStack stack = inventory.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof IAttachment) || (attachment = (IAttachment)item).getType() != type) continue;
            result.add(stack);
        }
        return result;
    }

    public Pos2I getAttachmentBgPos(int id) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        return new Pos2I(left + 7 + id * 18, top + 107);
    }

    protected void renderAttachmentTooltip(GuiGraphics graphics, int mouseX, int mouseY, AttachmentSlot attachmentSlot) {
        if (!attachmentSlot.m_6659_()) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)attachmentSlot.getType().getTranslationKey()), Component.m_237115_((String)ATTACHMENT_NOT_APPLICABLE)), mouseX, mouseY);
        } else if (attachmentSlot.m_7993_().m_41619_() && !this.isCompatible(((AttachmentContainer)this.f_97732_).m_142621_(), attachmentSlot)) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)ATTACHMENT_INCOMPATIBLE).m_130940_(ChatFormatting.YELLOW)), mouseX, mouseY);
        } else if (attachmentSlot.m_7993_().m_41619_()) {
            graphics.m_280666_(this.f_96547_, List.of(Component.m_237115_((String)attachmentSlot.getType().getTranslationKey())), mouseX, mouseY);
        }
    }

    protected void renderGun(GuiGraphics graphics, int startX, int startY, int mouseX, int mouseY, ItemStack currentItem) {
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(startX + 88), (float)(startY + 60), 100.0f);
        poseStack.m_85841_(50.0f, -50.0f, 50.0f);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252961_(0.0f + (float)ClientDebug.X / 10.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252961_(3.7f + (float)ClientDebug.Y / 10.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(-0.3f + (float)ClientDebug.Z / 10.0f));
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        this.f_96541_.m_91291_().m_115143_(currentItem, ItemDisplayContext.FIXED, false, graphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, ModelRenderUtil.getModel(currentItem));
        buffer.m_109911_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        if (ModelRenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70) && !this.mouseGrabbed && (button == 0 || button == 1)) {
            this.mouseGrabbed = true;
            this.mouseGrabbedButton = button == 1 ? 1 : 0;
            this.mouseClickedX = (int)mouseX;
            this.mouseClickedY = (int)mouseY;
            this.showHelp = false;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && button == 0) {
                this.mouseGrabbed = false;
                this.windowX = (int)((double)this.windowX + (mouseX - (double)this.mouseClickedX - 1.0));
                this.windowY = (int)((double)this.windowY + (mouseY - (double)this.mouseClickedY));
            } else if (this.mouseGrabbedButton == 1 && button == 1) {
                this.mouseGrabbed = false;
                this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
                this.windowRotationY = (float)((double)this.windowRotationY - (mouseY - (double)this.mouseClickedY));
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected ItemStack getGun() {
        return this.f_96541_.f_91074_.m_21205_();
    }

    private void renderHelp(GuiGraphics graphics) {
        if (this.showHelp) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            graphics.m_280056_(this.f_96541_.f_91062_, I18n.m_118938_((String)WINDOW_HELP, (Object[])new Object[0]), 56, 38, 0xFFFFFF, false);
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        if (ModelRenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70)) {
            if (scroll < 0.0 && this.windowZoom > 0) {
                this.showHelp = false;
                --this.windowZoom;
            } else if (scroll > 0.0) {
                this.showHelp = false;
                ++this.windowZoom;
            }
        }
        return false;
    }

    private boolean isMouseWithinSlot(int mouseX, int mouseY, int left, int top, int i) {
        return ModelRenderUtil.isMouseWithin(mouseX, mouseY, left + 7 + i * 18, top + 107, 18, 18);
    }

    private List<MiniButton> gatherButtons() {
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            MiniButton configButton = new MiniButton(0, 0, 192, 0, GUI_TEXTURES, onPress -> this.openConfigScreen());
            configButton.m_257544_(Tooltip.m_257550_((Component)CONFIG_TOOLTIP));
            buttons.add(configButton);
        }
        return buttons;
    }

    private boolean isCompatible(ItemStack stack, AttachmentSlot slot) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IAttachment)) {
            return false;
        }
        IAttachment attachment = (IAttachment)item;
        if (!attachment.getType().equals(slot.getType())) {
            return true;
        }
        if (!attachment.canAttachTo(stack)) {
            return false;
        }
        return slot.m_5857_(stack);
    }

    private void openConfigScreen() {
        ModList.get().getModContainerById("ntgl").ifPresent(container -> {
            Screen screen = container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).map(function -> (Screen)function.screenFunction().apply(this.f_96541_, null)).orElse(null);
            if (screen != null) {
                this.f_96541_.m_91152_(screen);
            } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                MutableComponent modName = Component.m_237113_((String)"Configured");
                modName.m_6270_(modName.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131162_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"ntgl.chat.open_curseforge_page"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")));
                MutableComponent message = Component.m_237110_((String)"ntgl.chat.install_configured", (Object[])new Object[]{modName});
                this.f_96541_.f_91074_.m_5661_((Component)message, false);
            }
        });
    }
}

