/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.Melee;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MeleeWeaponConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    protected Melee melee = new Melee();
    protected General general = new General();
    protected HashMap<String, ResourceLocation> sounds = new HashMap();
    protected HashMap<String, ResourceLocation> textures = new HashMap();
    @Ignored
    protected HashMap<String, ResourceLocation> preparedTextures = new HashMap();

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Melee", (Tag)this.melee.serializeNBT());
        tag.m_128365_("Sounds", (Tag)NbtUtils.serializeStringMap(this.sounds));
        tag.m_128365_("Textures", (Tag)NbtUtils.serializeStringMap(this.textures));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general = General.create(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Melee", 10)) {
            this.melee = Melee.create(tag.m_128469_("Melee"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds = this.deserializeSounds(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Textures", 10)) {
            this.textures = NbtUtils.deserializeRLMap(tag.m_128469_("Textures"));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("melee", (JsonElement)this.melee.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", gson.toJsonTree(this.sounds).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "textures", gson.toJsonTree(this.textures).getAsJsonObject());
        return object;
    }

    public MeleeWeaponConfig copy() {
        MeleeWeaponConfig gun = new MeleeWeaponConfig();
        gun.melee = this.melee.copy();
        gun.general = this.general.copy();
        gun.sounds = (HashMap)this.sounds.clone();
        gun.textures = (HashMap)this.textures.clone();
        return gun;
    }

    public General getGeneral() {
        return this.general;
    }

    public Melee getMelee() {
        return this.melee;
    }

    public HashMap<String, ResourceLocation> getSoundsMap() {
        return this.sounds;
    }

    public Map<String, ResourceLocation> getTextures() {
        return this.preparedTextures;
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : ResourceLocation.m_135820_((String)sound);
    }

    public static MeleeWeaponConfig create(ResourceLocation id, CompoundTag tag) {
        MeleeWeaponConfig gun = new MeleeWeaponConfig();
        gun.deserializeNBT(tag);
        MeleeWeaponConfig.prepareTextures(id.m_135815_(), gun);
        return gun;
    }

    public void onCreated(String id) {
        MeleeWeaponConfig.prepareTextures(id, this);
    }

    private static void prepareTextures(String itemId, MeleeWeaponConfig gun) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompletableFuture.runAsync(() -> gun.textures.forEach((variant, path) -> {
                ResourceLocation texture = MeleeWeaponConfig.getTexture(itemId, path);
                gun.preparedTextures.put((String)variant, texture);
            }));
        }
    }

    @NotNull
    private static ResourceLocation getTexture(String itemId, ResourceLocation path) {
        return ResourceLocation.m_214293_((String)path.m_135827_(), (String)("textures/melee/" + itemId + "/" + path.m_135815_() + ".png"));
    }

    public static class Builder {
        private final MeleeWeaponConfig gun;

        private Builder() {
            this.gun = new MeleeWeaponConfig();
        }

        private Builder(MeleeWeaponConfig gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(MeleeWeaponConfig gun) {
            return new Builder(gun);
        }

        public MeleeWeaponConfig build() {
            return this.gun.copy();
        }
    }
}

