/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.gun;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.AmmoConfig;
import com.nukateam.ntgl.common.data.config.AmmoData;
import com.nukateam.ntgl.common.data.config.Fuel;
import com.nukateam.ntgl.common.data.config.Melee;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.gun.Display;
import com.nukateam.ntgl.common.data.config.gun.General;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.config.gun.Sounds;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.debug.Debug;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugButton;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.util.GunJsonUtil;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Gun
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    protected General general = new General();
    protected Melee melee = new Melee();
    protected HashMap<String, ResourceLocation> sounds = new HashMap();
    protected Display display = new Display();
    protected Modules modules = new Modules();
    protected HashMap<String, ResourceLocation> textures = new HashMap();
    @Ignored
    protected HashMap<String, ResourceLocation> preparedTextures = new HashMap();
    protected LinkedHashMap<ResourceLocation, AmmoData> ammoData = new LinkedHashMap();
    protected LinkedHashMap<ResourceLocation, Fuel> fuel = new LinkedHashMap();

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = GunStateHelper.getScopeStack(heldItem);
            Item patt3199$temp = scope.m_41720_();
            if (patt3199$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt3199$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Melee", (Tag)this.melee.serializeNBT());
        tag.m_128365_("Sounds", (Tag)NbtUtils.serializeStringMap(this.sounds));
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        tag.m_128365_("Textures", (Tag)NbtUtils.serializeStringMap(this.textures));
        tag.m_128365_("AmmoData", (Tag)NbtUtils.serializeMap(this.ammoData));
        tag.m_128365_("SecondaryAmmo", (Tag)NbtUtils.serializeMap(this.fuel));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Melee", 10)) {
            this.melee.deserializeNBT(tag.m_128469_("Melee"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds = this.deserializeSounds(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
        if (tag.m_128425_("Textures", 10)) {
            this.textures = NbtUtils.deserializeRLMap(tag.m_128469_("Textures"));
        }
        if (tag.m_128425_("AmmoData", 10)) {
            this.ammoData = NbtUtils.deserializeLinkedMap(tag.m_128469_("AmmoData"), nbt -> AmmoData.create(nbt));
        }
        if (tag.m_128425_("SecondaryAmmo", 10)) {
            this.fuel = NbtUtils.deserializeLinkedMap(tag.m_128469_("SecondaryAmmo"), nbt -> Fuel.create(nbt));
        }
    }

    public JsonObject toJsonObject() {
        Gson gson = new Gson();
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("melee", (JsonElement)this.melee.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "ammoData", gson.toJsonTree(this.ammoData).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", gson.toJsonTree(this.sounds).getAsJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "display", this.display.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        return object;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.melee = this.melee.copy();
        gun.sounds = (HashMap)this.sounds.clone();
        gun.textures = (HashMap)this.textures.clone();
        gun.ammoData = (LinkedHashMap)this.ammoData.clone();
        gun.fuel = (LinkedHashMap)this.fuel.clone();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public static Gun create(ResourceLocation id, CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        gun.prepareTextures(id.m_135815_());
        return gun;
    }

    public void onCreated(String id) {
        this.prepareTextures(id);
    }

    public General getGeneral() {
        return this.general;
    }

    public Melee getMelee() {
        return this.melee;
    }

    public Sounds getSounds() {
        return new Sounds(this);
    }

    public HashMap<String, ResourceLocation> getSoundsMap() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    public Map<String, ResourceLocation> getTextures() {
        return this.preparedTextures;
    }

    public boolean canAttachType(@Nullable AttachmentType type, Gun gun) {
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> attachments = gun.getModules().getAttachments();
        if (attachments == null) {
            return false;
        }
        return attachments.containsKey(type);
    }

    public boolean canAimDownSight() {
        return this.modules.zoom != null;
    }

    public ArrayList<Modules.Attachment> getAttachments(ArrayList<ItemStack> itemStacks) {
        ArrayList<Modules.Attachment> result = new ArrayList<Modules.Attachment>();
        for (ItemStack stack : itemStacks) {
            Item item = stack.m_41720_();
            Modules.Attachment attachment = this.findAttachment(item);
            if (attachment == null) continue;
            result.add(attachment);
        }
        return result;
    }

    public Modules.Attachment findAttachment(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (item instanceof IAttachment) {
            IAttachment attachmentItem = (IAttachment)item;
            AttachmentType attachmentType = attachmentItem.getType();
            if (!this.getModules().getAttachments().containsKey(attachmentType)) {
                return new Modules.Attachment();
            }
            ArrayList<Modules.Attachment> attachments = this.getModules().getAttachments().get(attachmentType);
            for (Modules.Attachment attachment : attachments) {
                if (attachment.getItemId() == null || !attachment.getItemId().equals((Object)itemId)) continue;
                return attachment;
            }
        }
        return new Modules.Attachment();
    }

    public void playCockSound(LivingEntity player) {
        if (!player.m_9236_().f_46443_) {
            ResourceLocation cockSound = this.getSounds().getCock();
            if (!player.m_6084_()) {
                return;
            }
            if (cockSound == null) {
                cockSound = ((SoundEvent)ModSounds.ITEM_PISTOL_COCK.get()).m_11660_();
            }
            Double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            S2CMessageGunSound messageSound = new S2CMessageGunSound(cockSound, SoundSource.PLAYERS, player, 1.0f, 1.0f, false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)(player.m_20186_() + 1.0), (double)player.m_20189_(), (double)radius), (IMessage)messageSound);
        }
    }

    public AmmoData getAmmoData(ResourceLocation ammo) {
        return this.ammoData.getOrDefault(ammo, new AmmoData());
    }

    public Fuel getFuelData(ResourceLocation ammo) {
        return this.fuel.getOrDefault(ammo, new Fuel());
    }

    public boolean hasAmmo(ResourceLocation ammo) {
        return this.ammoData.containsKey(ammo);
    }

    public ProjectileConfig getProjectileConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getProjectile();
    }

    public AmmoConfig getAmmoConfig(ResourceLocation ammo) {
        return this.getAmmoData(ammo).getAmmo();
    }

    public Fuel getFuelConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo);
    }

    public AmmoConfig getFuelAmmoConfig(ResourceLocation ammo) {
        return this.getFuelData(ammo).getAmmo();
    }

    private void prepareTextures(String itemId) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompletableFuture.runAsync(() -> this.textures.forEach((variant, path) -> {
                ResourceLocation texture = Gun.getTexture(itemId, path);
                this.preparedTextures.put((String)variant, texture);
            }));
        }
    }

    private static ResourceLocation getTexture(String itemId, ResourceLocation path) {
        return ResourceLocation.m_214293_((String)path.m_135827_(), (String)("textures/guns/" + itemId + "/" + path.m_135815_() + ".png"));
    }

    private HashMap<String, ResourceLocation> deserializeSounds(CompoundTag tag) {
        HashMap<String, ResourceLocation> result = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            result.put(key, this.createSound(tag, key));
        }
        return result;
    }

    private ResourceLocation createSound(CompoundTag tag, String key) {
        String sound = tag.m_128461_(key);
        return sound.isEmpty() ? null : ResourceLocation.m_135820_((String)sound);
    }

    public static class Builder {
        private final Gun gun;

        private Builder() {
            this.gun = new Gun();
        }

        private Builder(Gun gun) {
            this.gun = gun.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Gun gun) {
            return new Builder(gun);
        }

        public Gun build() {
            return this.gun.copy();
        }

        public Builder addAmmo(AmmoHolder id) {
            this.gun.general.ammo.add(id);
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setReloadType(ResourceLocation reloadType) {
            this.gun.general.reloadType = reloadType;
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.general.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.general.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setReloadTime(int reloadTime) {
            this.gun.general.reloadTime = reloadTime;
            return this;
        }

        public Builder setLoadingType(LoadingType loadingType) {
            this.gun.general.loadingType = loadingType;
            return this;
        }

        public Builder setCategory(String category) {
            this.gun.general.category = category;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilKick(float recoilKick) {
            this.gun.general.recoilKick = recoilKick;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setMuzzleFlash(double size, double xOffset, double yOffset, double zOffset) {
            Display.Flash flash = new Display.Flash();
            flash.size = size;
            flash.xOffset = xOffset;
            flash.yOffset = yOffset;
            flash.zOffset = zOffset;
            this.gun.display.flash = flash;
            return this;
        }

        public Builder setZoom(float fovModifier, double xOffset, double yOffset, double zOffset) {
            Modules.Zoom zoom = new Modules.Zoom();
            zoom.fovModifier = fovModifier;
            zoom.xOffset = xOffset;
            zoom.yOffset = yOffset;
            zoom.zOffset = zOffset;
            this.gun.modules.zoom = zoom;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder setZoom(Modules.Zoom.Builder builder) {
            this.gun.modules.zoom = builder.build();
            return this;
        }
    }
}

