/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.gun;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.common.data.config.gun.Positioned;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.debug.screen.widget.DebugButton;
import com.nukateam.ntgl.common.debug.screen.widget.DebugSlider;
import com.nukateam.ntgl.common.debug.screen.widget.DebugToggle;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Modules
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    private transient Zoom cachedZoom;
    @Optional
    @Nullable
    Zoom zoom;
    @Optional
    boolean attachmentScreen = true;
    @Optional
    private LinkedHashMap<AttachmentType, ArrayList<Attachment>> attachments = new LinkedHashMap();

    @Nullable
    public Zoom getZoom() {
        return this.zoom;
    }

    public boolean attachmentScreen() {
        return this.attachmentScreen;
    }

    public LinkedHashMap<AttachmentType, ArrayList<Attachment>> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public Attachment getAttachmentByBone(String name) {
        if (this.getAttachments() == null) {
            return null;
        }
        AtomicReference result = new AtomicReference();
        this.getAttachments().forEach((k, v) -> {
            java.util.Optional<Attachment> att = v.stream().filter(attachment -> attachment.name.equals(name)).findFirst();
            att.ifPresent(result::set);
        });
        return (Attachment)result.get();
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Modules");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Enabled Iron Sights"), () -> new DebugToggle(this.zoom != null, val -> {
                if (val.booleanValue()) {
                    if (this.cachedZoom != null) {
                        this.zoom = this.cachedZoom;
                    } else {
                        this.cachedZoom = this.zoom = new Zoom();
                    }
                } else {
                    this.cachedZoom = this.zoom;
                    this.zoom = null;
                }
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Adjust Iron Sights"), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> {
                if (btn.f_93623_ && this.zoom != null) {
                    Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.zoom));
                }
            }, () -> this.zoom != null)));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.zoom != null) {
            tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
        }
        tag.m_128379_("AttachmentScreen", this.attachmentScreen);
        if (this.attachments != null && !this.attachments.isEmpty()) {
            tag.m_128365_("Attachments", (Tag)NbtUtils.serializeArrayMap(this.attachments));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Zoom", 10)) {
            Zoom zoom = new Zoom();
            zoom.deserializeNBT(tag.m_128469_("Zoom"));
            this.zoom = zoom;
        }
        if (tag.m_128425_("AttachmentScreen", 1)) {
            this.attachmentScreen = tag.m_128471_("AttachmentScreen");
        }
        if (tag.m_128425_("Attachments", 10)) {
            CompoundTag nbt = tag.m_128469_("Attachments");
            this.attachments = NbtUtils.deserializeAttachmentMap(nbt);
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        if (this.zoom != null) {
            object.add("zoom", (JsonElement)this.zoom.toJsonObject());
        }
        object.addProperty("attachmentScreen", Boolean.valueOf(this.attachmentScreen));
        return object;
    }

    public Modules copy() {
        Modules modules = new Modules();
        modules.attachments = new LinkedHashMap<AttachmentType, ArrayList<Attachment>>(this.attachments);
        if (this.zoom != null) {
            modules.zoom = this.zoom.copy();
        }
        return modules;
    }

    public static class Zoom
    extends Positioned
    implements IEditorMenu {
        @Optional
        float fovModifier;

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128350_("FovModifier", this.fovModifier);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("FovModifier", 99)) {
                this.fovModifier = tag.m_128457_("FovModifier");
            }
        }

        @Override
        public JsonObject toJsonObject() {
            JsonObject object = super.toJsonObject();
            object.addProperty("fovModifier", (Number)Float.valueOf(this.fovModifier));
            return object;
        }

        @Override
        public Zoom copy() {
            Zoom zoom = new Zoom();
            zoom.fovModifier = this.fovModifier;
            zoom.xOffset = this.xOffset;
            zoom.yOffset = this.yOffset;
            zoom.zOffset = this.zOffset;
            return zoom;
        }

        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Zoom");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237113_((String)"FOV Modifier"), () -> new DebugSlider(0.0, 1.0, this.fovModifier, 0.01, 3, val -> {
                this.fovModifier = val.floatValue();
            }))));
        }

        public float getFovModifier() {
            return this.fovModifier;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends AbstractBuilder<Builder> {
        }

        protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
        extends Positioned.AbstractBuilder<T> {
            protected final Zoom zoom;

            protected AbstractBuilder() {
                this(new Zoom());
            }

            protected AbstractBuilder(Zoom zoom) {
                super(zoom);
                this.zoom = zoom;
            }

            public T setFovModifier(float fovModifier) {
                this.zoom.fovModifier = fovModifier;
                return (T)((AbstractBuilder)this.self());
            }

            @Override
            public Zoom build() {
                return this.zoom.copy();
            }
        }
    }

    public static class Attachment
    extends Positioned {
        @Optional
        @Nullable
        String name;
        @Optional
        @Nullable
        ResourceLocation item;
        @Optional
        ArrayList<String> hide = new ArrayList();
        @Optional
        ArrayList<String> bones = new ArrayList();

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public ResourceLocation getItemId() {
            return this.item;
        }

        public ArrayList<String> getHidden() {
            return this.hide;
        }

        public ArrayList<String> getBones() {
            return this.bones;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            if (this.name != null) {
                tag.m_128359_("Name", this.name);
            }
            if (this.item != null) {
                tag.m_128359_("Item", this.item.toString());
            }
            if (this.hide != null) {
                tag.m_128365_("Hide", (Tag)NbtUtils.serializeStringArray(this.hide));
            }
            if (this.bones != null) {
                tag.m_128365_("Bones", (Tag)NbtUtils.serializeStringArray(this.bones));
            }
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Name", 8)) {
                this.name = tag.m_128461_("Name");
            }
            if (tag.m_128425_("Item", 8)) {
                this.item = ResourceLocation.m_135820_((String)tag.m_128461_("Item"));
            }
            if (tag.m_128425_("Hide", 10)) {
                this.hide = NbtUtils.deserializeStringArray(tag.m_128469_("Hide"));
            }
            if (tag.m_128425_("Bones", 10)) {
                this.bones = NbtUtils.deserializeStringArray(tag.m_128469_("Bones"));
            }
        }

        @Override
        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.name != null) {
                object.addProperty("Name", this.name);
            }
            if (this.item != null) {
                object.addProperty("Item", this.item.toString());
            }
            return object;
        }

        @Override
        public Attachment copy() {
            Attachment attachments = new Attachment();
            if (this.name != null) {
                attachments.name = this.name;
            }
            if (this.item != null) {
                attachments.item = this.item;
            }
            if (this.hide != null) {
                attachments.hide = this.hide;
            }
            if (this.bones != null) {
                attachments.bones = this.bones;
            }
            return attachments;
        }
    }
}

