/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.container.slot;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.foundation.container.AttachmentContainer;
import com.nukateam.ntgl.common.foundation.init.ModSounds;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AttachmentSlot
extends Slot {
    private AttachmentContainer container;
    private ItemStack weapon;
    private AttachmentType type;
    private Player player;

    public AttachmentSlot(AttachmentContainer container, Container weaponInventory, ItemStack weapon, AttachmentType type, Player player, int index, int x, int y) {
        super(weaponInventory, index, x, y);
        this.container = container;
        this.weapon = weapon;
        this.type = type;
        this.player = player;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public boolean m_6659_() {
        if (!(this.weapon.m_41720_() instanceof WeaponItem)) {
            return false;
        }
        Gun gun = GunModifierHelper.getGun(this.weapon);
        WeaponItem item = (WeaponItem)this.weapon.m_41720_();
        Gun modifiedGun = item.getModifiedGun(this.weapon);
        return modifiedGun.canAttachType(this.type, gun);
    }

    public boolean m_5857_(ItemStack stack) {
        Item item = this.weapon.m_41720_();
        if (!(item instanceof WeaponItem)) {
            return false;
        }
        WeaponItem item2 = (WeaponItem)item;
        Gun modifiedGun = item2.getModifiedGun(this.weapon);
        Item item3 = stack.m_41720_();
        if (item3 instanceof IAttachment) {
            IAttachment attachment = (IAttachment)item3;
            ArrayList<Modules.Attachment> attachments = modifiedGun.getModules().getAttachments().get(attachment.getType());
            if (attachments == null) {
                return false;
            }
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            boolean canAttachType = modifiedGun.canAttachType(this.type, modifiedGun);
            boolean isRightType = attachment.getType().equals(this.type);
            boolean canAttach = attachment.canAttachTo(this.weapon);
            boolean isItemAllowed = false;
            for (Modules.Attachment att : attachments) {
                if (!att.getItemId().equals((Object)id)) continue;
                isItemAllowed = true;
                break;
            }
            return isRightType && canAttachType && canAttach && isItemAllowed;
        }
        return false;
    }

    public void m_5852_(ItemStack stack) {
        super.m_5852_(stack);
        AttachmentSlot.checkAmmoCount(this.weapon, (LivingEntity)this.player);
    }

    public static void checkAmmoCount(ItemStack stack, LivingEntity entity) {
        GunData gunData = new GunData(stack, entity);
        int maxAmmo = GunModifierHelper.getMaxAmmo(gunData);
        int ammoCount = GunStateHelper.getAmmoCount(gunData);
        int diff = ammoCount - maxAmmo;
        if (diff > 0) {
            GunStateHelper.setAmmo(stack, maxAmmo);
            AmmoHolder ammoHolder = GunStateHelper.getCurrentAmmo(gunData);
            if (ammoHolder.canReturnAmmo()) {
                Player player;
                Item ammoItem = (Item)ForgeRegistries.ITEMS.getValue(ammoHolder.getId());
                ItemStack dropStack = new ItemStack((ItemLike)ammoItem, diff);
                if (entity instanceof Player && !(player = (Player)entity).m_36356_(dropStack)) {
                    player.m_36176_(dropStack, false);
                }
            }
        }
    }

    public void m_6654_() {
        if (this.container.isLoaded()) {
            this.player.m_9236_().m_6263_(null, this.player.m_20185_(), this.player.m_20186_() + 1.0, this.player.m_20189_(), (SoundEvent)ModSounds.UI_WEAPON_ATTACH.get(), SoundSource.PLAYERS, 0.5f, this.m_6657_() ? 1.0f : 0.75f);
        }
    }

    public int m_6641_() {
        return 1;
    }

    public boolean m_8010_(Player player) {
        ItemStack itemstack = this.m_7993_();
        return (itemstack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(player);
    }
}

