/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.handlers;

import com.mojang.datafixers.util.Pair;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ntgl", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEventHandler {
    public static final UUID SPEED_MODIFIER_ID = UUID.fromString("a1b2c3d4-5e6f-7890-1234-567890abcdef");
    public static final String MOVEMENT_SPEED = "custom_movement_speed";
    private static final Map<Pair<InteractionHand, Player>, Slot> lastSelectedSlots = new HashMap<Pair<InteractionHand, Player>, Slot>();
    public static final String ID = "WeaponId";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            ItemStack heldItem = player.m_21205_();
            AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
            if (movementSpeed != null) {
                movementSpeed.m_22120_(SPEED_MODIFIER_ID);
                if (heldItem.m_41720_() instanceof WeaponItem) {
                    movementSpeed.m_22120_(SPEED_MODIFIER_ID);
                    movementSpeed.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, MOVEMENT_SPEED, (double)GunModifierHelper.getModifiedMovementSpeed(new GunData(heldItem, (LivingEntity)player)), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChangeEquipment(LivingEquipmentChangeEvent event) {
        ItemStack oldItem = event.getFrom();
        ItemStack newItem = event.getTo();
        boolean isGun = newItem.m_41720_() instanceof IWeapon;
        boolean isThrowable = newItem.m_41720_() instanceof IThrowable;
        if (event.getSlot() == EquipmentSlot.MAINHAND || event.getSlot() == EquipmentSlot.OFFHAND) {
            InteractionHand hand = PlayerEventHandler.getHand(event.getSlot());
            if (isGun || isThrowable) {
                if (!ItemStack.m_41728_((ItemStack)oldItem, (ItemStack)newItem) || newItem.m_41613_() < oldItem.m_41613_()) {
                    int equipTime = 0;
                    if (newItem.m_41720_() instanceof IWeapon) {
                        GunData data = new GunData(newItem, event.getEntity());
                        equipTime = GunModifierHelper.getEquipTime(data);
                    } else {
                        Item item = newItem.m_41720_();
                        if (item instanceof IThrowable) {
                            IThrowable throwable = (IThrowable)item;
                            equipTime = throwable.getConfig().getGeneral().getEquipTime();
                        }
                    }
                    EquipTracker.stopEquip(event.getEntity(), hand);
                    EquipTracker.startEquip(event.getEntity(), hand, equipTime);
                }
            } else {
                EquipTracker.stopEquip(event.getEntity(), hand);
            }
        }
    }

    @NotNull
    private static InteractionHand getHand(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    private static String getId(ItemStack stack) {
        CompoundTag lastItemTag = stack.m_41784_();
        return lastItemTag.m_128425_(ID, 8) ? lastItemTag.m_128461_(ID) : UUID.randomUUID().toString();
    }

    record Slot(ItemStack stack, int stackSize, int slotId) {
    }
}

