/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.regestry;

import com.nukateam.example.common.registery.ModGuns;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.foundation.entity.ContinuousLaserProjectile;
import com.nukateam.ntgl.common.foundation.entity.FlameProjectile;
import com.nukateam.ntgl.common.foundation.entity.GrenadeEntity;
import com.nukateam.ntgl.common.foundation.entity.LaserProjectile;
import com.nukateam.ntgl.common.foundation.entity.MissileEntity;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.entity.StunGrenadeEntity;
import com.nukateam.ntgl.common.foundation.entity.TeslaProjectile;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableGrenadeEntity;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.util.interfaces.IProjectileFactory;
import com.nukateam.ntgl.common.util.interfaces.IThrowableProjectileFactory;
import com.nukateam.ntgl.common.util.managers.ProjectileManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ProjectileRegistry {
    private static final IProjectileFactory DEFAULT = (level, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)Projectiles.PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory GRENADE = (level, entity, weapon, item, modifiedGun) -> new GrenadeEntity((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.GRENADE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory MISSILE = (level, entity, weapon, item, modifiedGun) -> new MissileEntity((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.MISSILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory LASER = (level, entity, weapon, item, modifiedGun) -> new LaserProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.LASER_PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory TESLA = (level, entity, weapon, item, modifiedGun) -> new TeslaProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.TESLA_PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory FIRE = (level, entity, weapon, item, modifiedGun) -> new FlameProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.FLAME_PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IProjectileFactory CONTINUOUS_LASER = (level, entity, weapon, item, modifiedGun) -> new ContinuousLaserProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.CONTINUOUS_LASER_PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    private static final IThrowableProjectileFactory THROWABLE_GRENADE = ThrowableGrenadeEntity::new;
    private static final IThrowableProjectileFactory THROWABLE_STUN_GRENADE = StunGrenadeEntity::new;

    public static void registerProjectiles() {
        ProjectileManager.getInstance().registerFactory(ProjectileType.BULLET, DEFAULT);
        ProjectileManager.getInstance().registerFactory(ProjectileType.GRENADE, GRENADE);
        ProjectileManager.getInstance().registerFactory(ProjectileType.MISSILE, MISSILE);
        ProjectileManager.getInstance().registerFactory(ProjectileType.LASER, LASER);
        ProjectileManager.getInstance().registerFactory(ProjectileType.TESLA, TESLA);
        ProjectileManager.getInstance().registerFactory(ProjectileType.FIRE, FIRE);
        ProjectileManager.getInstance().registerFactory(ProjectileType.CONTINUOUS_LASER, CONTINUOUS_LASER);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.GRENADE.get(), GRENADE);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.ROUND10MM.get(), LASER);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.ROUND5MM.get(), LASER);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.ROUND45.get(), TESLA);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.ROUND38.get(), CONTINUOUS_LASER);
        ProjectileManager.getInstance().registerFactory((Item)ModGuns.FUEL.get(), FIRE);
        ProjectileManager.getInstance().registerFactory(ProjectileType.GRENADE, THROWABLE_GRENADE);
        ProjectileManager.getInstance().registerFactory(ProjectileType.STUN_GRENADE, THROWABLE_STUN_GRENADE);
    }

    @NotNull
    private static IProjectileFactory registerDefault() {
        return (level, entity, weapon, item, modifiedGun) -> new FlameProjectile((EntityType<? extends ProjectileEntity>)((EntityType)Projectiles.FLAME_PROJECTILE.get()), level, entity, weapon, item, modifiedGun);
    }
}

