/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.trackers;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class EquipTracker {
    private static final Map<Pair<InteractionHand, LivingEntity>, Tracker> TRACKER_MAP = new WeakHashMap<Pair<InteractionHand, LivingEntity>, Tracker>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                EquipTracker.handTick(player, InteractionHand.MAIN_HAND);
                EquipTracker.handTick(player, InteractionHand.OFF_HAND);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(event.getEntity()));
        }
    }

    private static void handTick(Player entity, InteractionHand arm) {
        Pair key = new Pair((Object)arm, (Object)entity);
        Tracker tracker = TRACKER_MAP.get(key);
        if (tracker != null) {
            if (tracker.equipTick > 0 && tracker.isSameItem()) {
                --tracker.equipTick;
            } else {
                EquipTracker.stopEquip((LivingEntity)entity, arm);
            }
        } else {
            EquipTracker.stopEquip((LivingEntity)entity, arm);
        }
    }

    public static boolean isEquiping(LivingEntity entity, InteractionHand arm) {
        return (Boolean)ModSyncedDataKeys.getEquipKey(arm).getValue((Entity)entity);
    }

    public static void startEquip(LivingEntity entity, InteractionHand arm, int equipTime) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getEquipKey(arm);
        reloadKey.setValue((Entity)entity, (Object)true);
        EquipTracker.addTracker(entity, arm, equipTime);
    }

    public static void stopEquip(LivingEntity entity, InteractionHand arm) {
        SyncedDataKey<LivingEntity, Boolean> dataKey = ModSyncedDataKeys.getEquipKey(arm);
        dataKey.setValue((Entity)entity, (Object)false);
        TRACKER_MAP.remove(new Pair((Object)arm, (Object)entity));
    }

    private static void addTracker(LivingEntity entity, InteractionHand arm, int equipTime) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ModSyncedDataKeys.getEquipKey(arm);
        Item heldItem = entity.m_21120_(arm).m_41720_();
        Pair key = new Pair((Object)arm, (Object)entity);
        if (!TRACKER_MAP.containsKey(key)) {
            if (!(heldItem instanceof IWeapon) && !(heldItem instanceof IThrowable)) {
                reloadKey.setValue((Entity)entity, (Object)false);
                return;
            }
            TRACKER_MAP.put((Pair<InteractionHand, LivingEntity>)key, new Tracker(entity, arm, equipTime));
        }
    }

    private static class Tracker {
        private final InteractionHand arm;
        private final ItemStack stack;
        private final LivingEntity entity;
        private int equipTick;

        private Tracker(LivingEntity entity, InteractionHand arm, int equipTime) {
            this.arm = arm;
            this.stack = entity.m_21120_(arm);
            this.entity = entity;
            this.equipTick = equipTime;
        }

        private boolean isSameItem() {
            ItemStack heldItem = this.entity.m_21120_(this.arm);
            return !this.stack.m_41619_() && heldItem == this.stack;
        }
    }
}

