/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.mixin.client;

import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class LivingEntityModelMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim*"}, at={@At(value="TAIL")})
    private void setupAnimTail(T entity, float animationPos, float animationSpeed, float animationBob, float deltaHeadYaw, float headPitch, CallbackInfo ci) {
        HumanoidModel model = (HumanoidModel)this;
        this.setupForArm(entity, animationPos, model, InteractionHand.MAIN_HAND);
        this.setupForArm(entity, animationPos, model, InteractionHand.OFF_HAND);
    }

    @Unique
    private void setupForArm(T entity, float animationPos, HumanoidModel<T> model, InteractionHand interactionHand) {
        ItemStack heldItem = entity.m_21120_(interactionHand);
        if (heldItem.m_41720_() instanceof WeaponItem) {
            if (animationPos == 0.0f) {
                model.f_102811_.f_104203_ = 0.0f;
                model.f_102811_.f_104204_ = 0.0f;
                model.f_102811_.f_104205_ = 0.0f;
                model.f_102812_.f_104203_ = 0.0f;
                model.f_102812_.f_104204_ = 0.0f;
                model.f_102812_.f_104205_ = 0.0f;
                if (model instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)model;
                    LivingEntityModelMixin.copyModelAngles(playerModel.f_102811_, playerModel.f_103375_);
                    LivingEntityModelMixin.copyModelAngles(playerModel.f_102812_, playerModel.f_103374_);
                }
                return;
            }
            GunModifierHelper.getGripType(new GunData(heldItem, (LivingEntity)entity)).getHeldAnimation().applyHumanoidModelRotation((LivingEntity)entity, model.f_102811_, model.f_102812_, model.f_102808_, interactionHand, AimingHandler.get().getAimProgress((LivingEntity)entity, Minecraft.m_91087_().m_91296_()));
            if (model instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)model;
                LivingEntityModelMixin.copyModelAngles(playerModel.f_102811_, playerModel.f_103375_);
                LivingEntityModelMixin.copyModelAngles(playerModel.f_102812_, playerModel.f_103374_);
            }
            LivingEntityModelMixin.copyModelAngles(model.f_102808_, model.f_102809_);
        }
    }

    private static void copyModelAngles(ModelPart source, ModelPart target) {
        target.f_104203_ = source.f_104203_;
        target.f_104204_ = source.f_104204_;
        target.f_104205_ = source.f_104205_;
    }
}

