/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.nukateam.ntgl.common.data.config.ProjectileConfig;
import com.nukateam.ntgl.common.foundation.item.interfaces.IAmmo;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAmmo;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import com.nukateam.ntgl.modules.datapack.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class NetworkAmmoManager
extends SimplePreparableReloadListener<Map<IAmmo, ProjectileConfig>> {
    public static final String PATH = "ammo";
    private static final List<IAmmo> clientRegisteredAmmo = new ArrayList<IAmmo>();
    private static NetworkAmmoManager instance;
    private Map<ResourceLocation, ProjectileConfig> registeredAmmo = new HashMap<ResourceLocation, ProjectileConfig>();

    public static void register(AddReloadListenerEvent event) {
        NetworkAmmoManager networkGunManager = new NetworkAmmoManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    public static void onServerStopped() {
        instance = null;
    }

    protected Map<IAmmo, ProjectileConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return DataUtils.getConfigMap(manager, v -> v instanceof IAmmo, ProjectileConfig.class, PATH);
    }

    protected void apply(Map<IAmmo, ProjectileConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, ammo) -> {
            Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)));
            builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)item)), ammo);
            item.setConfig(new ConfigSupplier<ProjectileConfig>((ProjectileConfig)ammo));
        });
        this.registeredAmmo = builder.build();
    }

    public void writeRegisteredAmmo(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredAmmo.size());
        this.registeredAmmo.forEach((id, ammo) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(ammo.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, ProjectileConfig> readRegisteredAmmo(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                ProjectileConfig ammo = ProjectileConfig.create(buffer.m_130260_());
                builder.put((Object)id, (Object)ammo);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredAmmo(S2CMessageUpdateAmmo message) {
        return NetworkAmmoManager.updateRegisteredAmmo(message.getRegisteredAmmo());
    }

    private static boolean updateRegisteredAmmo(Map<ResourceLocation, ProjectileConfig> registeredAmmo) {
        clientRegisteredAmmo.clear();
        if (registeredAmmo != null) {
            for (Map.Entry<ResourceLocation, ProjectileConfig> entry : registeredAmmo.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof IAmmo)) {
                    return false;
                }
                ((IAmmo)item).setConfig(new ConfigSupplier<ProjectileConfig>(entry.getValue()));
                clientRegisteredAmmo.add((IAmmo)item);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static NetworkAmmoManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkAmmoManager.get()));
            NetworkAmmoManager.get().writeRegisteredAmmo(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, ProjectileConfig> registeredAmmo = NetworkAmmoManager.readRegisteredAmmo(buffer);
            NetworkAmmoManager.updateRegisteredAmmo(registeredAmmo);
            return Optional.empty();
        }
    }

    public static class Supplier {
        private ProjectileConfig projectile;

        private Supplier(ProjectileConfig projectile) {
            this.projectile = projectile;
        }

        public ProjectileConfig getAmmo() {
            return this.projectile;
        }
    }
}

