/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.attachment.AttachmentConfig;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAttachments;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import com.nukateam.ntgl.modules.datapack.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class NetworkAttachmentManager
extends SimplePreparableReloadListener<Map<IAttachment<?>, AttachmentConfig>> {
    public static final String PATH = "attachments";
    private static List<IAttachment<?>> clientRegisteredAttachments = new ArrayList();
    private static NetworkAttachmentManager instance;
    private Map<ResourceLocation, AttachmentConfig> registeredAttachments = new HashMap<ResourceLocation, AttachmentConfig>();

    public static void onServerStopped() {
        instance = null;
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkAttachmentManager networkManager = new NetworkAttachmentManager();
        event.addListener((PreparableReloadListener)networkManager);
        instance = networkManager;
    }

    protected Map<IAttachment<?>, AttachmentConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return DataUtils.getConfigMap(manager, v -> v instanceof IAttachment, AttachmentConfig.class, PATH);
    }

    protected void apply(Map<IAttachment<?>, AttachmentConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((abstractItem, config) -> {
            if (abstractItem instanceof Item) {
                Item item = (Item)abstractItem;
                Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)item));
                builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)item), config);
                abstractItem.setConfig(new ConfigSupplier<AttachmentConfig>((AttachmentConfig)config));
            }
        });
        this.registeredAttachments = builder.build();
    }

    public void writeRegistered(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredAttachments.size());
        this.registeredAttachments.forEach((id, config) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(config.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, AttachmentConfig> readRegistered(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                AttachmentConfig config = AttachmentConfig.create(id, buffer.m_130260_());
                builder.put((Object)id, (Object)config);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredAttachments(S2CMessageUpdateAttachments message) {
        return NetworkAttachmentManager.updateRegisteredAttachments(message.getRegistered());
    }

    private static boolean updateRegisteredAttachments(Map<ResourceLocation, AttachmentConfig> registered) {
        clientRegisteredAttachments.clear();
        if (registered != null) {
            for (Map.Entry<ResourceLocation, AttachmentConfig> entry : registered.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof IAttachment)) {
                    return false;
                }
                ((IAttachment)item).setConfig(new ConfigSupplier<AttachmentConfig>(entry.getValue()));
                clientRegisteredAttachments.add((IAttachment)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, AttachmentConfig> getRegisteredAttachments() {
        return this.registeredAttachments;
    }

    public static List<IAttachment<?>> getClientRegisteredAttachments() {
        return ImmutableList.copyOf(clientRegisteredAttachments);
    }

    @Nullable
    public static NetworkAttachmentManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkAttachmentManager.get()));
            NetworkAttachmentManager.get().writeRegistered(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, AttachmentConfig> registered = NetworkAttachmentManager.readRegistered(buffer);
            NetworkAttachmentManager.updateRegisteredAttachments(registered);
            return Optional.empty();
        }
    }

    public static class Supplier {
        private final AttachmentConfig config;

        private Supplier(AttachmentConfig config) {
            this.config = config;
        }

        public AttachmentConfig getConfig() {
            return this.config;
        }
    }
}

