/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.nukateam.ntgl.common.data.config.ThrowableConfig;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateThrowable;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import com.nukateam.ntgl.modules.datapack.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class NetworkGrenadeManager
extends SimplePreparableReloadListener<Map<IThrowable, ThrowableConfig>> {
    public static final String PATH = "throwable";
    private static final List<IThrowable> clientRegisteredAttachments = new ArrayList<IThrowable>();
    private static NetworkGrenadeManager instance;
    private Map<ResourceLocation, ThrowableConfig> registeredAttachments = new HashMap<ResourceLocation, ThrowableConfig>();

    public static void onServerStopped() {
        instance = null;
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkGrenadeManager networkManager = new NetworkGrenadeManager();
        event.addListener((PreparableReloadListener)networkManager);
        instance = networkManager;
    }

    protected Map<IThrowable, ThrowableConfig> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return DataUtils.getConfigMap(manager, v -> v instanceof IThrowable, ThrowableConfig.class, PATH);
    }

    protected void apply(Map<IThrowable, ThrowableConfig> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((abstractItem, config) -> {
            if (abstractItem instanceof Item) {
                Item item = (Item)abstractItem;
                Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)item));
                builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)item), config);
                abstractItem.setConfig(new ConfigSupplier<ThrowableConfig>((ThrowableConfig)config));
            }
        });
        this.registeredAttachments = builder.build();
    }

    public void writeRegistered(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredAttachments.size());
        this.registeredAttachments.forEach((id, config) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(config.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, ThrowableConfig> readRegistered(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                ThrowableConfig config = ThrowableConfig.create(id, buffer.m_130260_());
                builder.put((Object)id, (Object)config);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredConfigs(S2CMessageUpdateThrowable message) {
        return NetworkGrenadeManager.updateRegisteredConfigs(message.getRegistered());
    }

    private static boolean updateRegisteredConfigs(Map<ResourceLocation, ThrowableConfig> registered) {
        clientRegisteredAttachments.clear();
        if (registered != null) {
            for (Map.Entry<ResourceLocation, ThrowableConfig> entry : registered.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof IThrowable)) {
                    return false;
                }
                ((IThrowable)item).setConfig(new ConfigSupplier<ThrowableConfig>(entry.getValue()));
                clientRegisteredAttachments.add((IThrowable)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, ThrowableConfig> getRegisteredAttachments() {
        return this.registeredAttachments;
    }

    public static List<IThrowable> getClientRegisteredAttachments() {
        return ImmutableList.copyOf(clientRegisteredAttachments);
    }

    @Nullable
    public static NetworkGrenadeManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkGrenadeManager.get()));
            NetworkGrenadeManager.get().writeRegistered(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, ThrowableConfig> registered = NetworkGrenadeManager.readRegistered(buffer);
            NetworkGrenadeManager.updateRegisteredConfigs(registered);
            return Optional.empty();
        }
    }

    public static class Supplier {
        private final ThrowableConfig config;

        private Supplier(ThrowableConfig config) {
            this.config = config;
        }

        public ThrowableConfig getConfig() {
            return this.config;
        }
    }
}

