/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.datapack.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateGuns;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import com.nukateam.ntgl.modules.datapack.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public class NetworkGunManager
extends SimplePreparableReloadListener<Map<WeaponItem, Gun>> {
    private static final List<WeaponItem> clientRegisteredGuns = new ArrayList<WeaponItem>();
    private static NetworkGunManager instance;
    private Map<ResourceLocation, Gun> registeredGuns = new HashMap<ResourceLocation, Gun>();

    public static void onServerStopped() {
        instance = null;
    }

    public static void register(AddReloadListenerEvent event) {
        NetworkGunManager networkGunManager = new NetworkGunManager();
        event.addListener((PreparableReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    protected Map<WeaponItem, Gun> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return DataUtils.getConfigMap(manager, v -> v instanceof WeaponItem, Gun.class, "guns");
    }

    protected void apply(Map<WeaponItem, Gun> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, gun) -> {
            Validate.notNull((Object)ForgeRegistries.ITEMS.getKey(item));
            builder.put((Object)ForgeRegistries.ITEMS.getKey(item), gun);
            item.setConfig(new ConfigSupplier<Gun>((Gun)gun));
        });
        this.registeredGuns = builder.build();
    }

    public void writeRegisteredGuns(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.registeredGuns.size());
        this.registeredGuns.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Gun> readRegisteredGuns(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                Gun gun = Gun.create(id, buffer.m_130260_());
                builder.put((Object)id, (Object)gun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    public static boolean updateRegisteredGuns(S2CMessageUpdateGuns message) {
        return NetworkGunManager.updateRegisteredGuns(message.getRegisteredGuns());
    }

    private static boolean updateRegisteredGuns(Map<ResourceLocation, Gun> registeredGuns) {
        clientRegisteredGuns.clear();
        if (registeredGuns != null) {
            for (Map.Entry<ResourceLocation, Gun> entry : registeredGuns.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
                if (!(item instanceof WeaponItem)) {
                    return false;
                }
                ((WeaponItem)item).setConfig(new ConfigSupplier<Gun>(entry.getValue()));
                clientRegisteredGuns.add((WeaponItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public static List<WeaponItem> getClientRegisteredGuns() {
        return ImmutableList.copyOf(clientRegisteredGuns);
    }

    @Nullable
    public static NetworkGunManager get() {
        return instance;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, Gun> registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            NetworkGunManager.updateRegisteredGuns(registeredGuns);
            return Optional.empty();
        }
    }
}

