/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.regions_unexplored.data.worldgen.features.RuAquaticFeatures;
import net.regions_unexplored.data.worldgen.features.RuVegetationFeatures;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

public class RuAquaticPlacements {
    public static final ResourceKey<PlacedFeature> CATTAIL_FEN = PlacedFeatureRegistry.createKey("cattail_fen");
    public static final ResourceKey<PlacedFeature> CATTAIL_RIVER = PlacedFeatureRegistry.createKey("cattail_river");
    public static final ResourceKey<PlacedFeature> TALL_HYACINTH_STOCK = PlacedFeatureRegistry.createKey("tall_hyacinth_stock");
    public static final ResourceKey<PlacedFeature> HYACINTH_PLANTS = PlacedFeatureRegistry.createKey("hyacinth_plants");
    public static final ResourceKey<PlacedFeature> HYACINTH_FLOWERS = PlacedFeatureRegistry.createKey("hyacinth_flowers");
    public static final ResourceKey<PlacedFeature> HYACINTH_ROCKS = PlacedFeatureRegistry.createKey("hyacinth_rocks");
    public static final ResourceKey<PlacedFeature> MOSSY_SEA_ROCKS = PlacedFeatureRegistry.createKey("mossy_sea_rocks");
    public static final ResourceKey<PlacedFeature> BLUE_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("red_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> PINK_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("pink_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> WHITE_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("white_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> JUNGLE_TREE_AQUATIC = PlacedFeatureRegistry.createKey("jungle_tree_aquatic");
    public static final ResourceKey<PlacedFeature> PALM_TREE_AQUATIC = PlacedFeatureRegistry.createKey("palm_tree_aquatic");
    public static final ResourceKey<PlacedFeature> ELEPHANT_EAR_AQUATIC = PlacedFeatureRegistry.createKey("elephant_ear_aquatic");
    public static final ResourceKey<PlacedFeature> PALM_SAPLING_AQUATIC = PlacedFeatureRegistry.createKey("palm_sapling_aquatic");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter featureGetter = context.m_255420_(Registries.f_256911_);
        Holder.Reference FEN_CATTAIL = featureGetter.m_255043_(RuAquaticFeatures.FEN_CATTAIL);
        Holder.Reference WATER_CATTAIL = featureGetter.m_255043_(RuAquaticFeatures.WATER_CATTAIL);
        Holder.Reference TALL_HYACINTH_STOCK = featureGetter.m_255043_(RuAquaticFeatures.TALL_HYACINTH_STOCK);
        Holder.Reference HYACINTH_PLANTS = featureGetter.m_255043_(RuAquaticFeatures.HYACINTH_PLANTS);
        Holder.Reference HYACINTH_FLOWERS = featureGetter.m_255043_(RuAquaticFeatures.HYACINTH_FLOWERS);
        Holder.Reference HYACINTH_ROCKS = featureGetter.m_255043_(RuAquaticFeatures.HYACINTH_ROCKS);
        Holder.Reference MOSSY_SEA_ROCKS = featureGetter.m_255043_(RuAquaticFeatures.MOSSY_SEA_ROCKS);
        Holder.Reference BLUE_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.BLUE_MAGNOLIA_FLOWERS_AQUATIC);
        Holder.Reference PINK_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.PINK_MAGNOLIA_FLOWERS_AQUATIC);
        Holder.Reference WHITE_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.WHITE_MAGNOLIA_FLOWERS_AQUATIC);
        Holder.Reference JUNGLE_TREE_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.JUNGLE_TREE_AQUATIC);
        Holder.Reference PALM_TREE_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.PALM_TREE_AQUATIC);
        Holder.Reference ELEPHANT_EAR_AQUATIC = featureGetter.m_255043_(RuAquaticFeatures.ELEPHANT_EAR_AQUATIC);
        Holder.Reference PALM_SAPLING_AQUATIC = featureGetter.m_255043_(RuVegetationFeatures.PALM_SHRUB);
        RuAquaticPlacements.register(context, CATTAIL_FEN, FEN_CATTAIL, List.of(NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)24), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)3), PlacementUtils.f_195355_, BiomeFilter.m_191561_()));
        RuAquaticPlacements.register(context, CATTAIL_RIVER, WATER_CATTAIL, List.of(NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)6), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)3), PlacementUtils.f_195355_, BiomeFilter.m_191561_()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.TALL_HYACINTH_STOCK, TALL_HYACINTH_STOCK, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)20, (double)80.0, (double)0.3), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_PLANTS, HYACINTH_PLANTS, RuAquaticPlacements.seagrassPlacement(80));
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_FLOWERS, HYACINTH_FLOWERS, new PlacementModifier[]{CountPlacement.m_191628_((int)15), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_ROCKS, HYACINTH_ROCKS, new PlacementModifier[]{CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.MOSSY_SEA_ROCKS, MOSSY_SEA_ROCKS, new PlacementModifier[]{NoiseBasedCountPlacement.m_191731_((int)1, (double)80.0, (double)0.3), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.BLUE_MAGNOLIA_FLOWERS_AQUATIC, BLUE_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.m_191628_((int)35), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.PINK_MAGNOLIA_FLOWERS_AQUATIC, PINK_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.m_191628_((int)35), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.WHITE_MAGNOLIA_FLOWERS_AQUATIC, WHITE_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.m_191628_((int)35), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.JUNGLE_TREE_AQUATIC, JUNGLE_TREE_AQUATIC, List.of(CountPlacement.m_191628_((int)24), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)Blocks.f_50746_), BiomeFilter.m_191561_()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.PALM_TREE_AQUATIC, PALM_TREE_AQUATIC, List.of(CountPlacement.m_191628_((int)15), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)Blocks.f_50746_), BiomeFilter.m_191561_()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.PALM_SAPLING_AQUATIC, PALM_SAPLING_AQUATIC, List.of(CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)Blocks.f_50746_), BiomeFilter.m_191561_()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.ELEPHANT_EAR_AQUATIC, ELEPHANT_EAR_AQUATIC, List.of(CountPlacement.m_191628_((int)8), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, PlacementUtils.m_206493_((Block)Blocks.f_50746_), BiomeFilter.m_191561_()));
    }

    private static List<PlacementModifier> seagrassPlacement(int count) {
        return List.of(InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, CountPlacement.m_191628_((int)count), BiomeFilter.m_191561_());
    }

    protected static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placement) {
        RuAquaticPlacements.register(context, key, feature, List.of(placement));
    }

    protected static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placement) {
        context.m_255272_(key, (Object)new PlacedFeature(feature, placement));
    }
}

