/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class BambooTreeFeature
extends Feature<RuTreeConfiguration> {
    public BambooTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck == height_main) {
                this.placeLeavesBlob((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_PODZOL.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_PODZOL.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50599_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50599_.m_49966_(), 2);
        } else if (BambooTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, treeConfiguration.trunkProvider.m_213972_(randomSource, pos), 2);
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_PODZOL.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_PODZOL.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50599_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50599_.m_49966_(), 2);
        }
    }

    public void placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos pos1 = pos.m_6625_(3).m_122032_();
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122012_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122012_().m_122024_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122019_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122019_().m_122024_(), randomSource, treeConfiguration);
        }
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122024_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_().m_122024_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122012_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122012_().m_122024_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122019_().m_122029_(), randomSource, treeConfiguration);
        }
        if (randomSource.m_188503_(3) == 0) {
            this.placeLeavesBlock(level, pos1.m_122019_().m_122024_(), randomSource, treeConfiguration);
        }
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_122024_(), randomSource, treeConfiguration);
        pos1.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.m_7494_(), randomSource, treeConfiguration);
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return BambooTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, BambooTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, BambooTreeFeature::isReplaceableBlock);
    }
}

