/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.client.render.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import modularforcefields.client.MFFSClientRegister;
import modularforcefields.common.tile.TileFortronFieldProjector;
import modularforcefields.common.tile.projection.ProjectionType;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderFieldProjector
extends AbstractTileRenderer<TileFortronFieldProjector> {
    public RenderFieldProjector(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileFortronFieldProjector tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float base;
        double ticks = ((ComponentTickable)tile.getComponent(IComponentType.Tickable)).getTicks();
        float rotX = base = (float)((ticks + (double)partialTicks) * 1.0 % 360.0);
        float rotY = base;
        float rotZ = base;
        DyeColor dyeColor = tile.getFieldColor();
        Color color = new Color(dyeColor.m_41070_());
        BakedModel ibakedmodel = null;
        if ((Integer)tile.fortron.getValue() > 0) {
            BakedModel shape = Minecraft.m_91087_().m_91304_().getModel(MFFSClientRegister.MODEL_FIELDFORTRON);
            if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FABULOUS) {
                RenderSystem.setShaderColor((float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.5, 0.5);
                RenderingUtils.renderModel((BakedModel)shape, (BlockEntity)tile, (RenderType)RenderType.m_110466_(), (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
            } else {
                poseStack.m_85836_();
            }
            for (BakedQuad quad : shape.m_213637_(null, null, tile.m_58904_().f_46441_)) {
                bufferIn.m_6299_(RenderType.m_110466_()).putBulkData(poseStack.m_85850_(), quad, color.rFloat(), color.gFloat(), color.bFloat(), 1.0f, combinedLightIn, combinedOverlayIn, true);
            }
            poseStack.m_85849_();
            switch (ProjectionType.values()[(Integer)tile.typeOrdinal.getValue()]) {
                case HEMISPHERE: {
                    ibakedmodel = Minecraft.m_91087_().m_91304_().getModel(MFFSClientRegister.MODEL_PREVIEWHALFSPHERE);
                    break;
                }
                case PYRAMID: {
                    ibakedmodel = Minecraft.m_91087_().m_91304_().getModel(MFFSClientRegister.MODEL_PREVIEWPYRAMID);
                    break;
                }
                case SPHERE: {
                    ibakedmodel = Minecraft.m_91087_().m_91304_().getModel(MFFSClientRegister.MODEL_PREVIEWSPHERE);
                    break;
                }
                case CUBE: {
                    ibakedmodel = Minecraft.m_91087_().m_91304_().getModel(MFFSClientRegister.MODEL_PREVIEWCUBE);
                    break;
                }
            }
            if (ibakedmodel != null) {
                poseStack.m_85837_(0.5, 1.25, 0.5);
                poseStack.m_85841_(0.25f, 0.25f, 0.25f);
                poseStack.m_252781_(MathUtils.rotQuaternionDeg((float)rotX, (float)rotY, (float)rotZ));
                if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FABULOUS) {
                    RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)tile, (RenderType)RenderType.m_110466_(), (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
                }
                for (BakedQuad quad : ibakedmodel.m_213637_(null, null, tile.m_58904_().f_46441_)) {
                    bufferIn.m_6299_(RenderType.m_110466_()).putBulkData(poseStack.m_85850_(), quad, color.rFloat(), color.gFloat(), color.bFloat(), 1.0f, combinedLightIn, combinedOverlayIn, true);
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

