/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.Predicate;
import modularforcefields.common.inventory.container.ContainerCoercionDeriver;
import modularforcefields.common.item.subtype.SubtypeModule;
import modularforcefields.common.settings.MFFSConstants;
import modularforcefields.common.tile.TileFortronCapacitor;
import modularforcefields.common.tile.TileFortronConnective;
import modularforcefields.registers.ModularForcefieldsItems;
import modularforcefields.registers.ModularForcefieldsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.TransferPack;

public class TileCoercionDeriver
extends TileFortronConnective {
    public static final HashSet<SubtypeModule> VALIDMODULES = Sets.newHashSet((Object[])new SubtypeModule[]{SubtypeModule.upgradespeed, SubtypeModule.upgradecapacity});
    public static final int BASEENERGY = 50;
    public SingleProperty<Integer> fortron = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortron", (Object)0));
    public SingleProperty<Integer> fortronCapacity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortronCapacity", (Object)0));

    public TileCoercionDeriver(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModularForcefieldsTiles.TILE_COERCIONDERIVER.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, true).voltage(MFFSConstants.COERCIONDERIVER_VOLTAGE).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(4)).valid((index, stack, inv) -> ModularForcefieldsItems.ITEMS_MODULE.getSpecificValues((Object[])new SubtypeModule[]{SubtypeModule.upgradespeed, SubtypeModule.upgradecapacity}).contains(stack.m_41720_())));
        this.addComponent((IComponent)new ComponentContainerProvider("coercionderiver", (GenericTile)this).createMenu((id, player) -> new ContainerCoercionDeriver((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    @Override
    protected void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (tickable.getTicks() % 20L == 0L) {
            boolean shouldLit;
            this.onInventoryChange((ComponentInventory)this.getComponent(IComponentType.Inventory), 0);
            boolean isLit = (Boolean)this.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT);
            boolean bl = shouldLit = (Integer)this.fortron.getValue() > 0;
            if (isLit != shouldLit) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(shouldLit)));
            }
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.fortron.setValue((Object)((int)((double)((Integer)this.fortron.getValue()).intValue() + electro.extractPower(TransferPack.joulesVoltage((double)Math.min(this.getTransfer(), (Integer)this.fortronCapacity.getValue() - (Integer)this.fortron.getValue()), (double)electro.getVoltage()), false).getJoules())));
        this.fortron.setValue((Object)((Integer)this.fortron.getValue() - this.sendFortronTo(Math.min((Integer)this.fortron.getValue(), this.getTransfer()), this.getConnectionTest())));
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        int max = this.getMaxStored();
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        electro.maxJoules((double)max);
        this.fortron.setValue((Object)Mth.m_14045_((int)((Integer)this.fortron.getValue()), (int)0, (int)max));
        this.fortronCapacity.setValue((Object)max);
    }

    private int getMaxStored() {
        return (int)((double)(this.getTransfer() * 20) + (double)(50 * this.countModules(SubtypeModule.upgradecapacity)) * 40.0);
    }

    public int getTransfer() {
        return 1500 + 50 * this.countModules(SubtypeModule.upgradespeed);
    }

    @Override
    protected Predicate<BlockEntity> getConnectionTest() {
        return b -> b instanceof TileFortronCapacitor;
    }
}

