/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile;

import com.google.common.collect.Sets;
import java.util.HashSet;
import modularforcefields.common.inventory.container.ContainerFortronCapacitor;
import modularforcefields.common.item.subtype.SubtypeModule;
import modularforcefields.common.tile.TileCoercionDeriver;
import modularforcefields.common.tile.TileFortronConnective;
import modularforcefields.common.tile.TileFortronFieldProjector;
import modularforcefields.registers.ModularForcefieldsItems;
import modularforcefields.registers.ModularForcefieldsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFortronCapacitor
extends TileFortronConnective {
    public static final HashSet<SubtypeModule> VALIDMODULES = Sets.newHashSet((Object[])new SubtypeModule[]{SubtypeModule.upgradespeed, SubtypeModule.upgradecapacity});
    public static final int BASEENERGY = 100;
    public SingleProperty<Integer> fortron = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortron", (Object)0));
    public SingleProperty<Integer> fortronCapacity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortronCapacity", (Object)0));

    public TileFortronCapacitor(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModularForcefieldsTiles.TILE_FORTRONCAPACITOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(4)).valid((index, stack, inv) -> ModularForcefieldsItems.ITEMS_MODULE.getSpecificValues((Object[])new SubtypeModule[]{SubtypeModule.upgradespeed, SubtypeModule.upgradecapacity}).contains(stack.m_41720_())));
        this.addComponent((IComponent)new ComponentContainerProvider("fortroncapacitor", (GenericTile)this).createMenu((id, player) -> new ContainerFortronCapacitor((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    @Override
    protected void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (tickable.getTicks() % 20L == 0L) {
            boolean shouldLit;
            this.onInventoryChange((ComponentInventory)this.getComponent(IComponentType.Inventory), 0);
            boolean isLit = (Boolean)this.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT);
            boolean bl = shouldLit = (Integer)this.fortron.getValue() > 0;
            if (isLit != shouldLit) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(shouldLit)));
            }
        }
        this.fortron.setValue((Object)((Integer)this.fortron.getValue() - this.sendFortronTo(Math.min((Integer)this.fortron.getValue(), this.getTransfer()), this::canSendTo)));
    }

    protected boolean canSendTo(BlockEntity entity) {
        if (entity instanceof TileCoercionDeriver) {
            return false;
        }
        if (entity instanceof TileFortronCapacitor) {
            TileFortronCapacitor capacitor = (TileFortronCapacitor)entity;
            for (TileFortronConnective connective : this.connections) {
                if (!(connective instanceof TileFortronFieldProjector)) continue;
                TileFortronFieldProjector projector = (TileFortronFieldProjector)connective;
                if (projector.activeFields.isEmpty() || !capacitor.connections.contains((Object)projector)) continue;
                return false;
            }
        }
        return true;
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        int max = this.getMaxStored();
        this.fortron.setValue((Object)Mth.m_14045_((int)((Integer)this.fortron.getValue()), (int)0, (int)max));
        this.fortronCapacity.setValue((Object)max);
    }

    private int getMaxStored() {
        return (int)((double)(this.getTransfer() * 20) + (double)(100 * this.countModules(SubtypeModule.upgradecapacity)) * 100.0);
    }

    public int getTransfer() {
        return 3000 + 100 * this.countModules(SubtypeModule.upgradespeed);
    }

    @Override
    protected boolean canRecieveFortron(TileFortronConnective tile) {
        return true;
    }

    @Override
    protected int recieveFortron(int amount) {
        int received = Math.max(0, Math.min(amount, (Integer)this.fortronCapacity.getValue() - (Integer)this.fortron.getValue()));
        this.fortron.setValue((Object)((Integer)this.fortron.getValue() + received));
        return received;
    }
}

