/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile;

import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import modularforcefields.common.item.subtype.SubtypeModule;
import modularforcefields.registers.ModularForcefieldsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.WorldUtils;

public class TileFortronConnective
extends GenericTile {
    protected HashSet<TileFortronConnective> connections = new HashSet();
    public SingleProperty<Integer> frequency = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "frequency", (Object)0));

    protected TileFortronConnective(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon));
    }

    protected void tickCommon(ComponentTickable tickable) {
        long ticks = tickable.getTicks();
        if (ticks % 200L == 1L) {
            this.findConnections();
        }
        if (ticks % 20L == 0L) {
            this.validateConnections();
        }
    }

    protected void findConnections() {
        Predicate<BlockEntity> predicate = this.getConnectionTest();
        for (BlockEntity entity : WorldUtils.getNearbyTiles((LevelReader)this.f_58857_, (BlockPos)this.f_58858_, (int)5)) {
            if (entity == this || !(entity instanceof TileFortronConnective)) continue;
            TileFortronConnective connection = (TileFortronConnective)entity;
            if (!predicate.test(entity)) continue;
            this.connections.add(connection);
            connection.connections.add(this);
        }
    }

    protected void validateConnections() {
        Iterator<TileFortronConnective> it = this.connections.iterator();
        while (it.hasNext()) {
            TileFortronConnective connection = it.next();
            if (this.getFrequency() == connection.getFrequency()) continue;
            connection.connections.remove((Object)this);
            it.remove();
        }
    }

    protected void invalidateConnections() {
        Iterator<TileFortronConnective> it = this.connections.iterator();
        while (it.hasNext()) {
            TileFortronConnective connection = it.next();
            connection.connections.remove((Object)this);
            it.remove();
        }
    }

    protected int sendFortronTo(int send, Predicate<BlockEntity> valid) {
        int sent = 0;
        HashSet sendList = (HashSet)this.connections.clone();
        sendList.removeIf(connective -> !connective.canRecieveFortron(this) || !valid.test((BlockEntity)connective));
        int size = sendList.size();
        for (TileFortronConnective connective2 : sendList) {
            int ret = connective2.recieveFortron(send / size);
            sent += ret;
            send -= ret;
            --size;
        }
        return sent;
    }

    public int countModules(SubtypeModule module) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        return inv.m_18947_((Item)ModularForcefieldsItems.ITEMS_MODULE.getValue((Object)module));
    }

    public int countModules(SubtypeModule module, int ... slots) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        Item moduleItem = (Item)ModularForcefieldsItems.ITEMS_MODULE.getValue((Object)module);
        int count = 0;
        for (int slot : slots) {
            ItemStack itemstack = inv.m_8020_(slot);
            if (!itemstack.m_150930_(moduleItem)) continue;
            count += itemstack.m_41613_();
        }
        return count;
    }

    public boolean hasModule(SubtypeModule module) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        Item moduleItem = (Item)ModularForcefieldsItems.ITEMS_MODULE.getValue((Object)module);
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack itemstack = inv.m_8020_(slot);
            if (!itemstack.m_150930_(moduleItem)) continue;
            return true;
        }
        return false;
    }

    protected void tickServer(ComponentTickable tickable) {
    }

    public int getFrequency() {
        return (Integer)this.frequency.getValue();
    }

    public void setFrequency(int frequency) {
        this.frequency.setValue((Object)frequency);
    }

    protected Predicate<BlockEntity> getConnectionTest() {
        return b -> true;
    }

    protected boolean canRecieveFortron(TileFortronConnective tile) {
        return false;
    }

    protected int recieveFortron(int amount) {
        return 0;
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateConnections();
    }

    public int getConnections() {
        return this.connections.size();
    }
}

