/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import modularforcefields.common.block.BlockFortronField;
import modularforcefields.common.inventory.container.ContainerFortronFieldProjector;
import modularforcefields.common.item.ItemModule;
import modularforcefields.common.item.subtype.SubtypeModule;
import modularforcefields.common.tile.FortronFieldStatus;
import modularforcefields.common.tile.TileFortronCapacitor;
import modularforcefields.common.tile.TileFortronConnective;
import modularforcefields.common.tile.TileFortronField;
import modularforcefields.common.tile.projection.ProjectionType;
import modularforcefields.common.tile.projection.ThreadProjectorCalculationThread;
import modularforcefields.registers.ModularForcefieldsBlocks;
import modularforcefields.registers.ModularForcefieldsItems;
import modularforcefields.registers.ModularForcefieldsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.Location;

public class TileFortronFieldProjector
extends TileFortronConnective {
    public static final HashSet<SubtypeModule> VALIDMODULES = Sets.newHashSet((Object[])SubtypeModule.values());
    public static final int BASEENERGY = 100;
    private ThreadProjectorCalculationThread calculationThread;
    public Set<BlockPos> calculatedFieldPoints = Collections.synchronizedSet(new HashSet());
    public Set<TileFortronField> activeFields = new HashSet<TileFortronField>();
    public final SingleProperty<Integer> typeOrdinal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "type", (Object)ProjectionType.NONE.ordinal()));
    public final SingleProperty<Integer> fieldColorOrdinal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fieldColorOrdinal", (Object)DyeColor.LIGHT_BLUE.ordinal()));
    public final SingleProperty<Integer> moduleCount = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "moduleCount", (Object)0));
    public final SingleProperty<Integer> fortronCapacity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortronCapacity", (Object)0));
    public final SingleProperty<Integer> fortron = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortron", (Object)0));
    public final SingleProperty<Integer> fortronUse = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortronUse", (Object)0));
    public int calculatedSize;
    private final SingleProperty<Integer> statusInteger = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "statusInteger", (Object)FortronFieldStatus.PROJECTING.ordinal()));
    public final SingleProperty<Integer> xRadiusPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "xRadiusPos", (Object)0));
    public final SingleProperty<Integer> yRadiusPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "yRadiusPos", (Object)0));
    public final SingleProperty<Integer> zRadiusPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "zRadiusPos", (Object)0));
    public final SingleProperty<Integer> xRadiusNeg = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "xRadiusNeg", (Object)0));
    public final SingleProperty<Integer> yRadiusNeg = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "yRadiusNeg", (Object)0));
    public final SingleProperty<Integer> zRadiusNeg = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "zRadiusNeg", (Object)0));
    public final SingleProperty<Integer> radius = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "radius", (Object)0));
    public int scaleEnergy;
    public int speedEnergy;
    public boolean shouldSponge = false;
    public boolean shouldDisintegrate = false;
    public boolean shouldStabilize = false;
    public boolean shouldColor = false;
    public boolean hasCollectionModule = false;
    public boolean isInterior = false;
    public int totalGeneratedPerTick = 0;
    public int ticksUntilProjection;
    public final SingleProperty<BlockPos> shiftedPosition = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "shiftedPosition", (Object)BlockPos.f_121853_));

    public FortronFieldStatus getStatus() {
        return FortronFieldStatus.values()[(Integer)this.statusInteger.getValue()];
    }

    public void setStatus(FortronFieldStatus status) {
        this.statusInteger.setValue((Object)status.ordinal());
    }

    public void destroyField(boolean instant) {
        this.setStatus(FortronFieldStatus.DESTROYING);
        this.calculatedSize = 0;
        if (this.calculationThread != null) {
            this.calculationThread.interrupt();
            this.calculationThread = null;
        }
        this.calculatedFieldPoints.clear();
        if (instant) {
            for (TileFortronField field : this.activeFields) {
                this.f_58857_.m_7731_(field.m_58899_(), Blocks.f_50016_.m_49966_(), 2);
            }
            this.activeFields.clear();
        }
    }

    @Override
    protected int recieveFortron(int amount) {
        int received = Math.max(0, Math.min(amount, (Integer)this.fortronCapacity.getValue() - (Integer)this.fortron.getValue()));
        this.fortron.setValue((Object)((Integer)this.fortron.getValue() + received));
        return received;
    }

    public void onBlockDestroyed() {
        if (!this.f_58857_.f_46443_) {
            this.destroyField(true);
        }
    }

    @Override
    protected Predicate<BlockEntity> getConnectionTest() {
        return b -> b instanceof TileFortronCapacitor;
    }

    public TileFortronFieldProjector(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModularForcefieldsTiles.TILE_FORTRONFIELDPROJECTOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(21)).valid((index, stack, inv) -> true).onChanged(this::onChanged));
        this.addComponent((IComponent)new ComponentContainerProvider("fortronfieldprojector", (GenericTile)this).createMenu((id, player) -> new ContainerFortronFieldProjector((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    @Override
    protected void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (tickable.getTicks() % 20L == 0L) {
            boolean shouldLit;
            this.fortronCapacity.setValue((Object)this.getMaxFortron());
            this.fortron.setValue((Object)Mth.m_14045_((int)((Integer)this.fortron.getValue()), (int)0, (int)((Integer)this.fortronCapacity.getValue())));
            boolean isLit = (Boolean)this.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT);
            boolean bl = shouldLit = (Integer)this.fortron.getValue() > 0;
            if (isLit != shouldLit) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(shouldLit)));
            }
        }
        if (tickable.getTicks() % 1000L == 1L) {
            this.onChanged((ComponentInventory)this.getComponent(IComponentType.Inventory), -1);
        }
        if (this.getStatus() == FortronFieldStatus.PROJECTED && this.activeFields.size() >= this.calculatedSize) {
            this.setStatus(FortronFieldStatus.PROJECTED_SEALED);
        }
        ProjectionType projectedType = this.getProjectionType();
        if (((Integer)this.typeOrdinal.getValue()).intValue() != projectedType.ordinal()) {
            this.destroyField(false);
            this.typeOrdinal.setValue((Object)projectedType.ordinal());
        }
        if (this.getStatus() == FortronFieldStatus.DESTROYING) {
            if (this.activeFields.isEmpty()) {
                this.setStatus(FortronFieldStatus.PREPARE);
                this.ticksUntilProjection = 40;
            } else {
                int count = 0;
                Iterator<TileFortronField> it = this.activeFields.iterator();
                while (it.hasNext() && count++ <= 100 + this.activeFields.size() / 100) {
                    TileFortronField field = it.next();
                    this.f_58857_.m_46597_(field.m_58899_(), Blocks.f_50016_.m_49966_());
                    it.remove();
                }
            }
        }
        if (tickable.getTicks() > 5L) {
            int use = this.getFortronUse();
            if (this.isPoweredByRedstone() && ((Integer)this.typeOrdinal.getValue()).intValue() != ProjectionType.NONE.ordinal() && (Integer)this.fortron.getValue() >= use) {
                this.fortron.setValue((Object)((Integer)this.fortron.getValue() - use));
                if (this.getStatus() != FortronFieldStatus.DESTROYING) {
                    if (this.getStatus() == FortronFieldStatus.PREPARE && this.calculatedFieldPoints.isEmpty()) {
                        if (this.ticksUntilProjection > 0) {
                            if ((Integer)this.fortron.getValue() > use) {
                                --this.ticksUntilProjection;
                            }
                        } else {
                            this.ticksUntilProjection = 40;
                            this.setStatus(FortronFieldStatus.CALCULATING);
                            this.calculationThread = new ThreadProjectorCalculationThread(this);
                            this.calculationThread.start();
                            Logger.getGlobal().log(Level.INFO, "Started forcefield calculation thread at: " + new Location(this.f_58858_));
                        }
                    } else if (this.getStatus() != FortronFieldStatus.CALCULATING && !this.calculatedFieldPoints.isEmpty()) {
                        this.projectField();
                    } else if (this.getStatus() == FortronFieldStatus.PROJECTING) {
                        this.setStatus(FortronFieldStatus.PROJECTED);
                        for (TileFortronField field : this.activeFields) {
                            field.setConstructor(this);
                        }
                    }
                }
            } else if (this.getStatus() != FortronFieldStatus.PREPARE) {
                if ((Integer)this.fortron.getValue() < use) {
                    this.ticksUntilProjection = 100;
                }
                this.destroyField(false);
            }
        }
    }

    private void projectField() {
        this.setStatus(FortronFieldStatus.PROJECTING);
        HashSet<BlockPos> finishedQueueItems = new HashSet<BlockPos>();
        int currentlyGenerated = 0;
        for (BlockPos fieldPoint : this.calculatedFieldPoints) {
            if (currentlyGenerated >= this.totalGeneratedPerTick) break;
            finishedQueueItems.add(fieldPoint);
            BlockState state = this.f_58857_.m_8055_(fieldPoint);
            Block block = state.m_60734_();
            if (state.m_60713_((Block)ModularForcefieldsBlocks.BLOCK_FORTRONFIELD.get()) && this.integrateExistingFieldPoint(fieldPoint)) {
                ++currentlyGenerated;
                continue;
            }
            if (this.shouldSponge) {
                // empty if block
            }
            if (this.shouldDisintegrate) {
                state = this.disintegrate(fieldPoint, state);
            }
            if (state.m_60629_(new BlockPlaceContext(this.f_58857_, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)block), new BlockHitResult(Vec3.f_82478_, Direction.DOWN, fieldPoint, false)))) {
                if (this.shouldStabilize) {
                    this.stabilizeFieldPoint(fieldPoint);
                    continue;
                }
                currentlyGenerated = this.createNewFieldPoint(currentlyGenerated, fieldPoint);
                continue;
            }
            if (state.m_60800_((BlockGetter)this.f_58857_, fieldPoint) != -1.0f) continue;
            --this.calculatedSize;
        }
        this.calculatedFieldPoints.removeAll(finishedQueueItems);
    }

    private boolean integrateExistingFieldPoint(BlockPos fieldPoint) {
        boolean invalidProjector;
        TileFortronField field;
        BlockState st = this.f_58857_.m_8055_(fieldPoint);
        if (st.m_61143_(BlockFortronField.COLOR) != this.getFieldColor()) {
            this.f_58857_.m_46597_(fieldPoint, (BlockState)st.m_61124_(BlockFortronField.COLOR, (Comparable)this.getFieldColor()));
        }
        if ((field = (TileFortronField)this.f_58857_.m_7702_(fieldPoint)) == null) {
            return false;
        }
        boolean isSupposedToBeConnectedLocally = this.f_58858_.equals((Object)field.getProjectorPos());
        boolean bl = invalidProjector = field.getProjectorPos() == null || !(this.f_58857_.m_7702_(field.getProjectorPos()) instanceof TileFortronFieldProjector);
        if (isSupposedToBeConnectedLocally || invalidProjector) {
            this.activeFields.add(field);
            field.setConstructor(this);
            return true;
        }
        return false;
    }

    private int createNewFieldPoint(int currentlyGenerated, BlockPos fieldPoint) {
        this.f_58857_.m_46597_(fieldPoint, (BlockState)((BlockFortronField)((Object)ModularForcefieldsBlocks.BLOCK_FORTRONFIELD.get())).m_49966_().m_61124_(BlockFortronField.COLOR, (Comparable)this.getFieldColor()));
        BlockEntity blockEntity = this.f_58857_.m_7702_(fieldPoint);
        if (blockEntity instanceof TileFortronField) {
            TileFortronField field = (TileFortronField)blockEntity;
            field.setConstructor(this);
            this.activeFields.add(field);
        }
        return currentlyGenerated + 1;
    }

    private void stabilizeFieldPoint(BlockPos fieldPoint) {
        boolean broken = false;
        block0: for (Direction dir : Direction.values()) {
            IItemHandler handler;
            if (broken) break;
            BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121955_(dir.m_122436_()));
            if (entity == null || (handler = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER)) == CapabilityUtils.EMPTY_ITEM_HANDLER) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                BlockItem bi;
                Block b;
                ItemStack stack = handler.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (!(item instanceof BlockItem) || !(b = (bi = (BlockItem)item).m_40614_()).m_49966_().m_60710_((LevelReader)this.f_58857_, fieldPoint)) continue;
                this.f_58857_.m_46597_(fieldPoint, b.m_49966_());
                stack.m_41774_(1);
                broken = true;
                continue block0;
            }
        }
    }

    @NotNull
    private BlockState disintegrate(BlockPos fieldPoint, BlockState state) {
        if (state.m_60800_((BlockGetter)this.f_58857_, fieldPoint) != -1.0f) {
            this.collect(fieldPoint, state);
            this.f_58857_.m_46597_(fieldPoint, Blocks.f_50016_.m_49966_());
            state = Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    private void collect(BlockPos fieldPoint, BlockState state) {
        if (this.hasCollectionModule) {
            List items = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)fieldPoint, null);
            for (Direction dir : Direction.values()) {
                IItemHandler handler;
                BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121955_(dir.m_122436_()));
                if (entity == null || (handler = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER)) == CapabilityUtils.EMPTY_ITEM_HANDLER) continue;
                block1: for (ItemStack item : items) {
                    for (int targetIndex = 0; targetIndex < handler.getSlots(); ++targetIndex) {
                        ItemStack remainder = handler.insertItem(targetIndex, item, false);
                        int taken = item.m_41613_() - remainder.m_41613_();
                        if (taken <= 0) continue;
                        item.m_41774_(taken);
                        if (item.m_41619_()) continue block1;
                    }
                }
            }
        }
    }

    public int getMaxFortron() {
        return this.getFortronUse() * 200 + 100;
    }

    public int getFortronUse() {
        if (!this.f_58857_.f_46443_) {
            this.fortronUse.setValue((Object)(this.scaleEnergy + this.speedEnergy + (this.shouldDisintegrate || this.shouldStabilize ? 5000 : 0)));
        }
        return (Integer)this.fortronUse.getValue();
    }

    public BlockPos getShiftedPos() {
        if (this.shiftedPosition == null) {
            this.shiftedPosition.setValue((Object)this.f_58858_);
        }
        return (BlockPos)this.shiftedPosition.getValue();
    }

    @Override
    protected boolean canRecieveFortron(TileFortronConnective tile) {
        return tile instanceof TileFortronCapacitor;
    }

    public boolean isInterior() {
        return this.isInterior;
    }

    public void updateFieldTerms() {
        this.isInterior = this.hasModule(SubtypeModule.upgradeinterior);
        this.shouldSponge = this.hasModule(SubtypeModule.upgradesponge);
        this.shouldDisintegrate = this.hasModule(SubtypeModule.upgradedisintegration);
        this.shouldColor = this.hasModule(SubtypeModule.upgradecolorchange);
        this.shouldStabilize = this.hasModule(SubtypeModule.upgradestabilize);
        this.hasCollectionModule = this.hasModule(SubtypeModule.upgradecollection);
        this.totalGeneratedPerTick = 1 + 2 * this.countModules(SubtypeModule.upgradespeed) / ((this.shouldSponge ? 2 : 5) / (this.shouldStabilize ? 2 : 1));
        if (this.shouldSponge) {
            this.totalGeneratedPerTick /= 2;
        } else if (this.shouldDisintegrate) {
            this.totalGeneratedPerTick /= this.hasCollectionModule ? 5 : 4;
        } else if (this.shouldStabilize) {
            this.totalGeneratedPerTick /= 3;
        }
    }

    private void onChanged(ComponentInventory inv, int index) {
        int count = 0;
        this.updateFieldTerms();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack;
            if (i == 19 || (stack = inv.m_8020_(i)).m_41619_() || !ModularForcefieldsItems.ITEMS_MODULE.getAllValues().contains(stack.m_41720_())) continue;
            count += stack.m_41613_();
        }
        BlockPos newshiftedPosition = this.f_58858_.m_7918_(this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_EAST[0], ContainerFortronFieldProjector.SLOT_EAST[1]) - this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_WEST[0], ContainerFortronFieldProjector.SLOT_WEST[1]), this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_UP[0], ContainerFortronFieldProjector.SLOT_UP[1]) - this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_DOWN[0], ContainerFortronFieldProjector.SLOT_DOWN[1]), this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_SOUTH[0], ContainerFortronFieldProjector.SLOT_SOUTH[1]) - this.countModules(SubtypeModule.manipulationtranslate, ContainerFortronFieldProjector.SLOT_NORTH[0], ContainerFortronFieldProjector.SLOT_NORTH[1]));
        int newxRadiusPos = newshiftedPosition.m_123341_() + Math.min(64, this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_EAST[0], ContainerFortronFieldProjector.SLOT_EAST[1]));
        int newyRadiusPos = Math.min(this.m_58904_().m_151558_(), Math.max(this.m_58904_().m_141937_(), newshiftedPosition.m_123342_() + this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_UP[0], ContainerFortronFieldProjector.SLOT_UP[1])));
        int newzRadiusPos = newshiftedPosition.m_123343_() + Math.min(64, this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_SOUTH[0], ContainerFortronFieldProjector.SLOT_SOUTH[1]));
        int newxRadiusNeg = newshiftedPosition.m_123341_() - Math.min(64, this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_WEST[0], ContainerFortronFieldProjector.SLOT_WEST[1]));
        int newyRadiusNeg = Math.max(this.m_58904_().m_141937_(), newshiftedPosition.m_123342_() - this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_DOWN[0], ContainerFortronFieldProjector.SLOT_DOWN[1]));
        int newzRadiusNeg = newshiftedPosition.m_123343_() - Math.min(64, this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_NORTH[0], ContainerFortronFieldProjector.SLOT_NORTH[1]));
        int newradius = Math.min(64, this.countModules(SubtypeModule.manipulationscale, ContainerFortronFieldProjector.SLOT_MODULES) / 6);
        if (!newshiftedPosition.equals((Object)this.getShiftedPos()) || (Integer)this.xRadiusPos.getValue() != newxRadiusPos || (Integer)this.yRadiusPos.getValue() != newyRadiusPos || (Integer)this.zRadiusPos.getValue() != newzRadiusPos || (Integer)this.xRadiusNeg.getValue() != newxRadiusNeg || (Integer)this.yRadiusNeg.getValue() != newyRadiusNeg || (Integer)this.zRadiusNeg.getValue() != newzRadiusNeg || (Integer)this.radius.getValue() != newradius) {
            this.destroyField(false);
        }
        this.shiftedPosition.setValue((Object)newshiftedPosition);
        this.moduleCount.setValue((Object)count);
        this.xRadiusPos.setValue((Object)newxRadiusPos);
        this.yRadiusPos.setValue((Object)newyRadiusPos);
        this.zRadiusPos.setValue((Object)newzRadiusPos);
        this.xRadiusNeg.setValue((Object)newxRadiusNeg);
        this.yRadiusNeg.setValue((Object)newyRadiusNeg);
        this.zRadiusNeg.setValue((Object)newzRadiusNeg);
        this.radius.setValue((Object)newradius);
        this.scaleEnergy = 100 * this.countModules(SubtypeModule.manipulationscale, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11);
        this.speedEnergy = 1 + 100 * this.countModules(SubtypeModule.upgradespeed, ContainerFortronFieldProjector.SLOT_UPGRADES);
    }

    public ProjectionType getProjectionType() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack stack = inv.m_8020_(19);
        if (stack.m_41619_()) {
            return ProjectionType.NONE;
        }
        Item item = stack.m_41720_();
        if (item instanceof ItemModule) {
            ItemModule module = (ItemModule)item;
            switch (module.subtype) {
                case shapecube: {
                    return ProjectionType.CUBE;
                }
                case shapehemisphere: {
                    return ProjectionType.HEMISPHERE;
                }
                case shapepyramid: {
                    return ProjectionType.PYRAMID;
                }
                case shapesphere: {
                    return ProjectionType.SPHERE;
                }
            }
        }
        return ProjectionType.NONE;
    }

    public DyeColor getFieldColor() {
        return DyeColor.values()[(Integer)this.fieldColorOrdinal.getValue()];
    }
}

