/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import modularforcefields.common.inventory.container.ContainerInterdictionMatrix;
import modularforcefields.common.item.ItemModule;
import modularforcefields.common.item.subtype.SubtypeModule;
import modularforcefields.common.tile.TileBiometricIdentifier;
import modularforcefields.common.tile.TileFortronCapacitor;
import modularforcefields.common.tile.TileFortronConnective;
import modularforcefields.registers.ModularForcefieldsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.CapabilityUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="modularforcefields")
public class TileInterdictionMatrix
extends TileFortronConnective {
    public static HashMap<TileInterdictionMatrix, AABB> matrices = new HashMap();
    public static final int BASEENERGY = 20;
    public static final HashSet<SubtypeModule> VALIDMODULES = Sets.newHashSet((Object[])SubtypeModule.values());
    public SingleProperty<Integer> fortron = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortron", (Object)0));
    public SingleProperty<Integer> scaleEnergy = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "scaleEnergy", (Object)0));
    public SingleProperty<Integer> fortronCapacity = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fortronCapacity", (Object)0));
    public int radius;
    public boolean running;
    public boolean antispawn;
    public boolean blockaccess;
    public boolean blockalter;
    private int strength;
    private final HashSet<UUID> validPlayers = new HashSet();

    public TileInterdictionMatrix(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModularForcefieldsTiles.TILE_INTERDICTIONMATRIX.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(18)).valid((index, stack, inv) -> true).onChanged(this::onChanged));
        this.addComponent((IComponent)new ComponentContainerProvider("interdictionmatrix", (GenericTile)this).createMenu((id, player) -> new ContainerInterdictionMatrix((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    @Override
    protected void tickCommon(ComponentTickable tickable) {
        super.tickCommon(tickable);
        if (tickable.getTicks() % 20L == 0L) {
            // empty if block
        }
    }

    @Override
    protected void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (tickable.getTicks() % 20L == 0L) {
            boolean shouldLit;
            this.fortronCapacity.setValue((Object)this.getMaxFortron());
            this.fortron.setValue((Object)Mth.m_14045_((int)((Integer)this.fortron.getValue()), (int)0, (int)((Integer)this.fortronCapacity.getValue())));
            boolean isLit = (Boolean)this.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT);
            boolean bl = shouldLit = (Integer)this.fortron.getValue() > 0;
            if (isLit != shouldLit) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(shouldLit)));
            }
        }
        if (tickable.getTicks() % 1000L == 1L) {
            this.onChanged((ComponentInventory)this.getComponent(IComponentType.Inventory), -1);
        }
        int use = this.getFortronUse();
        this.running = false;
        if ((Integer)this.fortron.getValue() >= use && this.isPoweredByRedstone()) {
            this.fortron.setValue((Object)((Integer)this.fortron.getValue() - use));
            this.running = true;
        }
        this.validPlayers.clear();
        if (tickable.getTicks() % 10L == 0L && this.running) {
            for (Direction direction : Direction.values()) {
                BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121955_(direction.m_122436_()));
                if (!(entity instanceof TileBiometricIdentifier)) continue;
                TileBiometricIdentifier identifier = (TileBiometricIdentifier)entity;
                for (ItemStack stack : ((ComponentInventory)identifier.getComponent(IComponentType.Inventory)).getItems()) {
                    UUID id;
                    if (!stack.m_41782_() || (id = stack.m_41783_().m_128342_("player")) == null) continue;
                    this.validPlayers.add(id);
                }
            }
            AABB aabb = new AABB(this.f_58858_).m_82400_((double)this.radius);
            List entities = this.f_58857_.m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), aabb, LivingEntity::m_6084_);
            matrices.put(this, aabb);
            ArrayList<SubtypeModule> list = new ArrayList<SubtypeModule>();
            for (ItemStack stack : ((ComponentInventory)this.getComponent(IComponentType.Inventory)).getItems()) {
                Iterator iterator = stack.m_41720_();
                if (!(iterator instanceof ItemModule)) continue;
                ItemModule module = (ItemModule)((Object)iterator);
                list.add(module.subtype);
            }
            this.applyModules(list, entities);
        }
    }

    private void applyModules(List<SubtypeModule> list, List<LivingEntity> entities) {
        for (LivingEntity entity : entities) {
            Player player;
            if (entity instanceof Player && (this.validPlayers.contains((player = (Player)entity).m_20148_()) || player.m_7500_())) continue;
            if (list.contains((Object)SubtypeModule.upgradeantifriendly) && entity instanceof Animal) {
                Animal animal = (Animal)entity;
                animal.m_6469_(animal.m_269291_().m_269425_(), (float)(2 + this.strength));
            }
            if (list.contains((Object)SubtypeModule.upgradeantihostile) && entity instanceof Monster) {
                Monster monster = (Monster)entity;
                monster.m_6469_(monster.m_269291_().m_269425_(), (float)(2 + this.strength));
            }
            if (list.contains((Object)SubtypeModule.upgradeconfiscate) && entity instanceof Player) {
                player = (Player)entity;
                this.confiscateItems(player);
            }
            if (list.contains((Object)SubtypeModule.upgradeantipersonnel) && entity instanceof Player) {
                player = (Player)entity;
                player.m_6469_(player.m_269291_().m_269425_(), (float)(2 + this.strength));
            }
            this.antispawn = list.contains((Object)SubtypeModule.upgradeantispawn);
            this.blockaccess = list.contains((Object)SubtypeModule.upgradeblockaccess);
            this.blockalter = list.contains((Object)SubtypeModule.upgradeblockalter);
        }
    }

    @Override
    protected int recieveFortron(int amount) {
        int received = Math.max(0, Math.min(amount, (Integer)this.fortronCapacity.getValue() - (Integer)this.fortron.getValue()));
        this.fortron.setValue((Object)((Integer)this.fortron.getValue() + received));
        return received;
    }

    private void confiscateItems(Player player) {
        int index;
        BlockEntity above = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (above == null) {
            return;
        }
        IItemHandler handler = (IItemHandler)above.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
        if (handler == CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return;
        }
        NonNullList stacks = player.m_150109_().f_35974_;
        for (index = 0; index < stacks.size(); ++index) {
            player.m_150109_().m_6836_(index, TileInterdictionMatrix.addItemToItemHandler((ItemStack)stacks.get(index), handler).m_41777_());
        }
        stacks = player.m_150109_().f_35975_;
        for (index = 0; index < stacks.size(); ++index) {
            player.m_150109_().m_6836_(index, TileInterdictionMatrix.addItemToItemHandler((ItemStack)stacks.get(index), handler).m_41777_());
        }
        stacks = player.m_150109_().f_35976_;
        for (index = 0; index < stacks.size(); ++index) {
            player.m_150109_().m_6836_(index, TileInterdictionMatrix.addItemToItemHandler((ItemStack)stacks.get(index), handler).m_41777_());
        }
    }

    private static ItemStack addItemToItemHandler(ItemStack item, IItemHandler handler) {
        for (int targetIndex = 0; targetIndex < handler.getSlots(); ++targetIndex) {
            ItemStack remainder = handler.insertItem(targetIndex, item, false);
            int taken = item.m_41613_() - remainder.m_41613_();
            if (taken <= 0) continue;
            item.m_41774_(taken);
            if (item.m_41619_()) break;
        }
        return item;
    }

    @SubscribeEvent
    public static void spawnLiving(MobSpawnEvent.SpawnPlacementCheck event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().antispawn || !en.getValue().m_82381_(event.getEntityType().m_20585_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()))) continue;
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccessBlockRight(PlayerInteractEvent.RightClickBlock event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockaccess || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || en.getKey().validPlayers.contains((player = event.getEntity()).m_20148_()) || player.m_7500_()) continue;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccessBlockLeft(PlayerInteractEvent.LeftClickBlock event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockaccess || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || en.getKey().validPlayers.contains((player = event.getEntity()).m_20148_()) || player.m_7500_()) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccessItemRight(PlayerInteractEvent.RightClickBlock event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockaccess || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || en.getKey().validPlayers.contains((player = event.getEntity()).m_20148_()) || player.m_7500_()) continue;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccessItemLeft(PlayerInteractEvent.LeftClickBlock event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockaccess || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || en.getKey().validPlayers.contains((player = event.getEntity()).m_20148_()) || player.m_7500_()) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccess(BlockEvent.BreakEvent event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockalter || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || en.getKey().validPlayers.contains((player = event.getPlayer()).m_20148_()) || player.m_7500_()) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void antiAccess(BlockEvent.EntityPlaceEvent event) {
        for (Map.Entry<TileInterdictionMatrix, AABB> en : matrices.entrySet()) {
            Player player;
            Entity entity;
            if (!en.getKey().running || en.getKey().m_58901_() || !en.getKey().blockalter || !en.getValue().m_82393_((double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_()) || (entity = event.getEntity()) instanceof Player && (en.getKey().validPlayers.contains((player = (Player)entity).m_20148_()) || player.m_7500_())) continue;
            event.setCanceled(true);
            return;
        }
    }

    public int getMaxFortron() {
        return this.getFortronUse() * 40 + 2000;
    }

    public int getFortronUse() {
        return (Integer)this.scaleEnergy.getValue();
    }

    @Override
    protected boolean canRecieveFortron(TileFortronConnective tile) {
        return tile instanceof TileFortronCapacitor;
    }

    private void onChanged(ComponentInventory inv, int index) {
        this.radius = this.countModules(SubtypeModule.manipulationscale);
        this.strength = this.countModules(SubtypeModule.upgradestrength);
        this.scaleEnergy.setValue((Object)((20 + this.strength) * this.radius * this.radius * this.radius));
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        matrices.remove((Object)this);
    }
}

