/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.common.tile.projection;

import java.util.Random;
import java.util.function.BiConsumer;
import modularforcefields.common.tile.TileFortronFieldProjector;
import modularforcefields.common.tile.projection.ThreadProjectorCalculationThread;
import net.minecraft.core.BlockPos;
import voltaic.prefab.block.HashDistanceBlockPos;
import voltaic.prefab.utilities.object.Location;

public enum ProjectionType {
    NONE((proj, t) -> proj.calculatedFieldPoints.clear()),
    CUBE((proj, t) -> {
        Random rand = new Random();
        for (int i = ((Integer)proj.xRadiusNeg.getValue()).intValue(); i <= (Integer)proj.xRadiusPos.getValue(); ++i) {
            for (int j = ((Integer)proj.yRadiusNeg.getValue()).intValue(); j <= (Integer)proj.yRadiusPos.getValue(); ++j) {
                for (int k = ((Integer)proj.zRadiusNeg.getValue()).intValue(); k <= (Integer)proj.zRadiusPos.getValue(); ++k) {
                    boolean isEdge;
                    boolean bl = isEdge = i == (Integer)proj.xRadiusNeg.getValue() || i == (Integer)proj.xRadiusPos.getValue() || j == (Integer)proj.yRadiusNeg.getValue() || j == (Integer)proj.yRadiusPos.getValue() || k == (Integer)proj.zRadiusNeg.getValue() || k == (Integer)proj.zRadiusPos.getValue();
                    if (proj.isInterior() == isEdge) continue;
                    proj.calculatedFieldPoints.add((BlockPos)new HashDistanceBlockPos((double)i, (double)j, (double)k, (int)((double)(10000 - j) + rand.nextDouble() * 3.0 + (double)((int)Math.sqrt(new BlockPos(i, j, k).m_203198_((double)proj.m_58899_().m_123341_() + 0.5, (double)j + 0.5, (double)proj.m_58899_().m_123343_() + 0.5))))));
                }
            }
        }
    }),
    SPHERE((proj, t) -> {
        Random rand = new Random();
        BlockPos shifted = proj.getShiftedPos();
        for (int i = shifted.m_123342_() - (Integer)proj.radius.getValue(); i <= shifted.m_123341_() + (Integer)proj.radius.getValue(); ++i) {
            for (int j = Math.max(proj.m_58904_().m_141937_(), shifted.m_123342_() - (Integer)proj.radius.getValue()); j <= Math.min(proj.m_58904_().m_151558_(), shifted.m_123342_() + (Integer)proj.radius.getValue()); ++j) {
                for (int k = shifted.m_123343_() - (Integer)proj.radius.getValue(); k <= shifted.m_123343_() + (Integer)proj.radius.getValue(); ++k) {
                    Location loc = new Location((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f));
                    int distance = (int)loc.distance(new Location(shifted));
                    if (!(proj.isInterior() ? distance <= (Integer)proj.radius.getValue() : distance == (Integer)proj.radius.getValue())) continue;
                    proj.calculatedFieldPoints.add((BlockPos)new HashDistanceBlockPos((double)i, (double)j, (double)k, (int)((double)(10000 - j) + rand.nextDouble() * 3.0)));
                }
            }
        }
    }),
    HEMISPHERE((proj, t) -> {
        Random rand = new Random();
        BlockPos shifted = proj.getShiftedPos();
        for (int i = shifted.m_123342_() - (Integer)proj.radius.getValue(); i <= shifted.m_123341_() + (Integer)proj.radius.getValue(); ++i) {
            for (int j = Math.max(proj.m_58904_().m_141937_(), shifted.m_123342_()); j <= Math.min(proj.m_58904_().m_151558_(), shifted.m_123342_() + (Integer)proj.radius.getValue()); ++j) {
                for (int k = shifted.m_123343_() - (Integer)proj.radius.getValue(); k <= shifted.m_123343_() + (Integer)proj.radius.getValue(); ++k) {
                    Location loc = new Location((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f));
                    int distance = (int)loc.distance(new Location(shifted));
                    if (!(proj.isInterior() ? distance <= (Integer)proj.radius.getValue() : distance == (Integer)proj.radius.getValue())) continue;
                    proj.calculatedFieldPoints.add((BlockPos)new HashDistanceBlockPos((double)i, (double)j, (double)k, (int)((double)(10000 - j) + rand.nextDouble() * 3.0)));
                }
            }
        }
    }),
    PYRAMID((proj, t) -> {
        Random rand = new Random();
        BlockPos shifted = proj.getShiftedPos();
        for (int i = shifted.m_123342_() - (Integer)proj.radius.getValue(); i <= shifted.m_123341_() + (Integer)proj.radius.getValue(); ++i) {
            for (int j = Math.max(proj.m_58904_().m_141937_(), shifted.m_123342_()); j <= Math.min(proj.m_58904_().m_151558_(), shifted.m_123342_() + (Integer)proj.radius.getValue()); ++j) {
                for (int k = shifted.m_123343_() - (Integer)proj.radius.getValue(); k <= shifted.m_123343_() + (Integer)proj.radius.getValue(); ++k) {
                    if (t.isInterrupted()) {
                        return;
                    }
                    Location loc = new Location((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f));
                    int distance = (int)loc.distancelinear(new Location(shifted));
                    if (!(proj.isInterior() ? distance <= (Integer)proj.radius.getValue() : distance == (Integer)proj.radius.getValue())) continue;
                    proj.calculatedFieldPoints.add((BlockPos)new HashDistanceBlockPos((double)i, (double)j, (double)k, (int)((double)(10000 - j) + rand.nextDouble() * 3.0)));
                }
            }
        }
    });

    private final BiConsumer<TileFortronFieldProjector, ThreadProjectorCalculationThread> calculate;

    private ProjectionType(BiConsumer<TileFortronFieldProjector, ThreadProjectorCalculationThread> calculate) {
        this.calculate = calculate;
    }

    public void calculate(TileFortronFieldProjector projector, ThreadProjectorCalculationThread thread) {
        this.calculate.accept(projector, thread);
    }
}

