/*
 * Decompiled with CFR 0.152.
 */
package modularforcefields.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import modularforcefields.datagen.client.MFFSBlockStateProvider;
import modularforcefields.datagen.client.MFFSItemModelsProvider;
import modularforcefields.datagen.client.MFFSLangKeyProvider;
import modularforcefields.datagen.client.MFFSSoundProvider;
import modularforcefields.datagen.server.MFFSLootTablesProvider;
import modularforcefields.datagen.server.recipe.MFFSRecipeProvider;
import modularforcefields.datagen.server.tags.MFFSTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.datagen.utils.client.BaseLangKeyProvider;

@Mod.EventBusSubscriber(modid="modularforcefields", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(MFFSLootTablesProvider::new, LootContextParamSets.f_81421_))));
            generator.addProvider(true, (DataProvider)new MFFSRecipeProvider(output, lookupProvider));
            MFFSTagsProvider.addTagProviders(generator, output, lookupProvider, helper);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new MFFSBlockStateProvider(output, helper));
            generator.addProvider(true, (DataProvider)new MFFSItemModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new MFFSLangKeyProvider(output, BaseLangKeyProvider.Locale.EN_US));
            generator.addProvider(true, (DataProvider)new MFFSSoundProvider(output, helper));
        }
    }
}

