/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.roads.blocks;

import com.fureniku.metropolis.blocks.MetroBlockBase;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import com.fureniku.roads.blocks.RoadBlockSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public class RoadBlock
extends MetroBlockBase {
    private final int HEIGHT;
    private final VoxelShape BLOCK_SHAPE;
    private RoadBlockSet _roadBlockSet;
    private ResourceLocation _resourceLocation;

    public RoadBlock(int height, RoadBlockSet blockSet) {
        this(height, blockSet, new ResourceLocation("furenikusroads", "block/roads/" + blockSet.getSetName()));
    }

    public RoadBlock(int height, RoadBlockSet blockSet, ResourceLocation texture) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56742_));
        this.HEIGHT = height;
        this.BLOCK_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        this._roadBlockSet = blockSet;
        this._resourceLocation = texture;
    }

    protected VoxelShape getShapeFromBlockState(BlockState pState) {
        return this.BLOCK_SHAPE;
    }

    public void generateBlockState(RegistryObject<Block> blockRegistryObject, MetroBlockStateProvider blockStateProvider) {
        Block block = (Block)blockRegistryObject.get();
        BlockModelBuilder modelFile = blockStateProvider.getModelFilesWithTexture(block, "", "blocks/roads/road_block_" + this.HEIGHT, this._resourceLocation);
        blockStateProvider.simpleBlockWithItem(block, (ModelFile)modelFile);
    }
}

