/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.roads.registrations;

import com.fureniku.metropolis.RegistrationBase;
import com.fureniku.metropolis.RegistrationGroup;
import com.fureniku.metropolis.blockentity.MetroBlockEntity;
import com.fureniku.metropolis.blocks.decorative.MetroBlockDecorativeBase;
import com.fureniku.metropolis.blocks.decorative.builders.MetroBlockDecorativeBuilder;
import com.fureniku.metropolis.blocks.decorative.helpers.HelperBase;
import com.fureniku.metropolis.blocks.decorative.helpers.OffsetHelper;
import com.fureniku.metropolis.blocks.decorative.helpers.RotationHelper;
import com.fureniku.metropolis.utils.CreativeTabSet;
import com.fureniku.metropolis.utils.ShapeUtils;
import com.fureniku.metropolis.utils.SimpleUtils;
import com.fureniku.roads.blockentities.BlockType;
import com.fureniku.roads.blockentities.CrusherBlockEntity;
import com.fureniku.roads.blockentities.FabricatorBlockEntity;
import com.fureniku.roads.blockentities.menus.CrusherMenu;
import com.fureniku.roads.blocks.entityblock.CrusherEntityBlock;
import com.fureniku.roads.blocks.entityblock.FabricatorEntityBlock;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public class RegistrationMachines
extends RegistrationGroup {
    private final String CRUSHER = "crusher";
    private final String FABRICATOR = "fabricator";
    private final String PAINT_FILLER = "paint_filler";
    private final String PAINT_OVEN = "paint_oven";
    private final String ROAD_FACTORY = "road_factory";
    private final String TAR_DISTILLER = "tar_distiller";
    private final String TARMAC_CUTTER = "tarmac_cutter";
    private CreativeTabSet _machineTab;
    private BlockBehaviour.Properties _props = BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56743_);

    public RegistrationMachines(RegistrationBase registrationBase) {
        super(registrationBase);
    }

    public void init(IEventBus iEventBus) {
        CrusherEntityBlock.ENTITY = this.registerEntity("crusher", this.getHelpers(12.0f, 14.0f), BlockType.CRUSHER, CrusherBlockEntity::new);
        CrusherEntityBlock.MENU = this.registration.registerMenuType("crusher_menu", () -> new MenuType(CrusherMenu::new, FeatureFlags.f_244332_));
        FabricatorEntityBlock.ENTITY = this.registerEntity("fabricator", this.getHelpers(12.0f, 9.5f), BlockType.FABRICATOR, FabricatorBlockEntity::new);
        this._machineTab = new CreativeTabSet(this.registration.getCreativeTabDeferredRegister(), "tab_machines", this.getItem("crusher"));
    }

    private HelperBase[] getHelpers(float width, float height) {
        return new HelperBase[]{new RotationHelper(ShapeUtils.makeShape((float)width, (float)height))};
    }

    private RegistryObject<BlockEntityType<MetroBlockEntity>> registerEntity(String name, HelperBase[] helpers, BlockType blockType, BlockEntityType.BlockEntitySupplier entity) {
        return this.registration.registerBlockEntityWithBlock(name, () -> new MetroBlockDecorativeBuilder(this._props).setModelDirectory("blocks/machine/").setModelName(name).setTextures(this.getLoc(name)).setHelpers(helpers).buildAs(RegistrationMachines.getBlockFactory(blockType, helpers)), entity);
    }

    public void generateCreativeTabs() {
        this._machineTab.addItem(((Item)this.getItem("crusher").get()).m_7968_());
        this._machineTab.addItem(((Item)this.getItem("fabricator").get()).m_7968_());
    }

    public ArrayList<CreativeTabSet> getCreativeTabs() {
        ArrayList<CreativeTabSet> tabList = new ArrayList<CreativeTabSet>();
        tabList.add(this._machineTab);
        return tabList;
    }

    protected ResourceLocation getLoc(String name) {
        return new ResourceLocation("furenikusroads", "block/machine/" + name);
    }

    private static MetroBlockDecorativeBase.MetroBlockStateFactory getBlockFactory(BlockType type, final HelperBase ... helpersIn) {
        switch (type) {
            case CRUSHER: {
                return (props, shape, modelDir, modelName, tag, dynamicShape, textures) -> new CrusherEntityBlock(props, shape, modelDir, modelName, tag, SimpleUtils.containsType(OffsetHelper.class, (Object[])helpersIn), textures){

                    public ArrayList<HelperBase> getHelpers() {
                        return new ArrayList<HelperBase>(Arrays.asList(helpersIn));
                    }
                };
            }
            case FABRICATOR: {
                return (props, shape, modelDir, modelName, tag, dynamicShape, textures) -> new FabricatorEntityBlock(props, shape, modelDir, modelName, tag, SimpleUtils.containsType(OffsetHelper.class, (Object[])helpersIn), textures){

                    public ArrayList<HelperBase> getHelpers() {
                        return new ArrayList<HelperBase>(Arrays.asList(helpersIn));
                    }
                };
            }
        }
        return null;
    }
}

