/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayConnectorItem;

public class WalkwayConnectorHandler {
    private static final Random RANDOM = new Random();

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean escalator;
            CompoundTag tag;
            ItemStack heldItem = player.m_21120_(hand);
            Item item = heldItem.m_41720_();
            if (!(item instanceof WalkwayConnectorItem)) continue;
            WalkwayConnectorItem walkwayItem = (WalkwayConnectorItem)item;
            if (!heldItem.m_41782_() || !(tag = heldItem.m_41783_()).m_128441_("FirstTerminal")) continue;
            BlockPos first = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstTerminal"));
            BlockState firstState = level.m_8055_(first);
            Direction.Axis axis = Direction.Axis.Y;
            if (ShaftBlock.isShaft((BlockState)firstState)) {
                axis = (Direction.Axis)firstState.m_61143_((Property)BlockStateProperties.f_61365_);
            } else {
                KineticBlock kinetic;
                Block block = firstState.m_60734_();
                if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                    axis = kinetic.getRotationAxis(firstState);
                }
            }
            if (axis == Direction.Axis.Y) {
                return;
            }
            HitResult rayTrace = Minecraft.m_91087_().f_91077_;
            if (rayTrace == null || !(rayTrace instanceof BlockHitResult)) {
                if (RANDOM.nextInt(50) == 0) {
                    level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)first.m_123341_() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), (double)((float)first.m_123342_() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), (double)((float)first.m_123343_() + 0.5f + WalkwayConnectorHandler.randomOffset(0.25f)), 0.0, 0.0, 0.0);
                }
                return;
            }
            BlockPos selected = ((BlockHitResult)rayTrace).m_82425_();
            BlockState secondState = level.m_8055_(selected);
            if (secondState.m_247087_()) {
                return;
            }
            if (!ShaftBlock.isShaft((BlockState)secondState) && !(secondState.m_60734_() instanceof WalkwayBlock)) {
                selected = selected.m_121945_(((BlockHitResult)rayTrace).m_82434_());
            }
            boolean bl = escalator = selected.m_123342_() - first.m_123342_() != 0;
            if (!escalator && !selected.m_123314_((Vec3i)first, (double)walkwayItem.maxWalkwayLength()) || escalator && Math.abs(selected.m_123342_() - first.m_123342_()) > walkwayItem.maxEscalatorHeight()) {
                return;
            }
            boolean canConnect = WalkwayConnectorItem.validateAxis((Level)level, selected) && walkwayItem.canConnect((Level)level, first, selected);
            BlockPos diffPos = selected.m_121996_((Vec3i)first);
            boolean extendingWalkway = Math.abs(axis.m_7863_(diffPos.m_123341_(), diffPos.m_123342_(), diffPos.m_123343_())) == 1;
            Vec3 start = Vec3.m_82528_((Vec3i)first);
            Vec3 end = Vec3.m_82528_((Vec3i)selected);
            Vec3 diff = end.m_82546_(start);
            if (extendingWalkway) {
                List<Object> list = new ArrayList();
                Vec3 extensionOffset = new Vec3((double)axis.m_7863_(diffPos.m_123341_(), 0, 0), 0.0, (double)axis.m_7863_(0, 0, diffPos.m_123343_()));
                BlockEntity blockEntity = level.m_7702_(first);
                if (blockEntity instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                    list = walkwayBE.getAllBlocks();
                } else {
                    blockEntity = level.m_7702_(selected);
                    if (blockEntity instanceof WalkwayBlockEntity) {
                        WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                        list = walkwayBE.getAllBlocks();
                        extensionOffset = extensionOffset.m_82548_();
                    }
                }
                if (list.isEmpty()) {
                    return;
                }
                start = Vec3.m_82528_((Vec3i)((Vec3i)list.get(0)));
                end = Vec3.m_82528_((Vec3i)((Vec3i)list.get(list.size() - 1)));
                diff = end.m_82546_(start);
                start = start.m_82549_(extensionOffset);
            }
            double x = Math.abs(diff.f_82479_);
            double y = Math.abs(diff.f_82480_);
            double z = Math.abs(diff.f_82481_);
            float length = (float)diff.m_82553_();
            Vec3 step = diff.m_82541_();
            for (float f = 0.0f; f < length; f += 0.0625f) {
                Vec3 position = start.m_82549_(step.m_82490_((double)f));
                if (RANDOM.nextInt(10) != 0) continue;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.f_82479_ + 0.5, position.f_82480_ + 0.5, position.f_82481_ + 0.5, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    private static float randomOffset(float range) {
        return (RANDOM.nextFloat() - 0.5f) * 2.0f * range;
    }
}

