/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.NarrowEscalatorBlock;
import rbasamoyai.escalated.walkways.NarrowWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WalkwayTerminalBlock;

public class WalkwayConnectorItem
extends BlockItem {
    private final AbstractWalkwayBlock walkwayBlock;
    private final AbstractWalkwayBlock escalatorBlock;
    private final Set<Block> otherBlocks = new HashSet<Block>();

    public WalkwayConnectorItem(WalkwayTerminalBlock primaryBlock, Item.Properties properties, NarrowWalkwayBlock walkway, NarrowEscalatorBlock escalator, Block ... otherBlocks) {
        super((Block)primaryBlock, properties);
        this.walkwayBlock = walkway;
        this.otherBlocks.add((Block)this.walkwayBlock);
        this.escalatorBlock = escalator;
        this.otherBlocks.add((Block)this.escalatorBlock);
        this.otherBlocks.addAll(Arrays.asList(otherBlocks));
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player playerEntity = context.m_43723_();
        if (playerEntity != null && playerEntity.m_6144_()) {
            context.m_43722_().m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean validAxis = WalkwayConnectorItem.validateAxis(level, pos);
        if (level.f_46443_) {
            return validAxis ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        CompoundTag tag = context.m_43722_().m_41784_();
        BlockPos firstTerminal = null;
        if (!(!tag.m_128441_("FirstTerminal") || WalkwayConnectorItem.validateAxis(level, firstTerminal = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstTerminal"))) && firstTerminal.m_123314_((Vec3i)pos, (double)(this.maxWalkwayLength() * 2)))) {
            tag.m_128473_("FirstTerminal");
            context.m_43722_().m_41751_(tag);
        }
        if (!validAxis || playerEntity == null) {
            return InteractionResult.FAIL;
        }
        if (tag.m_128441_("FirstTerminal")) {
            if (!this.canConnect(level, firstTerminal, pos)) {
                return InteractionResult.FAIL;
            }
            if (firstTerminal != null && !firstTerminal.equals((Object)pos)) {
                this.createSteps(level, firstTerminal, pos);
                EscalatedTriggers.WALKWAY.tryAwardingTo(playerEntity);
                if (!playerEntity.m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
            }
            if (!context.m_43722_().m_41619_()) {
                context.m_43722_().m_41751_(null);
                playerEntity.m_36335_().m_41524_((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        tag.m_128365_("FirstTerminal", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        context.m_43722_().m_41751_(tag);
        playerEntity.m_36335_().m_41524_((Item)this, 5);
        return InteractionResult.SUCCESS;
    }

    public int maxWalkwayLength() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayLength.get();
    }

    public int maxEscalatorHeight() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorHeight.get();
    }

    public int maxWalkwayWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayWidth.get();
    }

    public int maxEscalatorWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorWidth.get();
    }

    public static boolean validateAxis(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return level.m_46749_(pos) && (ShaftBlock.isShaft((BlockState)state) || state.m_60734_() instanceof WalkwayBlock);
    }

    /*
     * WARNING - void declaration
     */
    public boolean canConnect(Level level, BlockPos first, BlockPos second) {
        KineticBlockEntity kbe;
        BlockEntity secondAxis22;
        boolean escalator;
        int y;
        BlockPos diff;
        Direction.Axis shaftAxis;
        block38: {
            block37: {
                if (!level.m_46749_(first) || !level.m_46749_(second)) {
                    return false;
                }
                BlockState firstState = level.m_8055_(first);
                BlockState secondState = level.m_8055_(second);
                shaftAxis = Direction.Axis.Y;
                if (ShaftBlock.isShaft((BlockState)firstState)) {
                    shaftAxis = (Direction.Axis)firstState.m_61143_((Property)BlockStateProperties.f_61365_);
                } else {
                    KineticBlock kinetic;
                    Block block = firstState.m_60734_();
                    if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                        shaftAxis = kinetic.getRotationAxis(firstState);
                    }
                }
                if (shaftAxis == Direction.Axis.Y) {
                    return false;
                }
                diff = second.m_121996_((Vec3i)first);
                int x = diff.m_123341_();
                y = diff.m_123342_();
                int z = diff.m_123343_();
                boolean bl = escalator = y != 0;
                if (Math.abs(shaftAxis.m_7863_(x, y, z)) == 1) {
                    void var21_38;
                    int MAX_WIDTH;
                    BlockPos actualDiff = new BlockPos(shaftAxis.m_7863_(x, 0, 0), 0, shaftAxis.m_7863_(0, 0, z));
                    if (!(ShaftBlock.isShaft((BlockState)firstState) && this.canExtendWalkwayBlock(secondState) || this.canExtendWalkwayBlock(firstState) && ShaftBlock.isShaft((BlockState)secondState))) {
                        return false;
                    }
                    boolean extendingEscalator = ShaftBlock.isShaft((BlockState)firstState) ? ((WalkwayBlock)secondState.m_60734_()).isEscalator(level, secondState, second) : ((WalkwayBlock)firstState.m_60734_()).isEscalator(level, firstState, first);
                    if (!extendingEscalator && y != 0) {
                        return false;
                    }
                    Direction.Axis secondAxis22 = Direction.Axis.Y;
                    if (ShaftBlock.isShaft((BlockState)secondState)) {
                        secondAxis22 = (Direction.Axis)secondState.m_61143_((Property)BlockStateProperties.f_61365_);
                    } else {
                        Block block = secondState.m_60734_();
                        if (block instanceof KineticBlock) {
                            KineticBlock kinetic = (KineticBlock)block;
                            secondAxis22 = kinetic.getRotationAxis(secondState);
                            actualDiff = actualDiff.m_142393_(-1);
                        }
                    }
                    if (shaftAxis != secondAxis22) {
                        return false;
                    }
                    List<Object> list = new ArrayList();
                    float matchSpeed = 0.0f;
                    int width = 1;
                    Object object = level.m_7702_(first);
                    if (object instanceof WalkwayBlockEntity) {
                        WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                        list = walkwayBE.getAllBlocks();
                        matchSpeed = walkwayBE.getTheoreticalSpeed();
                        width = walkwayBE.getWalkwayWidth();
                    } else {
                        object = level.m_7702_(second);
                        if (object instanceof WalkwayBlockEntity) {
                            WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                            list = walkwayBE.getAllBlocks();
                            matchSpeed = walkwayBE.getTheoreticalSpeed();
                            width = walkwayBE.getWalkwayWidth();
                        }
                    }
                    if (list.isEmpty()) {
                        return false;
                    }
                    int sz = list.size();
                    int y1 = ((BlockPos)list.get(0)).m_123342_();
                    for (BlockPos blockPos : list) {
                        if (blockPos.m_123342_() == y1) continue;
                        escalator = true;
                        break;
                    }
                    int n = MAX_WIDTH = escalator ? this.maxEscalatorWidth() : this.maxWalkwayWidth();
                    if (width >= MAX_WIDTH) {
                        return false;
                    }
                    boolean bl2 = false;
                    while (var21_38 < sz) {
                        BlockPos pos = (BlockPos)list.get((int)var21_38);
                        BlockPos destPos = pos.m_121955_((Vec3i)actualDiff);
                        BlockState currentState = level.m_8055_(destPos);
                        boolean correctShaft = ShaftBlock.isShaft((BlockState)currentState) && currentState.m_61143_((Property)BlockStateProperties.f_61365_) == shaftAxis;
                        boolean empty = currentState.m_247087_();
                        if ((var21_38 == false || var21_38 == sz - 1) && !correctShaft || !correctShaft && !empty) {
                            return false;
                        }
                        if (escalator && var21_38 != false && var21_38 != sz - 1 && !empty) {
                            return false;
                        }
                        if (correctShaft) {
                            void kbe2;
                            BlockEntity blockEntity = level.m_7702_(destPos);
                            if (!(blockEntity instanceof KineticBlockEntity)) {
                                return false;
                            }
                            KineticBlockEntity kbe22 = (KineticBlockEntity)blockEntity;
                            float speed2 = kbe2.getTheoreticalSpeed();
                            if (Math.signum(matchSpeed) != Math.signum(speed2) && matchSpeed != 0.0f && speed2 != 0.0f) {
                                return false;
                            }
                        }
                        ++var21_38;
                    }
                    return true;
                }
                if (escalator && Math.abs(second.m_123342_() - first.m_123342_()) > this.maxEscalatorHeight() || !escalator && !second.m_123314_((Vec3i)first, (double)this.maxWalkwayLength())) {
                    return false;
                }
                if (shaftAxis.m_7863_(x, y, z) != 0) {
                    return false;
                }
                if (escalator && Math.abs(x) != Math.abs(y) + 3 && Math.abs(z) != Math.abs(y) + 3) {
                    return false;
                }
                if (!(escalator || Math.abs(x) != 1 && Math.abs(z) != 1)) {
                    return false;
                }
                if (!ShaftBlock.isShaft((BlockState)firstState) || !ShaftBlock.isShaft((BlockState)secondState) || shaftAxis != secondState.m_61143_((Property)BlockStateProperties.f_61365_)) {
                    return false;
                }
                secondAxis22 = level.m_7702_(first);
                if (!(secondAxis22 instanceof KineticBlockEntity)) break block37;
                kbe = (KineticBlockEntity)secondAxis22;
                secondAxis22 = level.m_7702_(second);
                if (secondAxis22 instanceof KineticBlockEntity) break block38;
            }
            return false;
        }
        KineticBlockEntity kbe1 = (KineticBlockEntity)secondAxis22;
        float speed1 = kbe.getTheoreticalSpeed();
        float speed2 = kbe1.getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = BlockPos.m_274561_((double)Math.signum(diff.m_123341_()), (double)Math.signum(diff.m_123342_()), (double)Math.signum(diff.m_123343_()));
        if (escalator) {
            boolean firstLower = y > 0;
            BlockPos lowerPos = firstLower ? first : second;
            BlockPos upperPos = firstLower ? second : first;
            int sgn = firstLower ? 1 : -1;
            ArrayList<BlockPos> arrayList = new ArrayList<BlockPos>();
            lowerPos = lowerPos.m_7918_(sgn * step.m_123341_(), 0, sgn * step.m_123343_());
            arrayList.add(lowerPos);
            arrayList.add(upperPos.m_7918_(sgn * -step.m_123341_(), 0, sgn * -step.m_123343_()));
            upperPos = upperPos.m_7918_(sgn * -step.m_123341_() * 2, 0, sgn * -step.m_123343_() * 2);
            arrayList.add(upperPos);
            for (BlockPos pos : arrayList) {
                BlockState blockState = level.m_8055_(pos);
                if (ShaftBlock.isShaft((BlockState)blockState) && blockState.m_61143_((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis && (pos.equals((Object)lowerPos) || pos.equals((Object)upperPos)) || blockState.m_247087_()) continue;
                return false;
            }
            first = firstLower ? lowerPos : upperPos;
            second = firstLower ? upperPos : lowerPos;
        }
        int LIMIT = 1000;
        BlockPos currentPos = first.m_121955_((Vec3i)step);
        while (!currentPos.equals((Object)second) && LIMIT-- > 0) {
            BlockState blockState = level.m_8055_(currentPos);
            if (!(!escalator && ShaftBlock.isShaft((BlockState)blockState) && blockState.m_61143_((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis || blockState.m_247087_())) {
                return false;
            }
            currentPos = currentPos.m_121955_((Vec3i)step);
        }
        return true;
    }

    public void createSteps(Level level, BlockPos start, BlockPos end) {
        level.m_5594_(null, BlockPos.m_274446_((Position)VecHelper.getCenterOf((Vec3i)start.m_121955_((Vec3i)end)).m_82490_(0.5)), this.getPlaceSoundEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
        BlockPos diff = end.m_121996_((Vec3i)start);
        int x = diff.m_123341_();
        int y = diff.m_123342_();
        int z = diff.m_123343_();
        boolean escalator = y != 0;
        BlockState firstState = level.m_8055_(start);
        Direction.Axis shaftAxis = Direction.Axis.Y;
        if (ShaftBlock.isShaft((BlockState)firstState)) {
            shaftAxis = (Direction.Axis)firstState.m_61143_((Property)BlockStateProperties.f_61365_);
        } else {
            KineticBlock kinetic;
            Block block = firstState.m_60734_();
            if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                shaftAxis = kinetic.getRotationAxis(firstState);
            }
        }
        if (shaftAxis == Direction.Axis.Y) {
            return;
        }
        if (Math.abs(shaftAxis.m_7863_(x, y, z)) == 1) {
            BlockState aboveSrcState;
            BlockPos aboveSrcPos;
            BlockPos destPos;
            BlockPos srcPos;
            int i;
            BlockPos actualDiff = new BlockPos(shaftAxis.m_7863_(x, 0, 0), 0, shaftAxis.m_7863_(0, 0, z));
            List<Object> list = new ArrayList();
            BlockPos referencePos = start;
            BlockEntity blockEntity = level.m_7702_(start);
            if (blockEntity instanceof WalkwayBlockEntity) {
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                list = walkwayBE.getAllBlocks();
                referencePos = walkwayBE.widthReferencePos;
            } else {
                blockEntity = level.m_7702_(end);
                if (blockEntity instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                    list = walkwayBE.getAllBlocks();
                    actualDiff = actualDiff.m_142393_(-1);
                    referencePos = walkwayBE.widthReferencePos;
                }
            }
            if (list.isEmpty()) {
                return;
            }
            Collections.reverse(list);
            int sz = list.size();
            Direction face = Direction.m_122372_((float)actualDiff.m_123341_(), (float)actualDiff.m_123342_(), (float)actualDiff.m_123343_());
            for (i = 0; i < sz; ++i) {
                boolean left;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.m_121955_((Vec3i)actualDiff);
                BlockState srcState = level.m_8055_(srcPos);
                BlockState destState = level.m_8055_(destPos);
                boolean isShaft = ShaftBlock.isShaft((BlockState)destState);
                Block block = srcState.m_60734_();
                if (!(block instanceof WalkwayBlock)) continue;
                WalkwayBlock walkwaySrc = (WalkwayBlock)block;
                block = level.m_7702_(srcPos);
                if (!(block instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)block;
                DyeColor color = walkwayBE.getColor();
                float visualProgress = walkwayBE.getVisualProgress();
                Direction walkwayFacing = walkwaySrc.getFacing(srcState);
                boolean bl = left = walkwayFacing.m_122428_() == face;
                if (i == 0 || i == sz - 1) {
                    left = !left;
                }
                boolean srcShaft = walkwaySrc.hasWalkwayShaft(srcState);
                BlockState replaceSrcState = walkwaySrc.transformFromMerge(level, srcState, srcPos, left, srcShaft, false, true);
                BlockState placeState = walkwaySrc.transformFromMerge(level, srcState, srcPos, !left, isShaft, false, false);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)srcPos, (BlockState)replaceSrcState);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)destPos, (BlockState)placeState);
                BlockEntity blockEntity2 = level.m_7702_(srcPos);
                if (blockEntity2 instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity newWalkwayBE = (WalkwayBlockEntity)blockEntity2;
                    newWalkwayBE.applyColor(color);
                    newWalkwayBE.setVisualProgress(visualProgress);
                    newWalkwayBE.widthReferencePos = referencePos;
                    newWalkwayBE.resetClientRender = true;
                    newWalkwayBE.notifyUpdate();
                }
                if (!((blockEntity2 = level.m_7702_(destPos)) instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity destWalkwayBE = (WalkwayBlockEntity)blockEntity2;
                destWalkwayBE.applyColor(color);
                destWalkwayBE.setVisualProgress(visualProgress);
                destWalkwayBE.widthReferencePos = referencePos;
                destWalkwayBE.resetClientRender = true;
                destWalkwayBE.notifyUpdate();
            }
            for (i = 0; i < sz; ++i) {
                BlockPos aboveDestPos;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.m_121955_((Vec3i)actualDiff);
                aboveSrcPos = srcPos.m_7494_();
                aboveSrcState = level.m_8055_(aboveSrcPos);
                if (!(aboveSrcState.m_60734_() instanceof AbstractHandrailBlock) || level.m_8055_(aboveDestPos = destPos.m_7494_()).m_247087_()) continue;
                level.m_46961_(aboveSrcPos, true);
                return;
            }
            for (i = 0; i < sz; ++i) {
                BlockPos oppositePos;
                BlockEntity blockEntity3;
                HandrailBlockEntity handrailBE;
                AbstractHandrailBlock.Side srcSide;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.m_121955_((Vec3i)actualDiff);
                aboveSrcPos = srcPos.m_7494_();
                aboveSrcState = level.m_8055_(aboveSrcPos);
                if (!(aboveSrcState.m_60734_() instanceof AbstractHandrailBlock)) continue;
                BlockPos aboveDestPos = destPos.m_7494_();
                int width = 1;
                Direction forward = (Direction)aboveSrcState.m_61143_((Property)AbstractHandrailBlock.f_54117_);
                Direction handrailLeft = forward.m_122428_();
                if (aboveSrcState.m_61143_(AbstractHandrailBlock.SIDE) == AbstractHandrailBlock.Side.BOTH) {
                    AbstractHandrailBlock.Side destSide = face == handrailLeft ? AbstractHandrailBlock.Side.LEFT : AbstractHandrailBlock.Side.RIGHT;
                    srcSide = destSide == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                    level.m_7731_(aboveSrcPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)aboveSrcState.m_61124_(AbstractHandrailBlock.SIDE, (Comparable)((Object)srcSide))), (BlockPos)aboveSrcPos), 3);
                    level.m_7731_(aboveDestPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)aboveSrcState.m_61124_(AbstractHandrailBlock.SIDE, (Comparable)((Object)destSide))), (BlockPos)aboveDestPos), 3);
                } else {
                    level.m_7731_(aboveDestPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)aboveSrcState, (BlockPos)aboveDestPos), 3);
                    srcSide = level.m_7702_(aboveSrcPos);
                    if (srcSide instanceof HandrailBlockEntity) {
                        handrailBE = (HandrailBlockEntity)((Object)srcSide);
                        handrailBE.propagateBreak = false;
                        width = handrailBE.width;
                    }
                    level.m_7731_(aboveSrcPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.f_50016_.m_49966_(), (BlockPos)aboveSrcPos), 3);
                }
                ++width;
                srcSide = level.m_7702_(aboveDestPos);
                if (srcSide instanceof HandrailBlockEntity) {
                    handrailBE = (HandrailBlockEntity)((Object)srcSide);
                    handrailBE.width = width;
                }
                if (!((blockEntity3 = level.m_7702_(oppositePos = aboveDestPos.m_5484_(face.m_122424_(), width - 1))) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)blockEntity3;
                handrailBE2.width = width;
            }
            return;
        }
        Direction facing = WalkwayConnectorItem.getFacingFromTo(start, end);
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)start, (BlockState)((BlockState)this.m_40614_().m_49966_().m_61124_(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing)));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)end, (BlockState)((BlockState)this.m_40614_().m_49966_().m_61124_(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing.m_122424_())));
        List<BlockPos> walkwaysToCreate = WalkwayConnectorItem.getWalkwayChainBetween(start, end, escalator, facing);
        if (escalator && end.m_121996_((Vec3i)start).m_123342_() <= 0) {
            facing = facing.m_122424_();
        }
        boolean failed = false;
        for (BlockPos pos : walkwaysToCreate) {
            BlockState existingBlock = level.m_8055_(pos);
            if (existingBlock.m_60800_((BlockGetter)level, pos) == -1.0f) {
                failed = true;
                break;
            }
            BlockState shaftState = level.m_8055_(pos);
            boolean existingShaft = ShaftBlock.isShaft((BlockState)shaftState);
            if (!existingBlock.m_247087_()) {
                level.m_46961_(pos, false);
            }
            BlockState placeState = this.getPlacedWalkwayBlock(escalator, facing, existingShaft);
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)placeState);
        }
        if (!failed) {
            if (escalator) {
                boolean firstLower = end.m_121996_((Vec3i)start).m_123342_() > 0;
                BlockPos lowerPos = firstLower ? start : end;
                BlockPos upperPos = firstLower ? end : start;
                BlockPos horizontalPos = upperPos.m_5484_(facing, -1);
                BlockState horizontalState = level.m_8055_(horizontalPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)horizontalPos, (BlockState)((BlockState)horizontalState.m_61124_(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.HORIZONTAL))));
                BlockPos topPos = upperPos.m_5484_(facing, -2);
                BlockState topState = level.m_8055_(topPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)topPos, (BlockState)((BlockState)topState.m_61124_(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.TOP))));
                BlockPos bottomPos = lowerPos.m_121945_(facing);
                BlockState bottomState = level.m_8055_(bottomPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)bottomPos, (BlockState)((BlockState)bottomState.m_61124_(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.BOTTOM))));
            }
            return;
        }
        for (BlockPos pos : walkwaysToCreate) {
            BlockState failedState = level.m_8055_(pos);
            if (!(failedState.m_60734_() instanceof WalkwayBlock)) continue;
            level.m_46961_(pos, false);
        }
    }

    protected BlockState getPlacedWalkwayBlock(boolean escalator, Direction facing, boolean shaft) {
        if (escalator) {
            return (BlockState)((BlockState)this.escalatorBlock.m_49966_().m_61124_((Property)AbstractWalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.MIDDLE))).m_61124_(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing);
        }
        return (BlockState)((BlockState)this.walkwayBlock.m_49966_().m_61124_(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing)).m_61124_(WalkwayBlock.CAPS, (Comparable)((Object)(shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT)));
    }

    protected SoundEvent getPlaceSoundEvent() {
        return SoundEvents.f_11745_;
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.m_123341_() == end.m_123341_() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.m_121996_((Vec3i)start);
        Direction.AxisDirection axisDirection = beltAxis.m_7863_(diff.m_123341_(), 0, diff.m_123343_()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        return Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)beltAxis);
    }

    private static List<BlockPos> getWalkwayChainBetween(BlockPos start, BlockPos end, boolean escalator, Direction direction) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        if (escalator) {
            BlockPos upperPos;
            boolean firstLower = end.m_121996_((Vec3i)start).m_123342_() > 0;
            BlockPos lowerPos = firstLower ? start : end;
            BlockPos blockPos = upperPos = firstLower ? end : start;
            if (!firstLower) {
                direction = direction.m_122424_();
            }
            positions.add(upperPos.m_5484_(direction, -1));
            positions.add(upperPos.m_5484_(direction, -2));
            start = lowerPos.m_121945_(direction);
            end = upperPos.m_5484_(direction, -2);
        }
        BlockPos current = start;
        do {
            positions.add(current);
            current = current.m_121945_(direction);
            if (!escalator) continue;
            current = current.m_7494_();
        } while (!current.equals((Object)end) && limit-- > 0);
        if (!escalator) {
            positions.remove(start);
        }
        return positions;
    }

    public void m_6192_(Map<Block, Item> map, Item item) {
        super.m_6192_(map, item);
        for (Block b : this.otherBlocks) {
            map.put(b, item);
        }
    }

    protected boolean canExtendWalkwayBlock(BlockState state) {
        return state.m_60713_(this.m_40614_()) || this.otherBlocks.contains(state.m_60734_());
    }
}

