/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.fluid;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedFluidHandlerItemStack
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final String FLUID_NBT_KEY = "Fluid";
    private Predicate<FluidStack> isFluidValid = stack -> true;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @NotNull
    protected ItemStack container;
    protected int capacity;

    public RestrictedFluidHandlerItemStack(ItemStack container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }

    public RestrictedFluidHandlerItemStack setValidator(Predicate<FluidStack> isFluidValid) {
        this.isFluidValid = isFluidValid;
        return this;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid.test(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.isFluidValid(1, resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.capacity, resource.getAmount());
            if (action.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (resource.isFluidEqual(contained)) {
            int fillAmount = Math.min(this.capacity - contained.getAmount(), resource.getAmount());
            if (action.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.getFluid().isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidStack drained = contained.copy();
        drained.setAmount(drainAmount);
        if (action.execute()) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, this.holder);
    }

    @NotNull
    public FluidStack getFluid() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_(FLUID_NBT_KEY)) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_(FLUID_NBT_KEY));
    }

    public void setFluid(FluidStack fluid) {
        if (!this.container.m_41782_()) {
            this.container.m_41751_(new CompoundTag());
        }
        CompoundTag fluidTag = new CompoundTag();
        fluid.writeToNBT(fluidTag);
        this.container.m_41783_().m_128365_(FLUID_NBT_KEY, (Tag)fluidTag);
    }

    public void setContainerToEmpty() {
        this.container.m_41749_(FLUID_NBT_KEY);
    }

    public static class SwapEmpty
    extends RestrictedFluidHandlerItemStack {
        public final ItemStack emptyContainer;

        public SwapEmpty(ItemStack container, ItemStack emptyContainer, int capacity) {
            super(container, capacity);
            this.emptyContainer = emptyContainer;
        }

        @Override
        public void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container = this.emptyContainer;
        }
    }

    public static class Consumable
    extends RestrictedFluidHandlerItemStack {
        public Consumable(ItemStack container, int capacity) {
            super(container, capacity);
        }

        @Override
        public void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container.m_41774_(1);
        }
    }
}

