/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.gas;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;

public class PropertyGasTank
extends GasTank {
    protected GenericTile holder;
    protected SingleProperty<GasStack> gasProperty;
    protected SingleProperty<Integer> capacityProperty;
    protected SingleProperty<Integer> maxTemperatureProperty;
    protected SingleProperty<Integer> maxPressureProperty;
    protected BiConsumer<GasTank, GenericTile> onGasCondensed;

    public PropertyGasTank(GenericTile holder, String key, int capacity, int maxTemperature, int maxPressure) {
        super(capacity, maxTemperature, maxPressure);
        this.onGasCondensed = (gas, tile) -> {};
        this.holder = holder;
        this.gasProperty = holder.property(new SingleProperty<GasStack>(PropertyTypes.GAS_STACK, "propertygastankstack" + key, GasStack.EMPTY));
        this.capacityProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankcapacity" + key, Integer.valueOf(capacity)));
        this.maxTemperatureProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankmaxtemperature" + key, Integer.valueOf(maxTemperature)));
        this.maxPressureProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankmaxpressure" + key, Integer.valueOf(maxPressure)));
    }

    public PropertyGasTank(GenericTile holder, String key, int capacity, int maxTemperature, int maxPressure, Predicate<GasStack> isGasValid) {
        super(capacity, maxTemperature, maxPressure, isGasValid);
        this.onGasCondensed = (gas, tile) -> {};
        this.holder = holder;
        this.gasProperty = holder.property(new SingleProperty<GasStack>(PropertyTypes.GAS_STACK, "propertygastankstack" + key, GasStack.EMPTY));
        this.capacityProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankcapacity" + key, Integer.valueOf(capacity)));
        this.maxTemperatureProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankmaxtemperature" + key, Integer.valueOf(maxTemperature)));
        this.maxPressureProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertygastankmaxpressure" + key, Integer.valueOf(maxPressure)));
    }

    protected PropertyGasTank(PropertyGasTank other) {
        super(other.getCapacity(), other.getMaxTemperature(), other.getMaxPressure(), other.isGasValid);
        this.onGasCondensed = (gas, tile) -> {};
        this.holder = other.holder;
        this.gasProperty = other.gasProperty;
        this.capacityProperty = other.capacityProperty;
        this.maxTemperatureProperty = other.maxTemperatureProperty;
        this.maxPressureProperty = other.maxPressureProperty;
    }

    @Override
    public PropertyGasTank setValidator(Predicate<GasStack> predicate) {
        return (PropertyGasTank)super.setValidator(predicate);
    }

    public PropertyGasTank setOnGasCondensed(BiConsumer<GasTank, GenericTile> onGasCondensed) {
        this.onGasCondensed = onGasCondensed;
        return this;
    }

    @Override
    public void setGas(GasStack gas) {
        this.gasProperty.setValue(gas);
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacityProperty.setValue(capacity);
    }

    @Override
    public void setMaxTemperature(int temperature) {
        this.maxTemperatureProperty.setValue(temperature);
    }

    @Override
    public void setMaxPressure(int atm) {
        this.maxPressureProperty.setValue(atm);
    }

    @Override
    public GasStack getGas() {
        return (GasStack)this.gasProperty.getValue();
    }

    @Override
    public int getGasAmount() {
        return this.getGas().getAmount();
    }

    @Override
    public int getCapacity() {
        return (Integer)this.capacityProperty.getValue();
    }

    @Override
    public int getMaxTemperature() {
        return (Integer)this.maxTemperatureProperty.getValue();
    }

    @Override
    public int getMaxPressure() {
        return (Integer)this.maxPressureProperty.getValue();
    }

    @Override
    public void onChange() {
        if (this.holder != null) {
            this.gasProperty.forceDirtyForManager();
            this.holder.onGasTankChange(this);
        }
    }

    @Override
    public void onOverheat() {
        if (this.holder != null) {
            Level world = this.holder.m_58904_();
            BlockPos pos = this.holder.m_58899_();
            world.m_46597_(pos, Blocks.f_49991_.m_49966_());
        }
    }

    @Override
    public void onOverpressure() {
        if (this.holder != null) {
            Level world = this.holder.m_58904_();
            BlockPos pos = this.holder.m_58899_();
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, Level.ExplosionInteraction.BLOCK);
        }
    }

    @Override
    public void onGasCondensed() {
        if (this.holder != null) {
            this.onGasCondensed.accept(this, this.holder);
        }
    }

    public PropertyGasTank[] asArray() {
        return new PropertyGasTank[]{this};
    }
}

