/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.inventory;

import java.util.function.IntUnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import voltaic.prefab.tile.components.type.ComponentInventory;

public class IndexedSidedInvWrapper
implements IItemHandlerModifiable {
    public ComponentInventory inv;
    @Nullable
    protected final Direction side;
    private final IntUnaryOperator slotLimit;
    private final InsertLimit newStackInsertLimit;

    public IndexedSidedInvWrapper(ComponentInventory inv, @Nullable Direction side) {
        this.inv = inv;
        this.side = side;
        this.slotLimit = wrapperSlot -> inv.m_6893_();
        this.newStackInsertLimit = (wrapperSlot, invSlot, stack) -> Math.min(stack.m_41741_(), this.getSlotLimit(wrapperSlot));
    }

    public static IItemHandlerModifiable[] create(ComponentInventory inv, Direction ... sides) {
        IItemHandlerModifiable[] ret = new IItemHandlerModifiable[sides.length];
        for (int x = 0; x < sides.length; ++x) {
            Direction side = sides[x];
            ret[x] = new IndexedSidedInvWrapper(inv, side);
        }
        return ret;
    }

    public static int getSlot(WorldlyContainer inv, int slot, @Nullable Direction side) {
        int[] slots = inv.m_7071_(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedSidedInvWrapper that = (IndexedSidedInvWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
        return result;
    }

    public int getSlots() {
        return this.inv.m_7071_(this.side).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = IndexedSidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? ItemStack.f_41583_ : this.inv.m_8020_(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int slot1 = IndexedSidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.m_8020_(slot1);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.inv.m_7155_(slot1, stack, this.side) || !this.inv.m_7013_(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.inv.m_7155_(slot1, stack, this.side) || !this.inv.m_7013_(slot1, stack)) {
            return stack;
        }
        int m = this.newStackInsertLimit.limitInsert(slot, slot1, stack);
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.m_41620_(m));
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int slot1 = IndexedSidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 != -1) {
            this.setInventorySlotContents(slot1, stack);
        }
    }

    private void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.m_6836_(slot, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        int slot1 = IndexedSidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.inv.m_8020_(slot1);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.inv.m_7157_(slot1, stackInSlot, this.side)) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack ret = this.inv.m_7407_(slot1, m);
        this.inv.m_6596_();
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit.applyAsInt(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int slot1 = IndexedSidedInvWrapper.getSlot(this.inv, slot, this.side);
        return slot1 == -1 ? false : this.inv.m_7013_(slot1, stack);
    }

    private static interface InsertLimit {
        public int limitInsert(int var1, int var2, ItemStack var3);
    }
}

