/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.misc.ILocationStorage;
import voltaic.prefab.utilities.object.Location;
import voltaic.registers.VoltaicCapabilities;

public class CapabilityLocationStorage
implements ILocationStorage,
ICapabilitySerializable<CompoundTag> {
    public final LazyOptional<ILocationStorage> holder = LazyOptional.of(() -> this);
    private final List<Location> locations = new ArrayList<Location>();

    public CapabilityLocationStorage(int size) {
        for (int i = 0; i < size; ++i) {
            this.locations.add(new Location(0.0, 0.0, 0.0));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_LOCATIONSTORAGE_ITEM) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (VoltaicCapabilities.CAPABILITY_LOCATIONSTORAGE_ITEM != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("size", this.locations.size());
            for (int i = 0; i < this.locations.size(); ++i) {
                this.locations.get(i).writeToNBT(nbt, "location" + i);
            }
            return nbt;
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (VoltaicCapabilities.CAPABILITY_LOCATIONSTORAGE_ITEM != null) {
            this.locations.clear();
            for (int i = 0; i < nbt.m_128451_("size"); ++i) {
                this.locations.add(Location.readFromNBT(nbt, "location" + i));
            }
        }
    }

    @Override
    public void setLocation(int index, double x, double y, double z) {
        this.locations.set(index, new Location(x, y, z));
    }

    @Override
    public Location getLocation(int index) {
        return this.locations.get(index);
    }

    @Override
    public void addLocation(double x, double y, double z) {
        this.locations.add(new Location(x, y, z));
    }

    @Override
    public void removeLocation(Location location) {
        this.locations.remove(location);
    }

    @Override
    public void clearLocations() {
        this.locations.clear();
    }

    @Override
    public List<Location> getLocations() {
        return this.locations;
    }
}

