/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.radiation;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.api.radiation.util.IRadiationManager;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.api.radiation.util.RadiationShielding;
import voltaic.common.reloadlistener.RadiationShieldingRegister;
import voltaic.common.settings.VoltaicConstants;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.CodecUtils;
import voltaic.registers.VoltaicCapabilities;

public class RadiationManager
implements IRadiationManager,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IRadiationManager> lazyOptional = LazyOptional.of(() -> this);
    private final HashMap<BlockPos, SimpleRadiationSource> permanentSources = new HashMap();
    private final HashMap<BlockPos, IRadiationManager.TemporaryRadiationSource> temporarySources = new HashMap();
    private final HashMap<BlockPos, IRadiationManager.FadingRadiationSource> fadingSources = new HashMap();
    private final HashMap<AABB, Double> localizedDissipations = new HashMap();
    private double defaultRadiationDisipation = VoltaicConstants.BACKROUND_RADIATION_DISSIPATION;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag total = new CompoundTag();
        CompoundTag permanent = new CompoundTag();
        int size = this.permanentSources.size();
        permanent.m_128405_("size", size);
        int i = 0;
        for (Map.Entry<BlockPos, SimpleRadiationSource> entry : this.permanentSources.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("pos", tag));
            SimpleRadiationSource.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue()).result().ifPresent(tag -> store.m_128365_("radiation", tag));
            permanent.m_128365_("" + i, (Tag)compoundTag);
            ++i;
        }
        total.m_128365_("permanentradiationsources", (Tag)permanent);
        CompoundTag temporary = new CompoundTag();
        size = this.temporarySources.size();
        temporary.m_128405_("size", size);
        i = 0;
        for (Map.Entry<BlockPos, IRadiationManager.TemporaryRadiationSource> entry : this.temporarySources.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("pos", tag));
            IRadiationManager.TemporaryRadiationSource.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue()).result().ifPresent(tag -> store.m_128365_("radiation", tag));
            temporary.m_128365_("" + i, (Tag)compoundTag);
            ++i;
        }
        total.m_128365_("temporaryradiationsources", (Tag)temporary);
        CompoundTag compoundTag = new CompoundTag();
        size = this.fadingSources.size();
        compoundTag.m_128405_("size", size);
        i = 0;
        for (Map.Entry<BlockPos, IRadiationManager.FadingRadiationSource> entry : this.fadingSources.entrySet()) {
            CompoundTag store = new CompoundTag();
            BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("pos", tag));
            IRadiationManager.FadingRadiationSource.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue()).result().ifPresent(tag -> store.m_128365_("radiation", tag));
            compoundTag.m_128365_("" + i, (Tag)store);
            ++i;
        }
        total.m_128365_("fadingradiationsources", (Tag)compoundTag);
        CompoundTag compoundTag2 = new CompoundTag();
        size = this.localizedDissipations.size();
        compoundTag2.m_128405_("size", size);
        i = 0;
        for (Map.Entry<AABB, Double> entry : this.localizedDissipations.entrySet()) {
            CompoundTag store = new CompoundTag();
            CodecUtils.AABB_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("pos", tag));
            store.m_128347_("amount", entry.getValue().doubleValue());
            compoundTag2.m_128365_("" + i, (Tag)store);
            ++i;
        }
        total.m_128365_("localizeddissipations", (Tag)compoundTag2);
        total.m_128347_("defaultdissipation", this.defaultRadiationDisipation);
        return total;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER == null || !nbt.m_128441_("permanentradiationsources")) {
            return;
        }
        CompoundTag permanent = nbt.m_128469_("permanentradiationsources");
        this.permanentSources.clear();
        int size = permanent.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = permanent.m_128469_("" + i);
            this.permanentSources.put((BlockPos)BlockPos.f_121852_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("pos"))).result().get(), (SimpleRadiationSource)SimpleRadiationSource.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128469_("radiation"))).result().get());
        }
        this.temporarySources.clear();
        CompoundTag temporary = nbt.m_128469_("temporaryradiationsources");
        size = temporary.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = temporary.m_128469_("" + i);
            this.temporarySources.put((BlockPos)BlockPos.f_121852_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("pos"))).result().get(), (IRadiationManager.TemporaryRadiationSource)IRadiationManager.TemporaryRadiationSource.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128469_("radiation"))).result().get());
        }
        this.fadingSources.clear();
        CompoundTag fading = nbt.m_128469_("temporaryradiationsources");
        size = fading.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = fading.m_128469_("" + i);
            this.fadingSources.put((BlockPos)BlockPos.f_121852_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("pos"))).result().get(), (IRadiationManager.FadingRadiationSource)IRadiationManager.FadingRadiationSource.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128469_("radiation"))).result().get());
        }
        this.localizedDissipations.clear();
        CompoundTag localized = nbt.m_128469_("localizeddissipations");
        size = localized.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = localized.m_128469_("" + i);
            this.localizedDissipations.put((AABB)CodecUtils.AABB_CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("pos"))).result().get(), stored.m_128459_("amount"));
        }
        this.defaultRadiationDisipation = nbt.m_128459_("defaultdissipation");
    }

    @Override
    public List<SimpleRadiationSource> getPermanentSources(Level world) {
        return new ArrayList<SimpleRadiationSource>(this.permanentSources.values());
    }

    @Override
    public List<IRadiationManager.TemporaryRadiationSource> getTemporarySources(Level world) {
        return new ArrayList<IRadiationManager.TemporaryRadiationSource>(this.temporarySources.values());
    }

    @Override
    public List<IRadiationManager.FadingRadiationSource> getFadingSources(Level world) {
        return new ArrayList<IRadiationManager.FadingRadiationSource>(this.fadingSources.values());
    }

    @Override
    public List<BlockPos> getPermanentLocations(Level world) {
        return new ArrayList<BlockPos>(this.permanentSources.keySet());
    }

    @Override
    public List<BlockPos> getTemporaryLocations(Level world) {
        return new ArrayList<BlockPos>(this.temporarySources.keySet());
    }

    @Override
    public List<BlockPos> getFadingLocations(Level world) {
        return new ArrayList<BlockPos>(this.fadingSources.keySet());
    }

    @Override
    public void addRadiationSource(SimpleRadiationSource source, Level world) {
        if (source.isTemporary()) {
            if (source.shouldCombine()) {
                IRadiationManager.TemporaryRadiationSource existing = this.temporarySources.getOrDefault(source.getSourceLocation(), IRadiationManager.TemporaryRadiationSource.NONE);
                IRadiationManager.TemporaryRadiationSource combined = new IRadiationManager.TemporaryRadiationSource(source.ticks() + existing.ticks, Math.max(source.getRadiationStrength(), existing.strength), source.getRadiationAmount() + existing.radiation, existing.leaveFading || source.shouldLeaveLingeringSource(), Math.max(source.distance(), existing.distance), source.getSourceLocation());
                this.temporarySources.put(source.getSourceLocation(), combined);
            } else {
                this.temporarySources.put(source.getSourceLocation(), new IRadiationManager.TemporaryRadiationSource(source.ticks(), source.strength(), source.amount(), source.shouldLeaveLingeringSource(), source.distance(), source.getSourceLocation()));
            }
        } else if (source.shouldCombine()) {
            SimpleRadiationSource existing = this.permanentSources.getOrDefault(source.getSourceLocation(), SimpleRadiationSource.NONE);
            this.permanentSources.put(source.getSourceLocation(), new SimpleRadiationSource(existing.getRadiationAmount() + source.getRadiationAmount(), Math.max(existing.getRadiationStrength(), source.getRadiationStrength()), Math.max(existing.getDistanceSpread(), source.getDistanceSpread()), false, existing.getPersistanceTicks() + source.getPersistanceTicks(), source.getSourceLocation(), existing.shouldLinger() || source.shouldLinger(), existing.shouldCombine() || source.shouldCombine()));
        } else {
            this.permanentSources.put(source.getSourceLocation(), source);
        }
    }

    @Override
    public int getReachOfSource(Level world, BlockPos pos) {
        return Math.max(this.temporarySources.getOrDefault((Object)pos, (IRadiationManager.TemporaryRadiationSource)IRadiationManager.TemporaryRadiationSource.NONE).distance, Math.max(this.permanentSources.getOrDefault(pos, SimpleRadiationSource.NONE).getDistanceSpread(), this.fadingSources.getOrDefault((Object)pos, (IRadiationManager.FadingRadiationSource)IRadiationManager.FadingRadiationSource.NONE).distance));
    }

    @Override
    public void setDisipation(double radiationDisipation, Level world) {
        this.defaultRadiationDisipation = radiationDisipation;
    }

    @Override
    public void setLocalizedDisipation(double disipation, AABB area, Level world) {
        this.localizedDissipations.put(area, disipation + this.localizedDissipations.getOrDefault(area, 0.0));
    }

    @Override
    public void removeLocalizedDisipation(AABB area, Level world) {
        this.localizedDissipations.remove(area);
    }

    @Override
    public boolean removeRadiationSource(BlockPos pos, boolean shouldLeaveFadingSource, Level world) {
        SimpleRadiationSource source = this.permanentSources.remove(pos);
        if (source == null) {
            return false;
        }
        if (shouldLeaveFadingSource) {
            this.fadingSources.put(pos, new IRadiationManager.FadingRadiationSource(source.getDistanceSpread(), source.getRadiationStrength(), source.getRadiationAmount(), pos));
        }
        return true;
    }

    @Override
    public void wipeAllSources(Level level) {
        this.permanentSources.clear();
        this.temporarySources.clear();
        this.fadingSources.clear();
    }

    @Override
    public void tick(Level world) {
        IRadiationManager.FadingRadiationSource fadingSource;
        IRadiationManager.TemporaryRadiationSource temporarySource;
        BlockPos position;
        for (Entity entity : ((ServerLevel)world).m_8583_()) {
            int i;
            IRadiationRecipient capability;
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6084_() || (capability = (IRadiationRecipient)living.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT)) == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) continue;
            for (Map.Entry<BlockPos, SimpleRadiationSource> entry : this.permanentSources.entrySet()) {
                position = entry.getKey();
                SimpleRadiationSource permanentSource = entry.getValue();
                if (!living.m_20191_().m_82381_(permanentSource.getBoundingBox())) continue;
                for (i = 0; i < (int)Math.ceil(living.m_20206_()); ++i) {
                    capability.recieveRadiation(living, RadiationManager.getAppliedRadiation(world, position, living.m_20097_().m_6630_(i + 1), permanentSource.getRadiationAmount(), permanentSource.getRadiationStrength()), permanentSource.getRadiationStrength());
                }
            }
            for (Map.Entry<BlockPos, Object> entry : this.temporarySources.entrySet()) {
                position = entry.getKey();
                temporarySource = (IRadiationManager.TemporaryRadiationSource)entry.getValue();
                if (!living.m_20191_().m_82381_(temporarySource.boundingBox)) continue;
                for (i = 0; i < (int)Math.ceil(living.m_20206_()); ++i) {
                    capability.recieveRadiation(living, RadiationManager.getAppliedRadiation(world, position, living.m_20097_().m_6630_(i + 1), temporarySource.radiation, temporarySource.strength), temporarySource.strength);
                }
            }
            for (Map.Entry<BlockPos, Object> entry : this.fadingSources.entrySet()) {
                position = entry.getKey();
                fadingSource = (IRadiationManager.FadingRadiationSource)entry.getValue();
                if (!living.m_20191_().m_82381_(fadingSource.boundingBox)) continue;
                for (i = 0; i < (int)Math.ceil(living.m_20206_()); ++i) {
                    capability.recieveRadiation(living, RadiationManager.getAppliedRadiation(world, position, living.m_20097_().m_6630_(i + 1), fadingSource.radiation, fadingSource.strength), fadingSource.strength);
                }
            }
        }
        Iterator<Map.Entry<BlockPos, IRadiationManager.TemporaryRadiationSource>> iteratorTemp = this.temporarySources.entrySet().iterator();
        while (iteratorTemp.hasNext()) {
            Map.Entry<BlockPos, IRadiationManager.TemporaryRadiationSource> entryTemp = iteratorTemp.next();
            position = entryTemp.getKey();
            temporarySource = entryTemp.getValue();
            --temporarySource.ticks;
            if (temporarySource.ticks >= 0) continue;
            iteratorTemp.remove();
            if (!temporarySource.leaveFading) continue;
            IRadiationManager.FadingRadiationSource fadingRadiationSource = this.fadingSources.getOrDefault(position, IRadiationManager.FadingRadiationSource.NONE);
            this.fadingSources.put(position, new IRadiationManager.FadingRadiationSource(Math.max(temporarySource.distance, fadingRadiationSource.distance), Math.max(temporarySource.strength, fadingRadiationSource.strength), Math.max(temporarySource.radiation, fadingRadiationSource.radiation), position));
        }
        Iterator<Map.Entry<BlockPos, IRadiationManager.FadingRadiationSource>> iterator = this.fadingSources.entrySet().iterator();
        boolean hit = false;
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, IRadiationManager.FadingRadiationSource> entryFading = iterator.next();
            fadingSource = entryFading.getValue();
            for (Map.Entry<AABB, Double> localized : this.localizedDissipations.entrySet()) {
                if (!localized.getKey().m_82381_(fadingSource.boundingBox)) continue;
                fadingSource.radiation -= localized.getValue().doubleValue();
            }
            fadingSource.radiation -= this.defaultRadiationDisipation;
            if (!(fadingSource.radiation <= 0.0)) continue;
            iterator.remove();
        }
    }

    public static boolean isWithinRange(BlockPos start, BlockPos end, int distance) {
        return Math.abs(end.m_123341_() - start.m_123341_()) <= distance && Math.abs(end.m_123342_() - start.m_123342_()) <= distance && Math.abs(end.m_123343_() - start.m_123343_()) <= distance;
    }

    public static List<Block> raycastToBlockPos(Level world, BlockPos start, BlockPos end) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int deltaX = end.m_123341_() - start.m_123341_();
        int deltaY = end.m_123342_() - start.m_123342_();
        int deltaZ = end.m_123343_() - start.m_123343_();
        double magnitude = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        int maxChecks = (int)magnitude;
        double incX = (double)deltaX / magnitude;
        double incY = (double)deltaY / magnitude;
        double incZ = (double)deltaZ / magnitude;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        BlockPos toCheck = start;
        for (int i = 0; i < maxChecks; ++i) {
            toCheck = new BlockPos((int)((double)start.m_123341_() + (x += incX)), (int)((double)start.m_123342_() + (y += incY)), (int)((double)start.m_123343_() + (z += incZ)));
            if (toCheck.equals((Object)start) || toCheck.equals((Object)end)) continue;
            blocks.add(world.m_8055_(toCheck).m_60734_());
        }
        return blocks;
    }

    public static double getAppliedRadiation(Level world, BlockPos source, BlockPos entity, double amount, double strength) {
        List<Block> blocks = RadiationManager.raycastToBlockPos(world, source, entity);
        if (blocks.isEmpty()) {
            return amount;
        }
        for (Block block : blocks) {
            RadiationShielding shielding = RadiationShieldingRegister.getValue(block);
            if (shielding.level() < strength || !((amount -= shielding.amount()) <= 0.0)) continue;
            return 0.0;
        }
        return amount / entity.m_123331_((Vec3i)source);
    }
}

