/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.guidebook.utils.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import voltaic.client.guidebook.utils.components.Chapter;
import voltaic.client.guidebook.utils.components.Module;
import voltaic.client.guidebook.utils.pagedata.OnClick;
import voltaic.client.guidebook.utils.pagedata.OnKeyPress;
import voltaic.client.guidebook.utils.pagedata.OnTooltip;
import voltaic.client.guidebook.utils.pagedata.graphics.AbstractGraphicWrapper;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class Page {
    private final int pageNumber;
    public List<TextWrapper> text = new ArrayList<TextWrapper>();
    public List<GraphicWrapper> graphics = new ArrayList<GraphicWrapper>();
    public Chapter associatedChapter;
    public List<TextWrapper> tooltipText = new ArrayList<TextWrapper>();
    public List<GraphicWrapper> tooltipGraphics = new ArrayList<GraphicWrapper>();
    public List<TextWrapper> clickText = new ArrayList<TextWrapper>();
    public List<GraphicWrapper> clickGraphics = new ArrayList<GraphicWrapper>();
    public List<TextWrapper> keyPressText = new ArrayList<TextWrapper>();
    public List<GraphicWrapper> keyPressGraphics = new ArrayList<GraphicWrapper>();

    public Page(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPage() {
        return this.pageNumber;
    }

    public void renderAdditionalText(GuiGraphics graphics, int refX, int refY, int xPageShift, Font font, int textWidth, int textStartX) {
        Module currMod = this.associatedChapter.module;
        MutableComponent moduleTitle = currMod.getTitle().m_130940_(ChatFormatting.BOLD);
        int xShift = (textWidth - font.m_92852_((FormattedText)moduleTitle)) / 2;
        graphics.m_280614_(font, (Component)moduleTitle, refX + textStartX + xShift + xPageShift, refY + 16, Color.TEXT_GRAY.color(), false);
        MutableComponent chapTitle = this.associatedChapter.getTitle().m_130940_(ChatFormatting.UNDERLINE);
        xShift = (textWidth - font.m_92852_((FormattedText)chapTitle)) / 2;
        graphics.m_280614_(font, (Component)chapTitle, refX + textStartX + xShift + xPageShift, refY + 26, Color.TEXT_GRAY.color(), false);
        MutableComponent pageNumber = Component.m_237113_((String)("" + (this.getPage() + 1)));
        xShift = (textWidth - font.m_92852_((FormattedText)pageNumber)) / 2;
        graphics.m_280614_(font, (Component)pageNumber, refX + textStartX + xShift + xPageShift, refY + 200, Color.TEXT_GRAY.color(), false);
    }

    public static class CoverPage
    extends Page {
        public CoverPage(int pageNumber) {
            super(pageNumber);
        }

        @Override
        public void renderAdditionalText(GuiGraphics graphics, int refX, int refY, int xPageShift, Font font, int textWidth, int textStartX) {
        }
    }

    public static class ModulePage
    extends Page {
        public ModulePage(int pageNumber) {
            super(pageNumber);
        }

        @Override
        public void renderAdditionalText(GuiGraphics graphics, int refX, int refY, int xPageShift, Font font, int textWidth, int textStartX) {
            MutableComponent modTitle = VoltaicTextUtils.guidebook("availablemodules", new Object[0]).m_130940_(ChatFormatting.BOLD);
            int xShift = (textWidth - font.m_92852_((FormattedText)modTitle)) / 2;
            graphics.m_280614_(font, (Component)modTitle, refX + textStartX + xShift + xPageShift, refY + 16, Color.TEXT_GRAY.color(), false);
        }
    }

    public static class ChapterPage
    extends Page {
        public Module associatedModule;

        public ChapterPage(int pageNumber, Module module) {
            super(pageNumber);
            this.associatedModule = module;
        }

        @Override
        public void renderAdditionalText(GuiGraphics graphics, int refX, int refY, int xPageShift, Font font, int textWidth, int textStartX) {
            Module currMod = this.associatedModule;
            MutableComponent moduleTitle = currMod.getTitle().m_130940_(ChatFormatting.BOLD);
            int xShift = (textWidth - font.m_92852_((FormattedText)moduleTitle)) / 2;
            graphics.m_280614_(font, (Component)moduleTitle, refX + xShift + textStartX + xPageShift, refY + 16, Color.TEXT_GRAY.color(), false);
            MutableComponent chapTitle = VoltaicTextUtils.guidebook("chapters", new Object[0]).m_130940_(ChatFormatting.UNDERLINE);
            xShift = (textWidth - font.m_92852_((FormattedText)chapTitle)) / 2;
            graphics.m_280614_(font, (Component)chapTitle, refX + textStartX + xShift + xPageShift, refY + 31, Color.TEXT_GRAY.color(), false);
        }
    }

    public record GraphicWrapper(int x, int y, AbstractGraphicWrapper<?> graphic, OnTooltip onTooltip, OnClick onClick, OnKeyPress onKeyPress) {
    }

    public record TextWrapper(int x, int y, FormattedText characters, Color color, boolean centered, OnTooltip onTooltip, OnClick onClick, OnKeyPress onKeyPress) {
    }
}

