/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.model.block.bakerytypes;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.client.model.block.ModelStateRotation;
import voltaic.client.model.block.modelproperties.ModelPropertyConnections;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.tile.types.IConnectTile;

public class CableModelLoader
implements IGeometryLoader<WirePartGeometry> {
    public static final String ID = "voltaiccableloader";
    public static final CableModelLoader INSTANCE = new CableModelLoader();

    public WirePartGeometry read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        BlockModel none = (BlockModel)context.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)EnumConnectType.NONE.toString()), BlockModel.class);
        BlockModel wire = (BlockModel)context.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)EnumConnectType.WIRE.toString()), BlockModel.class);
        BlockModel inventory = (BlockModel)context.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)EnumConnectType.INVENTORY.toString()), BlockModel.class);
        return new WirePartGeometry(none, wire, inventory);
    }

    public static class WirePartGeometry
    implements IUnbakedGeometry<WirePartGeometry> {
        private final BlockModel none;
        private final BlockModel wire;
        private final BlockModel inventory;

        public WirePartGeometry(BlockModel none, BlockModel wire, BlockModel inventory) {
            this.none = none;
            this.wire = wire;
            this.inventory = inventory;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            boolean useBlockLight = context.useBlockLight();
            BakedModel none = this.none.m_111449_(baker, this.none, spriteGetter, modelState, modelLocation, useBlockLight);
            BakedModel[] wires = new BakedModel[6];
            BakedModel[] inventories = new BakedModel[6];
            for (Direction dir : Direction.values()) {
                ModelState transform = ModelStateRotation.ROTATIONS.get(dir);
                wires[dir.ordinal()] = this.wire.m_111449_(baker, this.wire, spriteGetter, transform, modelLocation, useBlockLight);
                inventories[dir.ordinal()] = this.inventory.m_111449_(baker, this.inventory, spriteGetter, transform, modelLocation, useBlockLight);
            }
            return new CableModel(context.useAmbientOcclusion(), context.isGui3d(), useBlockLight, spriteGetter.apply(this.none.m_111480_("particle")), none, wires, inventories);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.none.m_5500_(modelGetter);
            this.wire.m_5500_(modelGetter);
            this.inventory.m_5500_(modelGetter);
        }

        public Set<String> getConfigurableComponentNames() {
            return super.getConfigurableComponentNames();
        }
    }

    public static class CableModel
    implements IDynamicBakedModel {
        private static final List<BakedQuad> NO_QUADS = ImmutableList.of();
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final BakedModel none;
        private final BakedModel[] wires;
        private final BakedModel[] inventories;

        public CableModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, BakedModel none, BakedModel[] wires, BakedModel[] inventories) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.none = none;
            this.wires = wires;
            this.inventories = inventories;
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return this.none.getRenderTypes(state, rand, data);
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
            @Nullable Supplier m = (Supplier)extraData.get((ModelProperty)ModelPropertyConnections.INSTANCE);
            if (m == null) {
                return NO_QUADS;
            }
            EnumConnectType[] data = (EnumConnectType[])m.get();
            if (data == null) {
                return NO_QUADS;
            }
            boolean none = false;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            block5: for (int i = 0; i < data.length; ++i) {
                switch (data[i]) {
                    case NONE: {
                        none = true;
                        continue block5;
                    }
                    case WIRE: {
                        quads.addAll(this.wires[i].getQuads(state, side, rand, extraData, renderType));
                        continue block5;
                    }
                    case INVENTORY: {
                        quads.addAll(this.inventories[i].getQuads(state, side, rand, extraData, renderType));
                        continue block5;
                    }
                    default: {
                        none = true;
                    }
                }
            }
            if (none) {
                quads.addAll(this.none.getQuads(state, side, rand, extraData, renderType));
            }
            return quads;
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IConnectTile) {
                IConnectTile tile = (IConnectTile)blockEntity;
                return ModelData.builder().with((ModelProperty)ModelPropertyConnections.INSTANCE, () -> tile.readConnections()).build();
            }
            return modelData;
        }
    }
}

