/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GrindedParticle
extends TextureSheetParticle {
    private final BlockState sourceState;
    private BlockPos sourcePos;
    private final float uCoord;
    private final float vCoord;

    public GrindedParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, BlockState state) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.sourceState = state;
        this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state));
        this.f_107226_ = 1.0f;
        this.f_107227_ = 0.6f;
        this.f_107228_ = 0.6f;
        this.f_107229_ = 0.6f;
        this.f_107663_ /= 2.0f;
        this.uCoord = this.f_107223_.m_188501_() * 3.0f;
        this.vCoord = this.f_107223_.m_188501_() * 3.0f;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    public GrindedParticle setBlockPos(BlockPos pos) {
        this.updateSprite(pos);
        this.sourcePos = pos;
        if (this.sourceState.m_60713_(Blocks.f_50440_)) {
            return this;
        }
        this.multiplyColor(pos);
        return this;
    }

    public GrindedParticle init() {
        this.sourcePos = new BlockPos((int)Math.floor(this.f_107212_), (int)Math.floor(this.f_107213_), (int)Math.floor(this.f_107214_));
        if (this.sourceState.m_60713_(Blocks.f_50440_)) {
            return this;
        }
        this.multiplyColor(this.sourcePos);
        return this;
    }

    protected void multiplyColor(@Nullable BlockPos pos) {
        int i = Minecraft.m_91087_().m_91298_().m_92577_(this.sourceState, (BlockAndTintGetter)this.f_107208_, pos, 0);
        this.f_107227_ *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.f_107228_ *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.f_107229_ *= (float)(i & 0xFF) / 255.0f;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uCoord + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uCoord / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vCoord / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vCoord + 1.0f) / 4.0f * 16.0f));
    }

    public int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        int j = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)new BlockPos((int)Math.floor(this.f_107212_), (int)Math.floor(this.f_107213_), (int)Math.floor(this.f_107214_)));
        return i == 0 ? j : i;
    }

    private void updateSprite(BlockPos pos) {
        if (pos != null) {
            this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().getTexture(this.sourceState, (Level)this.f_107208_, pos));
        }
    }
}

